/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.web.responsebodies;

import com.netgrif.application.engine.auth.domain.Author;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.web.responsebodies.Reference;
import com.netgrif.application.engine.workflow.web.responsebodies.DataFieldReference;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;

public class PetriNetReference
extends Reference {
    private String identifier;
    private String version;
    private String initials;
    private String defaultCaseName;
    private String icon;
    private LocalDateTime createdDate;
    private Author author;
    private List<DataFieldReference> immediateData;

    public PetriNetReference() {
    }

    public PetriNetReference(String stringId, String identifier, String version, String title, String initials, String defaultCaseName) {
        super(stringId, title);
        this.identifier = identifier;
        this.version = version;
        this.initials = initials;
        this.defaultCaseName = defaultCaseName;
    }

    public PetriNetReference(String stringId, String title, String identifier, String version, String initials, String icon, LocalDateTime createdDate, Author author) {
        super(stringId, title);
        this.identifier = identifier;
        this.version = version;
        this.initials = initials;
        this.icon = icon;
        this.createdDate = createdDate;
        this.author = author;
    }

    public PetriNetReference(PetriNet net, Locale locale) {
        this(net.getStringId(), net.getIdentifier(), net.getVersion().toString(), net.getTitle().getTranslation(locale), net.getInitials(), net.getTranslatedDefaultCaseName(locale));
        this.icon = net.getIcon();
        this.createdDate = net.getCreationDate();
        this.author = net.getAuthor();
        this.immediateData = net.getImmediateFields().stream().map(field -> new DataFieldReference((Field)field, locale)).collect(Collectors.toList());
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getInitials() {
        return this.initials;
    }

    @Generated
    public String getDefaultCaseName() {
        return this.defaultCaseName;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Author getAuthor() {
        return this.author;
    }

    @Generated
    public List<DataFieldReference> getImmediateData() {
        return this.immediateData;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setInitials(String initials) {
        this.initials = initials;
    }

    @Generated
    public void setDefaultCaseName(String defaultCaseName) {
        this.defaultCaseName = defaultCaseName;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setAuthor(Author author) {
        this.author = author;
    }

    @Generated
    public void setImmediateData(List<DataFieldReference> immediateData) {
        this.immediateData = immediateData;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PetriNetReference)) {
            return false;
        }
        PetriNetReference other = (PetriNetReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$initials = this.getInitials();
        String other$initials = other.getInitials();
        if (this$initials == null ? other$initials != null : !this$initials.equals(other$initials)) {
            return false;
        }
        String this$defaultCaseName = this.getDefaultCaseName();
        String other$defaultCaseName = other.getDefaultCaseName();
        if (this$defaultCaseName == null ? other$defaultCaseName != null : !this$defaultCaseName.equals(other$defaultCaseName)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        LocalDateTime this$createdDate = this.getCreatedDate();
        LocalDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Author this$author = this.getAuthor();
        Author other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        List<DataFieldReference> this$immediateData = this.getImmediateData();
        List<DataFieldReference> other$immediateData = other.getImmediateData();
        return !(this$immediateData == null ? other$immediateData != null : !((Object)this$immediateData).equals(other$immediateData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PetriNetReference;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $initials = this.getInitials();
        result = result * 59 + ($initials == null ? 43 : $initials.hashCode());
        String $defaultCaseName = this.getDefaultCaseName();
        result = result * 59 + ($defaultCaseName == null ? 43 : $defaultCaseName.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        LocalDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Author $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        List<DataFieldReference> $immediateData = this.getImmediateData();
        result = result * 59 + ($immediateData == null ? 43 : ((Object)$immediateData).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PetriNetReference(identifier=" + this.getIdentifier() + ", version=" + this.getVersion() + ", initials=" + this.getInitials() + ", defaultCaseName=" + this.getDefaultCaseName() + ", icon=" + this.getIcon() + ", createdDate=" + this.getCreatedDate() + ", author=" + this.getAuthor() + ", immediateData=" + this.getImmediateData() + ")";
    }
}

