/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.resource.domain;

import com.netgrif.application.engine.resource.domain.ExternalResource;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ExternalResourceLoader
implements ResourceLoader {
    public static final String RESOURCES_FOLDER = "resources";
    public static final String[] RESOURCE_PREFIXES = new String[]{"resource:", "nae:", "nae-resource:", "nr:"};
    public static final String DEFAULT_RESOURCE_PREFIX = RESOURCE_PREFIXES[0];
    public static final String NAE_RESOURCE_PREFIX = RESOURCE_PREFIXES[1];
    public static final String NAE_RESOURCE_RESOURCE_PREFIX = RESOURCE_PREFIXES[2];
    public static final String NR_RESOURCE_PREFIX = RESOURCE_PREFIXES[3];
    private final ResourceLoader delegate;

    public ExternalResourceLoader(ResourceLoader delegate) {
        this.delegate = delegate;
    }

    public Resource getResource(String location) {
        if (location.isBlank()) {
            return this.delegate.getResource(location);
        }
        Optional<String> detectedPrefix = ExternalResourceLoader.getExternalResourcePrefix(location);
        return detectedPrefix.isPresent() ? this.getResourceWithPrefix(location, detectedPrefix.get()) : this.delegate.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public static Optional<String> getExternalResourcePrefix(String location) {
        if (location == null || location.isBlank()) {
            return Optional.empty();
        }
        return Arrays.stream(RESOURCE_PREFIXES).filter(location.toLowerCase()::startsWith).findFirst();
    }

    private Resource getResourceWithPrefix(String location, String prefix) {
        String path = location.substring(prefix.length());
        ExternalResource resource = new ExternalResource();
        return resource.getResource(RESOURCES_FOLDER + File.pathSeparator + path);
    }
}

