/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.resource.service;

import com.netgrif.application.engine.resource.domain.ExternalResourceLoader;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class ExternalResourceLoaderProcessor
implements ResourceLoaderAware,
ProtocolResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalResourceLoaderProcessor.class);

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (DefaultResourceLoader.class.isAssignableFrom(resourceLoader.getClass())) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            log.error("Could not assign protocol for resource loader.");
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (ExternalResourceLoader.getExternalResourcePrefix(location).isPresent()) {
            ExternalResourceLoader loader = new ExternalResourceLoader(resourceLoader);
            return loader.getResource(location);
        }
        return null;
    }
}

