/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.rules.domain.facts;

import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.rules.domain.facts.CaseFact;
import com.netgrif.application.engine.workflow.domain.Task;
import lombok.Generated;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class TransitionEventFact
extends CaseFact {
    private String transitionId;
    private EventType type;
    private EventPhase phase;

    public TransitionEventFact(String caseId, String transitionId, EventType type, EventPhase phase) {
        super(caseId);
        this.transitionId = transitionId;
        this.type = type;
        this.phase = phase;
    }

    public static TransitionEventFact assign(Task task, EventPhase phase) {
        return TransitionEventFact.of(task, EventType.ASSIGN, phase);
    }

    public static TransitionEventFact cancel(Task task, EventPhase phase) {
        return TransitionEventFact.of(task, EventType.CANCEL, phase);
    }

    public static TransitionEventFact finish(Task task, EventPhase phase) {
        return TransitionEventFact.of(task, EventType.FINISH, phase);
    }

    public static TransitionEventFact of(Task task, EventType type, EventPhase phase) {
        return new TransitionEventFact(task.getCaseId(), task.getTransitionId(), type, phase);
    }

    public static TransitionEventFact of(String caseId, String transitionId, EventType type, EventPhase phase) {
        return new TransitionEventFact(caseId, transitionId, type, phase);
    }

    @Generated
    public String getTransitionId() {
        return this.transitionId;
    }

    @Generated
    public EventType getType() {
        return this.type;
    }

    @Generated
    public EventPhase getPhase() {
        return this.phase;
    }

    @Generated
    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    @Generated
    public void setType(EventType type) {
        this.type = type;
    }

    @Generated
    public void setPhase(EventPhase phase) {
        this.phase = phase;
    }

    @Override
    @Generated
    public String toString() {
        return "TransitionEventFact(transitionId=" + this.getTransitionId() + ", type=" + this.getType() + ", phase=" + this.getPhase() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransitionEventFact)) {
            return false;
        }
        TransitionEventFact other = (TransitionEventFact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$transitionId = this.getTransitionId();
        String other$transitionId = other.getTransitionId();
        if (this$transitionId == null ? other$transitionId != null : !this$transitionId.equals(other$transitionId)) {
            return false;
        }
        EventType this$type = this.getType();
        EventType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EventPhase this$phase = this.getPhase();
        EventPhase other$phase = other.getPhase();
        return !(this$phase == null ? other$phase != null : !((Object)((Object)this$phase)).equals((Object)other$phase));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransitionEventFact;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $transitionId = this.getTransitionId();
        result = result * 59 + ($transitionId == null ? 43 : $transitionId.hashCode());
        EventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EventPhase $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : ((Object)((Object)$phase)).hashCode());
        return result;
    }
}

