/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.rules.domain.scheduled;

import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.rules.domain.facts.ScheduledRuleFact;
import com.netgrif.application.engine.rules.domain.scheduled.RuleJob;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEngine;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PetriNetRuleEvaluationJob
extends RuleJob {
    public static final String NET_ID = "netId";
    private static final Logger log = LoggerFactory.getLogger(PetriNetRuleEvaluationJob.class);
    @Autowired
    private IRuleEngine ruleEngine;
    @Autowired
    private IPetriNetService petriNetService;

    @Override
    public void doExecute(JobExecutionContext context) {
        String netId = this.getInstanceId(context);
        log.info("Executing PetriNetRuleEvaluationJob for net " + netId + " of rule " + this.getRuleIdentifier(context));
        PetriNet net = this.petriNetService.getPetriNet(netId);
        this.ruleEngine.evaluateRules(net, new ScheduledRuleFact(netId, this.getRuleIdentifier(context)));
    }

    @Override
    public String getInstanceId(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)NET_ID);
    }
}

