/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.rules.domain.scheduled;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuleJob
implements Job {
    public static final String RULE_IDENTIFIER = "ruleIdentifier";
    private static final Logger log = LoggerFactory.getLogger(RuleJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String instanceId = this.getInstanceId(context);
        String ruleIdentifier = this.getRuleIdentifier(context);
        if (!this.validate(context)) {
            log.warn("Job does not have instanceId or ruleIdentifier! " + instanceId + ", " + ruleIdentifier);
            return;
        }
        try {
            this.doExecute(context);
        }
        catch (Exception e) {
            log.error("Failed scheduled rule evaluation", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }

    public boolean validate(JobExecutionContext context) {
        return this.getInstanceId(context) != null && this.getRuleIdentifier(context) != null;
    }

    public String getRuleIdentifier(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)RULE_IDENTIFIER);
    }

    public abstract void doExecute(JobExecutionContext var1);

    public abstract String getInstanceId(JobExecutionContext var1);
}

