/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.rules.service;

import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.rules.domain.RuleRepository;
import com.netgrif.application.engine.rules.domain.facts.CaseCreatedFact;
import com.netgrif.application.engine.rules.domain.facts.NetImportedFact;
import com.netgrif.application.engine.rules.domain.facts.ScheduledRuleFact;
import com.netgrif.application.engine.rules.domain.facts.TransitionEventFact;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEngine;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.Task;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Lookup;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public abstract class RuleEngine
implements IRuleEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleEngine.class);
    @Value(value="${rule-engine.rethrow-exceptions:#{false}}")
    protected boolean rethrowExceptions;
    @Autowired
    private RuleRepository ruleRepository;

    @Lookup
    protected abstract KieSession ruleEngine();

    @Override
    public int evaluateRules(Case useCase, CaseCreatedFact caseCreatedFact) {
        return this.evaluateWithFacts(Arrays.asList(useCase, caseCreatedFact));
    }

    @Override
    public int evaluateRules(Case useCase, Task task, TransitionEventFact transitionEventFact) {
        return this.evaluateWithFacts(Arrays.asList(useCase, task, transitionEventFact));
    }

    @Override
    public int evaluateRules(Case useCase, ScheduledRuleFact scheduledRuleFact) {
        return this.evaluateWithFacts(Arrays.asList(useCase, scheduledRuleFact));
    }

    @Override
    public int evaluateRules(PetriNet petriNet, NetImportedFact fact) {
        return this.evaluateWithFacts(Arrays.asList(petriNet, fact));
    }

    @Override
    public int evaluateRules(PetriNet petriNet, ScheduledRuleFact scheduledRuleFact) {
        return this.evaluateWithFacts(Arrays.asList(petriNet, scheduledRuleFact));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evaluateWithFacts(List<Object> facts) {
        if (this.ruleRepository.count() == 0L) {
            return 0;
        }
        KieSession session = null;
        int numberOfRulesExecuted = 0;
        try {
            session = this.createSession();
            facts.forEach(arg_0 -> ((KieSession)session).insert(arg_0));
            numberOfRulesExecuted = session.fireAllRules();
        }
        catch (Exception e) {
            log.error("Rule engine failure", (Throwable)e);
            if (this.rethrowExceptions) {
                throw e;
            }
        }
        finally {
            if (session != null) {
                session.destroy();
            }
        }
        return numberOfRulesExecuted;
    }

    protected KieSession createSession() {
        return this.ruleEngine();
    }
}

