/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.rules.service;

import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.rules.domain.RuleRepository;
import com.netgrif.application.engine.rules.domain.StoredRule;
import com.netgrif.application.engine.rules.domain.scheduled.CaseRuleEvaluationJob;
import com.netgrif.application.engine.rules.domain.scheduled.ScheduleOutcome;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEvaluationScheduleService;
import com.netgrif.application.engine.rules.service.throwable.RuleEvaluationScheduleException;
import com.netgrif.application.engine.workflow.domain.Case;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleEvaluationScheduleService
implements IRuleEvaluationScheduleService {
    private static final Logger log = LoggerFactory.getLogger(RuleEvaluationScheduleService.class);
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private RuleRepository ruleRepository;

    @Override
    public ScheduleOutcome scheduleRuleEvaluationForCase(Case useCase, String ruleIdentifier, TriggerBuilder<? extends Trigger> triggerBuilder) throws RuleEvaluationScheduleException {
        return this.scheduleRuleEvaluationForCase(useCase, Collections.singletonList(ruleIdentifier), triggerBuilder).values().iterator().next();
    }

    @Override
    public Map<String, ScheduleOutcome> scheduleRuleEvaluationForCase(Case useCase, List<String> ruleIdentifiers, TriggerBuilder<? extends Trigger> triggerBuilder) throws RuleEvaluationScheduleException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("caseId", useCase.getStringId());
        return this.scheduleRuleEvaluation(useCase.getStringId(), data, ruleIdentifiers, triggerBuilder);
    }

    @Override
    public ScheduleOutcome scheduleRuleEvaluationForNet(PetriNet petriNet, String ruleIdentifier, TriggerBuilder<? extends Trigger> triggerBuilder) throws RuleEvaluationScheduleException {
        return this.scheduleRuleEvaluationForNet(petriNet, Collections.singletonList(ruleIdentifier), triggerBuilder).values().iterator().next();
    }

    @Override
    public Map<String, ScheduleOutcome> scheduleRuleEvaluationForNet(PetriNet petriNet, List<String> ruleIdentifiers, TriggerBuilder<? extends Trigger> triggerBuilder) throws RuleEvaluationScheduleException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("netId", petriNet.getStringId());
        return this.scheduleRuleEvaluation(petriNet.getStringId(), data, ruleIdentifiers, triggerBuilder);
    }

    private void schedule(String stringId, String ruleId, JobDetail jobDetail, Trigger trigger) throws RuleEvaluationScheduleException {
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            log.error("Failed to schedule Rule evaluation for " + stringId + " of rule " + ruleId, (Throwable)e);
            throw new RuleEvaluationScheduleException(e);
        }
    }

    public Map<String, ScheduleOutcome> scheduleRuleEvaluation(String instanceId, Map<String, String> jobData, List<String> ruleIdentifiers, TriggerBuilder<? extends Trigger> triggerBuilder) throws RuleEvaluationScheduleException {
        List<StoredRule> storedRules = this.ruleRepository.findByIdentifierIn(ruleIdentifiers);
        HashMap<String, ScheduleOutcome> outcomes = new HashMap<String, ScheduleOutcome>();
        for (StoredRule rule : storedRules) {
            log.info("Scheduling rule eval job for " + instanceId + " " + rule.getIdentifier());
            JobDetail jobDetail = this.buildJobDetail(instanceId, rule, CaseRuleEvaluationJob.class);
            Trigger trigger = this.buildTrigger(instanceId, triggerBuilder, jobDetail);
            jobDetail.getJobDataMap().putAll(jobData);
            this.schedule(instanceId, rule.getStringId(), jobDetail, trigger);
            outcomes.put(rule.getIdentifier(), new ScheduleOutcome(jobDetail, trigger));
        }
        return outcomes;
    }

    protected <T extends Job> JobDetail buildJobDetail(String instanceStringId, StoredRule rule, Class<T> type) {
        JobDetail jobDetail = JobBuilder.newJob().ofType(type).storeDurably(false).withIdentity(instanceStringId + "-" + rule.getStringId() + "-" + UUID.randomUUID().toString()).withDescription("Scheduled eval for " + instanceStringId + " of rule " + rule.getStringId()).build();
        jobDetail.getJobDataMap().put("ruleIdentifier", rule.getIdentifier());
        return jobDetail;
    }

    protected Trigger buildTrigger(String instanceStringId, TriggerBuilder<? extends Trigger> triggerBuilder, JobDetail jobDetail) {
        return triggerBuilder.withIdentity("trigger" + instanceStringId + "-" + jobDetail.getKey().toString() + "-" + UUID.randomUUID().toString()).withDescription("Trigger for " + instanceStringId + " for job " + jobDetail.getKey().toString()).build();
    }
}

