/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.security.service;

import com.netgrif.application.engine.security.service.IEncryptionService;
import java.security.Provider;
import java.util.HashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EncryptionService
implements IEncryptionService {
    private final String PREFIX = "#encrypted";
    @Autowired
    private StandardPBEStringEncryptor standardEncryptor;
    @Value(value="${nae.database.password}")
    private String PASSWORD;
    @Value(value="${nae.database.algorithm}")
    private String STANDARD_ALGORITHM;
    private HashMap<String, StandardPBEStringEncryptor> encryptors = new HashMap();

    @Override
    public String encrypt(String value) {
        return this.encrypt(value, this.standardEncryptor);
    }

    @Override
    public String encrypt(String value, String algorithm) {
        StandardPBEStringEncryptor encryptor = this.getEncryptor(algorithm);
        return this.encrypt(value, encryptor);
    }

    @Override
    public String decrypt(String value) {
        return this.decrypt(value, this.standardEncryptor);
    }

    @Override
    public String decrypt(String value, String algorithm) {
        StandardPBEStringEncryptor encryptor = this.getEncryptor(algorithm);
        return this.decrypt(value, encryptor);
    }

    private String encrypt(String value, StandardPBEStringEncryptor encryptor) {
        if (value != null && !value.contains("#encrypted")) {
            return "#encrypted" + encryptor.encrypt(value);
        }
        return value;
    }

    private String decrypt(String value, StandardPBEStringEncryptor encryptor) {
        if (value != null && value.contains("#encrypted")) {
            return encryptor.decrypt(value.substring("#encrypted".length()));
        }
        return value;
    }

    private StandardPBEStringEncryptor getEncryptor(String algorithm) {
        StandardPBEStringEncryptor encryptor = this.encryptors.get(algorithm);
        if (encryptor != null) {
            return encryptor;
        }
        return this.createEncryptor(algorithm);
    }

    private StandardPBEStringEncryptor createEncryptor(String algorithm) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(algorithm);
        encryptor.setPassword(this.PASSWORD);
        encryptor.setProvider((Provider)new BouncyCastleProvider());
        this.encryptors.put(algorithm, encryptor);
        return encryptor;
    }
}

