/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.security.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SecurityContextService
implements ISecurityContextService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityContextService.class);
    private final Set<String> cachedTokens = ConcurrentHashMap.newKeySet();
    protected IUserService userService;

    protected SecurityContextService() {
    }

    @Override
    public void saveToken(String token) {
        this.cachedTokens.add(token);
    }

    @Override
    public void reloadSecurityContext(LoggedUser loggedUser) {
        this.reloadSecurityContext(loggedUser, false);
    }

    @Override
    public void forceReloadSecurityContext(LoggedUser loggedUser) {
        this.reloadSecurityContext(loggedUser, true);
    }

    private void reloadSecurityContext(LoggedUser loggedUser, boolean forceRefresh) {
        if (this.isUserLogged(loggedUser) && this.cachedTokens.contains(loggedUser.getId())) {
            if (forceRefresh) {
                loggedUser = this.userService.findById(loggedUser.getId(), false).transformToLoggedUser();
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)loggedUser, SecurityContextHolder.getContext().getAuthentication().getCredentials(), loggedUser.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            this.clearToken(loggedUser.getId());
        }
    }

    @Override
    public boolean isAuthenticatedPrincipalLoggedUser() {
        return SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof LoggedUser;
    }

    private void clearToken(String token) {
        if (this.cachedTokens.contains(token)) {
            this.cachedTokens.remove(token);
        }
    }

    private boolean isUserLogged(LoggedUser loggedUser) {
        if (this.isAuthenticatedPrincipalLoggedUser()) {
            return ((LoggedUser)((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal())).getId().equals(loggedUser.getId());
        }
        return false;
    }

    @Autowired
    @Lazy
    public void setUserService(IUserService userService) {
        this.userService = userService;
    }
}

