/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.startup;

import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.VersionType;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.startup.AbstractOrderedCommandLineRunner;
import com.netgrif.application.engine.startup.ImportHelper;
import com.netgrif.application.engine.startup.SystemUserRunner;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.Optional;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilterRunner
extends AbstractOrderedCommandLineRunner {
    @Autowired
    private IPetriNetService petriNetService;
    @Autowired
    private ImportHelper helper;
    @Autowired
    private SystemUserRunner systemCreator;
    private static final String FILTER_FILE_NAME = "engine-processes/filter.xml";
    public static final String FILTER_PETRI_NET_IDENTIFIER = "filter";
    private static final String PREFERRED_ITEM_FILE_NAME = "engine-processes/preference_item.xml";
    public static final String PREFERRED_ITEM_NET_IDENTIFIER = "preference_item";
    private static final String EXPORT_FILTER_FILE_NAME = "engine-processes/export_filters.xml";
    private static final String EXPORT_NET_IDENTIFIER = "export_filters";
    private static final String IMPORT_FILTER_FILE_NAME = "engine-processes/import_filters.xml";
    private static final String IMPORT_NET_IDENTIFIER = "import_filters";
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FilterRunner() {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
    }

    public void run(String ... args) throws Exception {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this);
            callSiteArray[1].callCurrent((GroovyObject)this);
            callSiteArray[2].callCurrent((GroovyObject)this);
            callSiteArray[3].callCurrent((GroovyObject)this);
        } else {
            this.createFilterNet();
            this.createPreferenceItemNet();
            this.createImportFiltersNet();
            this.createExportFiltersNet();
        }
    }

    public Optional<PetriNet> createFilterNet() {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callCurrent((GroovyObject)this, (Object)"Petri net for filters", (Object)FILTER_PETRI_NET_IDENTIFIER, (Object)FILTER_FILE_NAME), Optional.class);
        }
        return this.importProcess("Petri net for filters", FILTER_PETRI_NET_IDENTIFIER, FILTER_FILE_NAME);
    }

    public Optional<PetriNet> createPreferenceItemNet() {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callCurrent((GroovyObject)this, (Object)"Petri net for filter preferences", (Object)PREFERRED_ITEM_NET_IDENTIFIER, (Object)PREFERRED_ITEM_FILE_NAME), Optional.class);
        }
        return this.importProcess("Petri net for filter preferences", PREFERRED_ITEM_NET_IDENTIFIER, PREFERRED_ITEM_FILE_NAME);
    }

    public Optional<PetriNet> createImportFiltersNet() {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this, (Object)"Petri net for importing filters", (Object)IMPORT_NET_IDENTIFIER, (Object)IMPORT_FILTER_FILE_NAME), Optional.class);
        }
        return this.importProcess("Petri net for importing filters", IMPORT_NET_IDENTIFIER, IMPORT_FILTER_FILE_NAME);
    }

    public Optional<PetriNet> createExportFiltersNet() {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)"Petri net for exporting filters", (Object)EXPORT_NET_IDENTIFIER, (Object)EXPORT_FILTER_FILE_NAME), Optional.class);
        }
        return this.importProcess("Petri net for exporting filters", EXPORT_NET_IDENTIFIER, EXPORT_FILTER_FILE_NAME);
    }

    public Optional<PetriNet> importProcess(String message, String netIdentifier, String netFileName) {
        CallSite[] callSiteArray = FilterRunner.$getCallSiteArray();
        PetriNet filter = (PetriNet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)this.petriNetService, (Object)netIdentifier), PetriNet.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)filter, null)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call((Object)log)) ? callSiteArray[10].call((Object)log, (Object)new GStringImpl(new Object[]{message}, new String[]{"", " has already been imported."})) : null;
            return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(Optional.class, (Object)filter), Optional.class);
        }
        Optional filterNet = (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call((Object)this.helper, (Object)netFileName, callSiteArray[13].callGetProperty(VersionType.class), callSiteArray[14].callGroovyObjectGetProperty((Object)this.systemCreator)), Optional.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call((Object)filterNet))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)log)) ? callSiteArray[17].call((Object)log, (Object)new GStringImpl(new Object[]{message}, new String[]{"Import of ", " failed!"})) : null;
        }
        return filterNet;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FilterRunner.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = FilterRunner.$getCallSiteArray()[18].call(LoggerFactory.class, (Object)"com.netgrif.application.engine.startup.FilterRunner");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "createFilterNet";
        stringArray[1] = "createPreferenceItemNet";
        stringArray[2] = "createImportFiltersNet";
        stringArray[3] = "createExportFiltersNet";
        stringArray[4] = "importProcess";
        stringArray[5] = "importProcess";
        stringArray[6] = "importProcess";
        stringArray[7] = "importProcess";
        stringArray[8] = "getNewestVersionByIdentifier";
        stringArray[9] = "isInfoEnabled";
        stringArray[10] = "info";
        stringArray[11] = "of";
        stringArray[12] = "createNet";
        stringArray[13] = "MAJOR";
        stringArray[14] = "loggedSystem";
        stringArray[15] = "isPresent";
        stringArray[16] = "isErrorEnabled";
        stringArray[17] = "error";
        stringArray[18] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[19];
        FilterRunner.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FilterRunner.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FilterRunner.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

