/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.netgrif.application.engine.utils.SingleItemAsList;
import java.io.IOException;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

public class SingleItemAsListDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private Class<?> itemClass;

    protected SingleItemAsListDeserializer() {
        this(null);
    }

    protected SingleItemAsListDeserializer(Class<? extends SingleItemAsList> vc) {
        super(vc);
        if (vc != null) {
            this.itemClass = vc.getAnnotation(JsonDeserialize.class).contentAs();
        }
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        JavaType type = beanProperty != null ? beanProperty.getType() : deserializationContext.getContextualType();
        return new SingleItemAsListDeserializer(type.getRawClass());
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, IllegalArgumentException {
        SingleItemAsList wrapper;
        try {
            wrapper = (SingleItemAsList)this._valueClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("SingleItemAsList object could not be instantiated", e);
        }
        ObjectMapper innerDeserializer = new ObjectMapper();
        JsonNode node = (JsonNode)innerDeserializer.readTree(jsonParser);
        try {
            Object request = innerDeserializer.convertValue((Object)node, this.itemClass);
            wrapper.getList().add(request);
        }
        catch (IllegalArgumentException singleItemException) {
            try {
                List requests = (List)innerDeserializer.convertValue((Object)node, (JavaType)innerDeserializer.getTypeFactory().constructCollectionType(List.class, this.itemClass));
                wrapper.getList().addAll(requests);
            }
            catch (IllegalArgumentException arrayException) {
                if (node.isArray()) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Single item as list deserialization failed. List deserialization exception: " + arrayException.getMessage(), (Throwable)arrayException);
                }
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Single item as list deserialization failed. Single item deserialization exception: " + singleItemException.getMessage(), (Throwable)singleItemException);
            }
        }
        return wrapper;
    }
}

