/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netgrif.application.engine.auth.domain.Author;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.dataset.ChoiceField;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldWithAllowedNets;
import com.netgrif.application.engine.petrinet.domain.dataset.FilterField;
import com.netgrif.application.engine.petrinet.domain.dataset.MapOptionsField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListField;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.roles.RolePermission;
import com.netgrif.application.engine.workflow.domain.DataField;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.TaskPair;
import com.netgrif.application.engine.workflow.service.interfaces.IInitValueExpressionEvaluator;
import java.io.Serializable;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document
public class Case
implements Serializable {
    private static final long serialVersionUID = 3687481049847498422L;
    @Id
    private ObjectId _id;
    private String uriNodeId;
    @LastModifiedDate
    private LocalDateTime lastModified;
    private String visualId;
    @NotNull
    private ObjectId petriNetObjectId;
    @JsonIgnore
    @Transient
    private PetriNet petriNet;
    @NotNull
    @Indexed
    private String processIdentifier;
    @Field(value="activePlaces")
    @JsonIgnore
    private Map<String, Integer> activePlaces;
    @NotNull
    private String title;
    private String color;
    private String icon;
    private LocalDateTime creationDate;
    @JsonIgnore
    private LinkedHashMap<String, DataField> dataSet;
    @JsonIgnore
    private LinkedHashSet<String> immediateDataFields;
    @Transient
    private List<com.netgrif.application.engine.petrinet.domain.dataset.Field> immediateData;
    @Indexed
    private Author author;
    @JsonIgnore
    private Map<String, Integer> consumedTokens;
    private Set<TaskPair> tasks;
    @JsonIgnore
    private Set<String> enabledRoles;
    private Map<String, Map<String, Boolean>> permissions;
    private Map<String, Map<String, Boolean>> userRefs = new HashMap<String, Map<String, Boolean>>();
    private Map<String, Map<String, Boolean>> users = new HashMap<String, Map<String, Boolean>>();
    private List<String> viewRoles;
    @JsonIgnore
    private List<String> viewUserRefs;
    @JsonIgnore
    private List<String> viewUsers;
    private List<String> negativeViewRoles;
    private List<String> negativeViewUsers;
    private Map<String, String> tags;

    protected Case() {
        this._id = new ObjectId();
        this.activePlaces = new HashMap<String, Integer>();
        this.dataSet = new LinkedHashMap();
        this.immediateDataFields = new LinkedHashSet();
        this.consumedTokens = new HashMap<String, Integer>();
        this.tasks = new HashSet<TaskPair>();
        this.visualId = this.generateVisualId();
        this.enabledRoles = new HashSet<String>();
        this.permissions = new HashMap<String, Map<String, Boolean>>();
        this.userRefs = new HashMap<String, Map<String, Boolean>>();
        this.users = new HashMap<String, Map<String, Boolean>>();
        this.viewRoles = new LinkedList<String>();
        this.viewUserRefs = new LinkedList<String>();
        this.viewUsers = new LinkedList<String>();
        this.negativeViewRoles = new LinkedList<String>();
        this.negativeViewUsers = new ArrayList<String>();
        this.tags = new HashMap<String, String>();
    }

    public Case(PetriNet petriNet) {
        this();
        this.petriNetObjectId = petriNet.getObjectId();
        this.processIdentifier = petriNet.getIdentifier();
        this.petriNet = petriNet;
        this.activePlaces = petriNet.getActivePlaces();
        this.immediateDataFields = petriNet.getImmediateFields().stream().map(com.netgrif.application.engine.petrinet.domain.dataset.Field::getStringId).collect(Collectors.toCollection(LinkedHashSet::new));
        this.visualId = this.generateVisualId();
        this.enabledRoles = petriNet.getRoles().keySet();
        this.negativeViewRoles.addAll(petriNet.getNegativeViewRoles());
        this.icon = petriNet.getIcon();
        this.userRefs = petriNet.getUserRefs();
        this.tags = new HashMap<String, String>(petriNet.getTags());
        this.permissions = petriNet.getPermissions().entrySet().stream().filter(role -> ((Map)role.getValue()).containsKey("delete") || ((Map)role.getValue()).containsKey("view")).map(role -> {
            HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
            if (((Map)role.getValue()).containsKey("delete")) {
                permissionMap.put("delete", (Boolean)((Map)role.getValue()).get("delete"));
            }
            if (((Map)role.getValue()).containsKey("view")) {
                permissionMap.put("view", (Boolean)((Map)role.getValue()).get("view"));
            }
            return new AbstractMap.SimpleEntry((String)role.getKey(), permissionMap);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.resolveViewRoles();
        this.resolveViewUserRefs();
    }

    public String getStringId() {
        return this._id.toString();
    }

    public void setColor(String color) {
        this.color = color == null || color.isEmpty() ? "color-fg-fm-500" : color;
    }

    public boolean hasFieldBehavior(String field, String transition) {
        return this.dataSet.get(field).hasDefinedBehavior(transition);
    }

    public void populateDataSet(IInitValueExpressionEvaluator initValueExpressionEvaluator, Map<String, String> params) {
        LinkedList dynamicInitFields = new LinkedList();
        LinkedList dynamicOptionsFields = new LinkedList();
        LinkedList dynamicChoicesFields = new LinkedList();
        this.petriNet.getDataSet().forEach((key, field) -> {
            if (field.isDynamicDefaultValue()) {
                dynamicInitFields.add(field);
                this.dataSet.put((String)key, new DataField());
            } else {
                this.dataSet.put((String)key, new DataField(field.getDefaultValue()));
            }
            if (field.getComponent() != null) {
                this.dataSet.get(key).setComponent(field.getComponent());
            }
            if (field instanceof UserField) {
                this.dataSet.get(key).setChoices(((UserField)field).getRoles().stream().map(I18nString::new).collect(Collectors.toSet()));
            }
            if (field instanceof UserListField) {
                this.dataSet.get(key).setChoices(((UserListField)field).getRoles().stream().map(I18nString::new).collect(Collectors.toSet()));
            }
            if (field instanceof FieldWithAllowedNets) {
                this.dataSet.get(key).setAllowedNets(((FieldWithAllowedNets)field).getAllowedNets());
            }
            if (field instanceof FilterField) {
                this.dataSet.get(key).setFilterMetadata(((FilterField)field).getFilterMetadata());
            }
            if (field instanceof MapOptionsField && ((MapOptionsField)field).isDynamic()) {
                dynamicOptionsFields.add((MapOptionsField)field);
            }
            if (field instanceof ChoiceField && ((ChoiceField)field).isDynamic()) {
                dynamicChoicesFields.add((ChoiceField)field);
            }
        });
        dynamicInitFields.forEach(field -> this.dataSet.get(field.getImportId()).setValue(initValueExpressionEvaluator.evaluate(this, field, params)));
        dynamicChoicesFields.forEach(field -> this.dataSet.get(field.getImportId()).setChoices(initValueExpressionEvaluator.evaluateChoices(this, (ChoiceField<?>)field, params)));
        dynamicOptionsFields.forEach(field -> this.dataSet.get(field.getImportId()).setOptions(initValueExpressionEvaluator.evaluateOptions(this, (MapOptionsField<I18nString, ?>)field, params)));
        this.populateDataSetBehaviorAndComponents();
    }

    private void populateDataSetBehaviorAndComponents() {
        this.petriNet.getTransitions().forEach((transitionKey, transitionValue) -> transitionValue.getDataSet().forEach((dataKey, dataValue) -> {
            this.getDataSet().get(dataKey).addBehavior((String)transitionKey, (Set<FieldBehavior>)new HashSet<FieldBehavior>(dataValue.getBehavior()));
            if (dataValue.getComponent() != null) {
                this.getDataSet().get(dataKey).addDataRefComponent((String)transitionKey, dataValue.getComponent());
            }
        }));
    }

    private String generateVisualId() {
        SecureRandom random = new SecureRandom();
        int n = this._id.getTimestamp() + random.nextInt(99999999);
        if (this.title != null) {
            n += this.title.length();
        }
        if (this.petriNet != null) {
            return this.petriNet.getInitials() + "-" + n;
        }
        return "" + n;
    }

    public Object getFieldValue(String fieldId) {
        return this.dataSet.get(fieldId).getValue();
    }

    public boolean addTask(Task task) {
        return this.tasks.add(new TaskPair(task.getStringId(), task.getTransitionId()));
    }

    public boolean removeTask(Task task) {
        return this.removeTasks(Collections.singletonList(task));
    }

    public boolean removeTasks(List<Task> tasks) {
        int sizeBeforeChange = this.tasks.size();
        Set tasksTransitions = tasks.stream().map(Task::getTransitionId).collect(Collectors.toSet());
        this.tasks = this.tasks.stream().filter(pair -> !tasksTransitions.contains(pair.getTransition())).collect(Collectors.toSet());
        return this.tasks.size() != sizeBeforeChange;
    }

    public com.netgrif.application.engine.petrinet.domain.dataset.Field getField(String id) {
        return this.petriNet.getDataSet().get(id);
    }

    public DataField getDataField(String id) {
        return this.dataSet.get(id);
    }

    public String getPetriNetId() {
        return this.petriNetObjectId.toString();
    }

    public void addUsers(Set<String> userIds, Map<String, Boolean> permissions) {
        userIds.forEach(userId -> {
            if (this.users.containsKey(userId) && this.users.get(userId) != null) {
                this.compareExistingUserPermissions((String)userId, (Map<String, Boolean>)new HashMap<String, Boolean>(permissions));
            } else {
                this.users.put((String)userId, new HashMap(permissions));
            }
        });
    }

    public void resolveViewRoles() {
        this.getViewRoles();
        this.viewRoles.clear();
        this.permissions.forEach((role, perms) -> {
            if (perms.containsKey(RolePermission.VIEW.getValue()) && ((Boolean)perms.get(RolePermission.VIEW.getValue())).booleanValue()) {
                this.viewRoles.add((String)role);
            }
        });
    }

    public void resolveViewUserRefs() {
        this.getViewUserRefs();
        this.viewUserRefs.clear();
        this.userRefs.forEach((userRef, perms) -> {
            if (perms.containsKey(RolePermission.VIEW.getValue()) && ((Boolean)perms.get(RolePermission.VIEW.getValue())).booleanValue()) {
                this.viewUserRefs.add((String)userRef);
            }
        });
    }

    public void resolveViewUsers() {
        this.getViewUsers();
        this.viewUsers.clear();
        this.users.forEach((user, perms) -> {
            if (perms.containsKey(RolePermission.VIEW.getValue()) && ((Boolean)perms.get(RolePermission.VIEW.getValue())).booleanValue()) {
                this.viewUsers.add((String)user);
            }
        });
    }

    private void compareExistingUserPermissions(String userId, Map<String, Boolean> permissions) {
        permissions.forEach((id, perm) -> {
            if (this.users.containsKey(userId) && !this.users.get(userId).containsKey(id) || this.users.containsKey(userId) && this.users.get(userId).containsKey(id) && this.users.get(userId).get(id).booleanValue()) {
                this.users.get(userId).put((String)id, (Boolean)perm);
            }
        });
    }

    @Generated
    public ObjectId get_id() {
        return this._id;
    }

    @Generated
    public String getUriNodeId() {
        return this.uriNodeId;
    }

    @Generated
    public void setUriNodeId(String uriNodeId) {
        this.uriNodeId = uriNodeId;
    }

    @Generated
    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    @Generated
    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public String getVisualId() {
        return this.visualId;
    }

    @Generated
    public ObjectId getPetriNetObjectId() {
        return this.petriNetObjectId;
    }

    @Generated
    public void setPetriNetObjectId(ObjectId petriNetObjectId) {
        this.petriNetObjectId = petriNetObjectId;
    }

    @Generated
    public PetriNet getPetriNet() {
        return this.petriNet;
    }

    @JsonIgnore
    @Generated
    public void setPetriNet(PetriNet petriNet) {
        this.petriNet = petriNet;
    }

    @Generated
    public String getProcessIdentifier() {
        return this.processIdentifier;
    }

    @Generated
    public void setProcessIdentifier(String processIdentifier) {
        this.processIdentifier = processIdentifier;
    }

    @Generated
    public Map<String, Integer> getActivePlaces() {
        return this.activePlaces;
    }

    @JsonIgnore
    @Generated
    public void setActivePlaces(Map<String, Integer> activePlaces) {
        this.activePlaces = activePlaces;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public LinkedHashMap<String, DataField> getDataSet() {
        return this.dataSet;
    }

    @JsonIgnore
    @Generated
    public void setDataSet(LinkedHashMap<String, DataField> dataSet) {
        this.dataSet = dataSet;
    }

    @Generated
    public LinkedHashSet<String> getImmediateDataFields() {
        return this.immediateDataFields;
    }

    @JsonIgnore
    @Generated
    public void setImmediateDataFields(LinkedHashSet<String> immediateDataFields) {
        this.immediateDataFields = immediateDataFields;
    }

    @Generated
    public List<com.netgrif.application.engine.petrinet.domain.dataset.Field> getImmediateData() {
        return this.immediateData;
    }

    @Generated
    public void setImmediateData(List<com.netgrif.application.engine.petrinet.domain.dataset.Field> immediateData) {
        this.immediateData = immediateData;
    }

    @Generated
    public Author getAuthor() {
        return this.author;
    }

    @Generated
    public void setAuthor(Author author) {
        this.author = author;
    }

    @Generated
    public Map<String, Integer> getConsumedTokens() {
        return this.consumedTokens;
    }

    @JsonIgnore
    @Generated
    public void setConsumedTokens(Map<String, Integer> consumedTokens) {
        this.consumedTokens = consumedTokens;
    }

    @Generated
    public Set<TaskPair> getTasks() {
        return this.tasks;
    }

    @Generated
    public void setTasks(Set<TaskPair> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public Set<String> getEnabledRoles() {
        return this.enabledRoles;
    }

    @JsonIgnore
    @Generated
    public void setEnabledRoles(Set<String> enabledRoles) {
        this.enabledRoles = enabledRoles;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getPermissions() {
        return this.permissions;
    }

    @Generated
    public void setPermissions(Map<String, Map<String, Boolean>> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUserRefs() {
        return this.userRefs;
    }

    @Generated
    public void setUserRefs(Map<String, Map<String, Boolean>> userRefs) {
        this.userRefs = userRefs;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUsers() {
        return this.users;
    }

    @Generated
    public void setUsers(Map<String, Map<String, Boolean>> users) {
        this.users = users;
    }

    @Generated
    public List<String> getViewRoles() {
        return this.viewRoles;
    }

    @Generated
    public void setViewRoles(List<String> viewRoles) {
        this.viewRoles = viewRoles;
    }

    @Generated
    public List<String> getViewUserRefs() {
        return this.viewUserRefs;
    }

    @JsonIgnore
    @Generated
    public void setViewUserRefs(List<String> viewUserRefs) {
        this.viewUserRefs = viewUserRefs;
    }

    @Generated
    public List<String> getViewUsers() {
        return this.viewUsers;
    }

    @JsonIgnore
    @Generated
    public void setViewUsers(List<String> viewUsers) {
        this.viewUsers = viewUsers;
    }

    @Generated
    public List<String> getNegativeViewRoles() {
        return this.negativeViewRoles;
    }

    @Generated
    public void setNegativeViewRoles(List<String> negativeViewRoles) {
        this.negativeViewRoles = negativeViewRoles;
    }

    @Generated
    public List<String> getNegativeViewUsers() {
        return this.negativeViewUsers;
    }

    @Generated
    public void setNegativeViewUsers(List<String> negativeViewUsers) {
        this.negativeViewUsers = negativeViewUsers;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

