/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netgrif.application.engine.petrinet.domain.Component;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Referencable;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.validation.Validation;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryType;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;

public class DataField
implements Referencable,
Serializable {
    private static final long serialVersionUID = 3287600516604188694L;
    private Map<String, Set<FieldBehavior>> behavior = new HashMap<String, Set<FieldBehavior>>();
    private Object value;
    private Set<I18nString> choices;
    private List<String> allowedNets;
    private Map<String, I18nString> options;
    private List<Validation> validations;
    private Map<String, Object> filterMetadata;
    @JsonIgnore
    private String encryption;
    private LocalDateTime lastModified;
    private Long version = 0L;
    private Map<String, Component> dataRefComponents = new HashMap<String, Component>();
    private Component component;

    public DataField() {
    }

    public DataField(Object value) {
        this();
        this.value = value;
    }

    public void setBehavior(Map<String, Set<FieldBehavior>> behavior) {
        this.behavior = behavior;
        this.update();
    }

    public void setValue(Object value) {
        this.value = value;
        this.update();
    }

    public void setChoices(Set<I18nString> choices) {
        this.choices = choices;
        this.update();
    }

    public void setAllowedNets(List<String> allowedNets) {
        this.allowedNets = allowedNets;
        this.update();
    }

    public void setFilterMetadata(Map<String, Object> filterMetadata) {
        this.filterMetadata = filterMetadata;
        this.update();
    }

    public void setOptions(Map<String, I18nString> options) {
        this.options = options;
        this.update();
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
        this.update();
    }

    public ObjectNode applyBehavior(String transition, ObjectNode json) {
        this.behavior.get(transition).forEach(behav -> json.put(behav.toString(), true));
        return json;
    }

    public ObjectNode applyBehavior(String transition) {
        return this.applyBehavior(transition, JsonNodeFactory.instance.objectNode());
    }

    public void addBehavior(String transition, Set<FieldBehavior> behavior) {
        if (this.hasDefinedBehavior(transition) && this.behavior.get(transition) != null) {
            this.behavior.get(transition).addAll(behavior);
        } else {
            this.behavior.put(transition, new HashSet<FieldBehavior>(behavior));
        }
    }

    public void addDataRefComponent(String transition, Component component) {
        this.dataRefComponents.put(transition, component);
    }

    public boolean hasComponent(String transition) {
        return this.dataRefComponents.containsKey(transition);
    }

    public boolean hasComponent() {
        return this.component != null;
    }

    public ObjectNode applyOnlyVisibleBehavior() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put(FieldBehavior.VISIBLE.toString(), true);
        return node;
    }

    public boolean hasDefinedBehavior(String transition) {
        return this.behavior.containsKey(transition);
    }

    public boolean isDisplayable(String transition) {
        return this.behavior.containsKey(transition) && (this.behavior.get(transition).contains((Object)FieldBehavior.VISIBLE) || this.behavior.get(transition).contains((Object)FieldBehavior.EDITABLE) || this.behavior.get(transition).contains((Object)FieldBehavior.HIDDEN));
    }

    public boolean isRequired(String transitionId) {
        return this.behavior.containsKey(transitionId) && this.behavior.get(transitionId).contains((Object)FieldBehavior.REQUIRED);
    }

    public boolean isVisible(String transitionId) {
        return this.behavior.containsKey(transitionId) && this.behavior.get(transitionId).contains((Object)FieldBehavior.VISIBLE);
    }

    public boolean isUndefined(String transitionId) {
        return !this.behavior.containsKey(transitionId);
    }

    public boolean isDisplayable() {
        return ((Stream)this.behavior.values().stream().parallel()).anyMatch(bs -> bs.contains((Object)FieldBehavior.VISIBLE) || bs.contains((Object)FieldBehavior.EDITABLE) || bs.contains((Object)FieldBehavior.HIDDEN));
    }

    public boolean isForbidden(String transitionId) {
        return this.behavior.containsKey(transitionId) && this.behavior.get(transitionId).contains((Object)FieldBehavior.FORBIDDEN);
    }

    public void makeVisible(String transition) {
        this.changeBehavior(FieldBehavior.VISIBLE, transition);
    }

    public void makeEditable(String transition) {
        this.changeBehavior(FieldBehavior.EDITABLE, transition);
    }

    public void makeRequired(String transition) {
        this.changeBehavior(FieldBehavior.REQUIRED, transition);
    }

    public void makeOptional(String transition) {
        this.changeBehavior(FieldBehavior.OPTIONAL, transition);
    }

    public void makeHidden(String transition) {
        this.changeBehavior(FieldBehavior.HIDDEN, transition);
    }

    public void makeForbidden(String transition) {
        this.changeBehavior(FieldBehavior.FORBIDDEN, transition);
    }

    private void changeBehavior(FieldBehavior behavior, String transition) {
        List<FieldBehavior> tmp = Arrays.asList(behavior.getAntonyms());
        tmp.forEach(beh -> this.behavior.get(transition).remove(beh));
        this.behavior.get(transition).add(behavior);
        this.update();
    }

    private void update() {
        Long l = this.version;
        Long l2 = this.version = Long.valueOf(this.version + 1L);
    }

    public boolean isNewerThen(DataField other) {
        return this.version > other.getVersion();
    }

    @QueryType(value=PropertyType.STRING)
    String getStringValue() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    @Override
    public int getMultiplicity() {
        double parsedValue = Double.parseDouble(String.valueOf(this.value));
        if (parsedValue == Math.floor(parsedValue) && !Double.isInfinite(parsedValue)) {
            return (int)Double.parseDouble(String.valueOf(this.value));
        }
        throw new IllegalArgumentException("Variable arc must be an non negative integer");
    }

    @Generated
    public Map<String, Set<FieldBehavior>> getBehavior() {
        return this.behavior;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public Set<I18nString> getChoices() {
        return this.choices;
    }

    @Generated
    public List<String> getAllowedNets() {
        return this.allowedNets;
    }

    @Generated
    public Map<String, I18nString> getOptions() {
        return this.options;
    }

    @Generated
    public List<Validation> getValidations() {
        return this.validations;
    }

    @Generated
    public Map<String, Object> getFilterMetadata() {
        return this.filterMetadata;
    }

    @Generated
    public String getEncryption() {
        return this.encryption;
    }

    @JsonIgnore
    @Generated
    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    @Generated
    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    @Generated
    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public Map<String, Component> getDataRefComponents() {
        return this.dataRefComponents;
    }

    @Generated
    public Component getComponent() {
        return this.component;
    }

    @Generated
    public void setComponent(Component component) {
        this.component = component;
    }
}

