/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.petrinet.domain.layout.TaskLayout;
import com.netgrif.application.engine.petrinet.domain.policies.AssignPolicy;
import com.netgrif.application.engine.petrinet.domain.policies.DataFocusPolicy;
import com.netgrif.application.engine.petrinet.domain.policies.FinishPolicy;
import com.netgrif.application.engine.petrinet.domain.roles.RolePermission;
import com.netgrif.application.engine.workflow.domain.triggers.Trigger;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Task
implements Serializable {
    private static final long serialVersionUID = -7112277728921547546L;
    @Id
    private ObjectId _id;
    @Indexed
    private String processId;
    @Indexed
    private String caseId;
    @Indexed
    private String transitionId;
    private TaskLayout layout;
    private I18nString title;
    private String caseColor;
    private String caseTitle;
    private Integer priority;
    @Indexed
    private String userId;
    @Transient
    private IUser user;
    @DBRef
    private List<Trigger> triggers;
    private Map<String, Map<String, Boolean>> roles;
    private Map<String, Map<String, Boolean>> userRefs;
    private Map<String, Map<String, Boolean>> users;
    private List<String> viewRoles;
    private List<String> viewUserRefs;
    private List<String> viewUsers;
    private List<String> negativeViewRoles;
    private List<String> negativeViewUsers;
    private LocalDateTime startDate;
    private LocalDateTime finishDate;
    private String finishedBy;
    private String transactionId;
    private Boolean requiredFilled;
    @JsonIgnore
    private LinkedHashSet<String> immediateDataFields;
    @Transient
    private List<Field> immediateData;
    private String icon;
    private AssignPolicy assignPolicy;
    private DataFocusPolicy dataFocusPolicy;
    private FinishPolicy finishPolicy;
    private Map<EventType, I18nString> eventTitles;
    private Map<String, Boolean> assignedUserPolicy;
    private Map<String, Integer> consumedTokens = new HashMap<String, Integer>();
    private Map<String, String> tags;

    public Task() {
    }

    @JsonIgnore
    public ObjectId getObjectId() {
        return this._id;
    }

    public String getStringId() {
        return this._id.toString();
    }

    public String getTransitionId() {
        return this.transitionId;
    }

    public String getIcon() {
        return this.icon;
    }

    public List<String> getViewRoles() {
        if (this.viewRoles == null) {
            this.viewRoles = new LinkedList<String>();
        }
        return this.viewRoles;
    }

    public List<String> getViewUserRefs() {
        if (this.viewUserRefs == null) {
            this.viewUserRefs = new LinkedList<String>();
        }
        return this.viewUserRefs;
    }

    public List<String> getViewUsers() {
        if (this.viewUsers == null) {
            this.viewUsers = new LinkedList<String>();
        }
        return this.viewUsers;
    }

    public List<String> getNegativeViewRoles() {
        if (this.negativeViewRoles == null) {
            this.negativeViewRoles = new LinkedList<String>();
        }
        return this.negativeViewRoles;
    }

    public List<String> getNegativeViewUsers() {
        if (this.negativeViewUsers == null) {
            this.negativeViewUsers = new LinkedList<String>();
        }
        return this.negativeViewUsers;
    }

    public void addRole(String roleId, Map<String, Boolean> permissions) {
        if (this.roles.containsKey(roleId) && this.roles.get(roleId) != null) {
            this.roles.get(roleId).putAll(permissions);
        } else {
            this.roles.put(roleId, permissions);
        }
    }

    public void addNegativeViewRole(String roleId) {
        this.negativeViewRoles.add(roleId);
    }

    public void addUserRef(String userRefId, Map<String, Boolean> permissions) {
        this.userRefs.put(userRefId, permissions);
    }

    public void addUsers(Set<String> userIds, Map<String, Boolean> permissions) {
        userIds.forEach(userId -> {
            if (this.users.containsKey(userId) && this.users.get(userId) != null) {
                this.compareExistingUserPermissions((String)userId, (Map<String, Boolean>)new HashMap<String, Boolean>(permissions));
            } else {
                this.users.put((String)userId, new HashMap(permissions));
            }
        });
    }

    public void addAssignedUserPolicy(Map<String, Boolean> assignedUser) {
        this.assignedUserPolicy.putAll(assignedUser);
    }

    @JsonIgnore
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void addTrigger(Trigger trigger) {
        this.triggers.add(trigger);
    }

    public void addEventTitle(EventType type, I18nString title) {
        if (type == null || title == null) {
            return;
        }
        this.eventTitles.put(type, title);
    }

    @JsonIgnore
    public String getUserId() {
        return this.userId;
    }

    public String getTranslatedEventTitle(EventType assign, Locale locale) {
        if (this.eventTitles == null || !this.eventTitles.containsKey((Object)assign)) {
            return null;
        }
        return this.eventTitles.get((Object)assign).getTranslation(locale);
    }

    public void resolveViewRoles() {
        this.getViewRoles();
        this.viewRoles.clear();
        this.roles.forEach((role, perms) -> {
            if (perms.containsKey(RolePermission.VIEW.getValue()) && ((Boolean)perms.get(RolePermission.VIEW.getValue())).booleanValue()) {
                this.viewRoles.add((String)role);
            }
        });
    }

    public void resolveViewUserRefs() {
        this.getViewUserRefs();
        this.viewUserRefs.clear();
        this.userRefs.forEach((userRef, perms) -> {
            if (perms.containsKey(RolePermission.VIEW.getValue()) && ((Boolean)perms.get(RolePermission.VIEW.getValue())).booleanValue()) {
                this.viewUserRefs.add((String)userRef);
            }
        });
    }

    public void resolveViewUsers() {
        this.getViewUsers();
        this.viewUsers.clear();
        this.users.forEach((role, perms) -> {
            if (perms.containsKey(RolePermission.VIEW.getValue()) && ((Boolean)perms.get(RolePermission.VIEW.getValue())).booleanValue()) {
                this.viewUsers.add((String)role);
            }
        });
    }

    private void compareExistingUserPermissions(String userId, Map<String, Boolean> permissions) {
        permissions.forEach((id, perm) -> {
            if (this.users.containsKey(userId) && !this.users.get(userId).containsKey(id) || this.users.containsKey(userId) && this.users.get(userId).containsKey(id) && this.users.get(userId).get(id).booleanValue()) {
                this.users.get(userId).put((String)id, (Boolean)perm);
            }
        });
    }

    @Generated
    private static ObjectId $default$_id() {
        return new ObjectId();
    }

    @Generated
    private static List<Trigger> $default$triggers() {
        return new LinkedList<Trigger>();
    }

    @Generated
    private static Map<String, Map<String, Boolean>> $default$roles() {
        return new HashMap<String, Map<String, Boolean>>();
    }

    @Generated
    private static Map<String, Map<String, Boolean>> $default$userRefs() {
        return new HashMap<String, Map<String, Boolean>>();
    }

    @Generated
    private static Map<String, Map<String, Boolean>> $default$users() {
        return new HashMap<String, Map<String, Boolean>>();
    }

    @Generated
    private static List<String> $default$viewRoles() {
        return new LinkedList<String>();
    }

    @Generated
    private static List<String> $default$viewUserRefs() {
        return new LinkedList<String>();
    }

    @Generated
    private static List<String> $default$viewUsers() {
        return new LinkedList<String>();
    }

    @Generated
    private static List<String> $default$negativeViewRoles() {
        return new LinkedList<String>();
    }

    @Generated
    private static List<String> $default$negativeViewUsers() {
        return new LinkedList<String>();
    }

    @Generated
    private static LinkedHashSet<String> $default$immediateDataFields() {
        return new LinkedHashSet<String>();
    }

    @Generated
    private static List<Field> $default$immediateData() {
        return new LinkedList<Field>();
    }

    @Generated
    private static AssignPolicy $default$assignPolicy() {
        return AssignPolicy.MANUAL;
    }

    @Generated
    private static DataFocusPolicy $default$dataFocusPolicy() {
        return DataFocusPolicy.MANUAL;
    }

    @Generated
    private static FinishPolicy $default$finishPolicy() {
        return FinishPolicy.MANUAL;
    }

    @Generated
    private static Map<EventType, I18nString> $default$eventTitles() {
        return new HashMap<EventType, I18nString>();
    }

    @Generated
    private static Map<String, Boolean> $default$assignedUserPolicy() {
        return new HashMap<String, Boolean>();
    }

    @Generated
    private static Map<String, String> $default$tags() {
        return new HashMap<String, String>();
    }

    @Generated
    public static TaskBuilder with() {
        return new TaskBuilder();
    }

    @Generated
    public Task(ObjectId _id, String processId, String caseId, String transitionId, TaskLayout layout, I18nString title, String caseColor, String caseTitle, Integer priority, String userId, IUser user, List<Trigger> triggers, Map<String, Map<String, Boolean>> roles, Map<String, Map<String, Boolean>> userRefs, Map<String, Map<String, Boolean>> users, List<String> viewRoles, List<String> viewUserRefs, List<String> viewUsers, List<String> negativeViewRoles, List<String> negativeViewUsers, LocalDateTime startDate, LocalDateTime finishDate, String finishedBy, String transactionId, Boolean requiredFilled, LinkedHashSet<String> immediateDataFields, List<Field> immediateData, String icon, AssignPolicy assignPolicy, DataFocusPolicy dataFocusPolicy, FinishPolicy finishPolicy, Map<EventType, I18nString> eventTitles, Map<String, Boolean> assignedUserPolicy, Map<String, Integer> consumedTokens, Map<String, String> tags) {
        this._id = _id;
        this.processId = processId;
        this.caseId = caseId;
        this.transitionId = transitionId;
        this.layout = layout;
        this.title = title;
        this.caseColor = caseColor;
        this.caseTitle = caseTitle;
        this.priority = priority;
        this.userId = userId;
        this.user = user;
        this.triggers = triggers;
        this.roles = roles;
        this.userRefs = userRefs;
        this.users = users;
        this.viewRoles = viewRoles;
        this.viewUserRefs = viewUserRefs;
        this.viewUsers = viewUsers;
        this.negativeViewRoles = negativeViewRoles;
        this.negativeViewUsers = negativeViewUsers;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.finishedBy = finishedBy;
        this.transactionId = transactionId;
        this.requiredFilled = requiredFilled;
        this.immediateDataFields = immediateDataFields;
        this.immediateData = immediateData;
        this.icon = icon;
        this.assignPolicy = assignPolicy;
        this.dataFocusPolicy = dataFocusPolicy;
        this.finishPolicy = finishPolicy;
        this.eventTitles = eventTitles;
        this.assignedUserPolicy = assignedUserPolicy;
        this.consumedTokens = consumedTokens;
        this.tags = tags;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public String getCaseId() {
        return this.caseId;
    }

    @Generated
    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    @Generated
    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    @Generated
    public TaskLayout getLayout() {
        return this.layout;
    }

    @Generated
    public void setLayout(TaskLayout layout) {
        this.layout = layout;
    }

    @Generated
    public I18nString getTitle() {
        return this.title;
    }

    @Generated
    public void setTitle(I18nString title) {
        this.title = title;
    }

    @Generated
    public String getCaseColor() {
        return this.caseColor;
    }

    @Generated
    public void setCaseColor(String caseColor) {
        this.caseColor = caseColor;
    }

    @Generated
    public String getCaseTitle() {
        return this.caseTitle;
    }

    @Generated
    public void setCaseTitle(String caseTitle) {
        this.caseTitle = caseTitle;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public IUser getUser() {
        return this.user;
    }

    @Generated
    public void setUser(IUser user) {
        this.user = user;
    }

    @Generated
    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getRoles() {
        return this.roles;
    }

    @Generated
    public void setRoles(Map<String, Map<String, Boolean>> roles) {
        this.roles = roles;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUserRefs() {
        return this.userRefs;
    }

    @Generated
    public void setUserRefs(Map<String, Map<String, Boolean>> userRefs) {
        this.userRefs = userRefs;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUsers() {
        return this.users;
    }

    @Generated
    public void setUsers(Map<String, Map<String, Boolean>> users) {
        this.users = users;
    }

    @Generated
    public void setViewRoles(List<String> viewRoles) {
        this.viewRoles = viewRoles;
    }

    @Generated
    public void setViewUserRefs(List<String> viewUserRefs) {
        this.viewUserRefs = viewUserRefs;
    }

    @Generated
    public void setViewUsers(List<String> viewUsers) {
        this.viewUsers = viewUsers;
    }

    @Generated
    public void setNegativeViewRoles(List<String> negativeViewRoles) {
        this.negativeViewRoles = negativeViewRoles;
    }

    @Generated
    public void setNegativeViewUsers(List<String> negativeViewUsers) {
        this.negativeViewUsers = negativeViewUsers;
    }

    @Generated
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @Generated
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    @Generated
    public LocalDateTime getFinishDate() {
        return this.finishDate;
    }

    @Generated
    public void setFinishDate(LocalDateTime finishDate) {
        this.finishDate = finishDate;
    }

    @Generated
    public String getFinishedBy() {
        return this.finishedBy;
    }

    @Generated
    public void setFinishedBy(String finishedBy) {
        this.finishedBy = finishedBy;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public Boolean getRequiredFilled() {
        return this.requiredFilled;
    }

    @Generated
    public void setRequiredFilled(Boolean requiredFilled) {
        this.requiredFilled = requiredFilled;
    }

    @Generated
    public LinkedHashSet<String> getImmediateDataFields() {
        return this.immediateDataFields;
    }

    @JsonIgnore
    @Generated
    public void setImmediateDataFields(LinkedHashSet<String> immediateDataFields) {
        this.immediateDataFields = immediateDataFields;
    }

    @Generated
    public List<Field> getImmediateData() {
        return this.immediateData;
    }

    @Generated
    public void setImmediateData(List<Field> immediateData) {
        this.immediateData = immediateData;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public AssignPolicy getAssignPolicy() {
        return this.assignPolicy;
    }

    @Generated
    public void setAssignPolicy(AssignPolicy assignPolicy) {
        this.assignPolicy = assignPolicy;
    }

    @Generated
    public DataFocusPolicy getDataFocusPolicy() {
        return this.dataFocusPolicy;
    }

    @Generated
    public void setDataFocusPolicy(DataFocusPolicy dataFocusPolicy) {
        this.dataFocusPolicy = dataFocusPolicy;
    }

    @Generated
    public FinishPolicy getFinishPolicy() {
        return this.finishPolicy;
    }

    @Generated
    public void setFinishPolicy(FinishPolicy finishPolicy) {
        this.finishPolicy = finishPolicy;
    }

    @Generated
    public Map<EventType, I18nString> getEventTitles() {
        return this.eventTitles;
    }

    @Generated
    public void setEventTitles(Map<EventType, I18nString> eventTitles) {
        this.eventTitles = eventTitles;
    }

    @Generated
    public Map<String, Boolean> getAssignedUserPolicy() {
        return this.assignedUserPolicy;
    }

    @Generated
    public void setAssignedUserPolicy(Map<String, Boolean> assignedUserPolicy) {
        this.assignedUserPolicy = assignedUserPolicy;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public static class TaskBuilder {
        @Generated
        private boolean _id$set;
        @Generated
        private ObjectId _id$value;
        @Generated
        private String processId;
        @Generated
        private String caseId;
        @Generated
        private String transitionId;
        @Generated
        private TaskLayout layout;
        @Generated
        private I18nString title;
        @Generated
        private String caseColor;
        @Generated
        private String caseTitle;
        @Generated
        private Integer priority;
        @Generated
        private String userId;
        @Generated
        private IUser user;
        @Generated
        private boolean triggers$set;
        @Generated
        private List<Trigger> triggers$value;
        @Generated
        private boolean roles$set;
        @Generated
        private Map<String, Map<String, Boolean>> roles$value;
        @Generated
        private boolean userRefs$set;
        @Generated
        private Map<String, Map<String, Boolean>> userRefs$value;
        @Generated
        private boolean users$set;
        @Generated
        private Map<String, Map<String, Boolean>> users$value;
        @Generated
        private boolean viewRoles$set;
        @Generated
        private List<String> viewRoles$value;
        @Generated
        private boolean viewUserRefs$set;
        @Generated
        private List<String> viewUserRefs$value;
        @Generated
        private boolean viewUsers$set;
        @Generated
        private List<String> viewUsers$value;
        @Generated
        private boolean negativeViewRoles$set;
        @Generated
        private List<String> negativeViewRoles$value;
        @Generated
        private boolean negativeViewUsers$set;
        @Generated
        private List<String> negativeViewUsers$value;
        @Generated
        private LocalDateTime startDate;
        @Generated
        private LocalDateTime finishDate;
        @Generated
        private String finishedBy;
        @Generated
        private String transactionId;
        @Generated
        private Boolean requiredFilled;
        @Generated
        private boolean immediateDataFields$set;
        @Generated
        private LinkedHashSet<String> immediateDataFields$value;
        @Generated
        private boolean immediateData$set;
        @Generated
        private List<Field> immediateData$value;
        @Generated
        private String icon;
        @Generated
        private boolean assignPolicy$set;
        @Generated
        private AssignPolicy assignPolicy$value;
        @Generated
        private boolean dataFocusPolicy$set;
        @Generated
        private DataFocusPolicy dataFocusPolicy$value;
        @Generated
        private boolean finishPolicy$set;
        @Generated
        private FinishPolicy finishPolicy$value;
        @Generated
        private boolean eventTitles$set;
        @Generated
        private Map<EventType, I18nString> eventTitles$value;
        @Generated
        private boolean assignedUserPolicy$set;
        @Generated
        private Map<String, Boolean> assignedUserPolicy$value;
        @Generated
        private Map<String, Integer> consumedTokens;
        @Generated
        private boolean tags$set;
        @Generated
        private Map<String, String> tags$value;

        @Generated
        TaskBuilder() {
        }

        @Generated
        public TaskBuilder _id(ObjectId _id) {
            this._id$value = _id;
            this._id$set = true;
            return this;
        }

        @Generated
        public TaskBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        @Generated
        public TaskBuilder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        @Generated
        public TaskBuilder transitionId(String transitionId) {
            this.transitionId = transitionId;
            return this;
        }

        @Generated
        public TaskBuilder layout(TaskLayout layout) {
            this.layout = layout;
            return this;
        }

        @Generated
        public TaskBuilder title(I18nString title) {
            this.title = title;
            return this;
        }

        @Generated
        public TaskBuilder caseColor(String caseColor) {
            this.caseColor = caseColor;
            return this;
        }

        @Generated
        public TaskBuilder caseTitle(String caseTitle) {
            this.caseTitle = caseTitle;
            return this;
        }

        @Generated
        public TaskBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public TaskBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public TaskBuilder user(IUser user) {
            this.user = user;
            return this;
        }

        @Generated
        public TaskBuilder triggers(List<Trigger> triggers) {
            this.triggers$value = triggers;
            this.triggers$set = true;
            return this;
        }

        @Generated
        public TaskBuilder roles(Map<String, Map<String, Boolean>> roles) {
            this.roles$value = roles;
            this.roles$set = true;
            return this;
        }

        @Generated
        public TaskBuilder userRefs(Map<String, Map<String, Boolean>> userRefs) {
            this.userRefs$value = userRefs;
            this.userRefs$set = true;
            return this;
        }

        @Generated
        public TaskBuilder users(Map<String, Map<String, Boolean>> users) {
            this.users$value = users;
            this.users$set = true;
            return this;
        }

        @Generated
        public TaskBuilder viewRoles(List<String> viewRoles) {
            this.viewRoles$value = viewRoles;
            this.viewRoles$set = true;
            return this;
        }

        @Generated
        public TaskBuilder viewUserRefs(List<String> viewUserRefs) {
            this.viewUserRefs$value = viewUserRefs;
            this.viewUserRefs$set = true;
            return this;
        }

        @Generated
        public TaskBuilder viewUsers(List<String> viewUsers) {
            this.viewUsers$value = viewUsers;
            this.viewUsers$set = true;
            return this;
        }

        @Generated
        public TaskBuilder negativeViewRoles(List<String> negativeViewRoles) {
            this.negativeViewRoles$value = negativeViewRoles;
            this.negativeViewRoles$set = true;
            return this;
        }

        @Generated
        public TaskBuilder negativeViewUsers(List<String> negativeViewUsers) {
            this.negativeViewUsers$value = negativeViewUsers;
            this.negativeViewUsers$set = true;
            return this;
        }

        @Generated
        public TaskBuilder startDate(LocalDateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        @Generated
        public TaskBuilder finishDate(LocalDateTime finishDate) {
            this.finishDate = finishDate;
            return this;
        }

        @Generated
        public TaskBuilder finishedBy(String finishedBy) {
            this.finishedBy = finishedBy;
            return this;
        }

        @Generated
        public TaskBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Generated
        public TaskBuilder requiredFilled(Boolean requiredFilled) {
            this.requiredFilled = requiredFilled;
            return this;
        }

        @JsonIgnore
        @Generated
        public TaskBuilder immediateDataFields(LinkedHashSet<String> immediateDataFields) {
            this.immediateDataFields$value = immediateDataFields;
            this.immediateDataFields$set = true;
            return this;
        }

        @Generated
        public TaskBuilder immediateData(List<Field> immediateData) {
            this.immediateData$value = immediateData;
            this.immediateData$set = true;
            return this;
        }

        @Generated
        public TaskBuilder icon(String icon) {
            this.icon = icon;
            return this;
        }

        @Generated
        public TaskBuilder assignPolicy(AssignPolicy assignPolicy) {
            this.assignPolicy$value = assignPolicy;
            this.assignPolicy$set = true;
            return this;
        }

        @Generated
        public TaskBuilder dataFocusPolicy(DataFocusPolicy dataFocusPolicy) {
            this.dataFocusPolicy$value = dataFocusPolicy;
            this.dataFocusPolicy$set = true;
            return this;
        }

        @Generated
        public TaskBuilder finishPolicy(FinishPolicy finishPolicy) {
            this.finishPolicy$value = finishPolicy;
            this.finishPolicy$set = true;
            return this;
        }

        @Generated
        public TaskBuilder eventTitles(Map<EventType, I18nString> eventTitles) {
            this.eventTitles$value = eventTitles;
            this.eventTitles$set = true;
            return this;
        }

        @Generated
        public TaskBuilder assignedUserPolicy(Map<String, Boolean> assignedUserPolicy) {
            this.assignedUserPolicy$value = assignedUserPolicy;
            this.assignedUserPolicy$set = true;
            return this;
        }

        @Generated
        public TaskBuilder consumedTokens(Map<String, Integer> consumedTokens) {
            this.consumedTokens = consumedTokens;
            return this;
        }

        @Generated
        public TaskBuilder tags(Map<String, String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        @Generated
        public Task build() {
            ObjectId _id$value = this._id$value;
            if (!this._id$set) {
                _id$value = Task.$default$_id();
            }
            List<Trigger> triggers$value = this.triggers$value;
            if (!this.triggers$set) {
                triggers$value = Task.$default$triggers();
            }
            Map<String, Map<String, Boolean>> roles$value = this.roles$value;
            if (!this.roles$set) {
                roles$value = Task.$default$roles();
            }
            Map<String, Map<String, Boolean>> userRefs$value = this.userRefs$value;
            if (!this.userRefs$set) {
                userRefs$value = Task.$default$userRefs();
            }
            Map<String, Map<String, Boolean>> users$value = this.users$value;
            if (!this.users$set) {
                users$value = Task.$default$users();
            }
            List<String> viewRoles$value = this.viewRoles$value;
            if (!this.viewRoles$set) {
                viewRoles$value = Task.$default$viewRoles();
            }
            List<String> viewUserRefs$value = this.viewUserRefs$value;
            if (!this.viewUserRefs$set) {
                viewUserRefs$value = Task.$default$viewUserRefs();
            }
            List<String> viewUsers$value = this.viewUsers$value;
            if (!this.viewUsers$set) {
                viewUsers$value = Task.$default$viewUsers();
            }
            List<String> negativeViewRoles$value = this.negativeViewRoles$value;
            if (!this.negativeViewRoles$set) {
                negativeViewRoles$value = Task.$default$negativeViewRoles();
            }
            List<String> negativeViewUsers$value = this.negativeViewUsers$value;
            if (!this.negativeViewUsers$set) {
                negativeViewUsers$value = Task.$default$negativeViewUsers();
            }
            LinkedHashSet<String> immediateDataFields$value = this.immediateDataFields$value;
            if (!this.immediateDataFields$set) {
                immediateDataFields$value = Task.$default$immediateDataFields();
            }
            List<Field> immediateData$value = this.immediateData$value;
            if (!this.immediateData$set) {
                immediateData$value = Task.$default$immediateData();
            }
            AssignPolicy assignPolicy$value = this.assignPolicy$value;
            if (!this.assignPolicy$set) {
                assignPolicy$value = Task.$default$assignPolicy();
            }
            DataFocusPolicy dataFocusPolicy$value = this.dataFocusPolicy$value;
            if (!this.dataFocusPolicy$set) {
                dataFocusPolicy$value = Task.$default$dataFocusPolicy();
            }
            FinishPolicy finishPolicy$value = this.finishPolicy$value;
            if (!this.finishPolicy$set) {
                finishPolicy$value = Task.$default$finishPolicy();
            }
            Map<EventType, I18nString> eventTitles$value = this.eventTitles$value;
            if (!this.eventTitles$set) {
                eventTitles$value = Task.$default$eventTitles();
            }
            Map<String, Boolean> assignedUserPolicy$value = this.assignedUserPolicy$value;
            if (!this.assignedUserPolicy$set) {
                assignedUserPolicy$value = Task.$default$assignedUserPolicy();
            }
            Map<String, String> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = Task.$default$tags();
            }
            return new Task(_id$value, this.processId, this.caseId, this.transitionId, this.layout, this.title, this.caseColor, this.caseTitle, this.priority, this.userId, this.user, triggers$value, roles$value, userRefs$value, users$value, viewRoles$value, viewUserRefs$value, viewUsers$value, negativeViewRoles$value, negativeViewUsers$value, this.startDate, this.finishDate, this.finishedBy, this.transactionId, this.requiredFilled, immediateDataFields$value, immediateData$value, this.icon, assignPolicy$value, dataFocusPolicy$value, finishPolicy$value, eventTitles$value, assignedUserPolicy$value, this.consumedTokens, tags$value);
        }

        @Generated
        public String toString() {
            return "Task.TaskBuilder(_id$value=" + this._id$value + ", processId=" + this.processId + ", caseId=" + this.caseId + ", transitionId=" + this.transitionId + ", layout=" + this.layout + ", title=" + this.title + ", caseColor=" + this.caseColor + ", caseTitle=" + this.caseTitle + ", priority=" + this.priority + ", userId=" + this.userId + ", user=" + this.user + ", triggers$value=" + this.triggers$value + ", roles$value=" + this.roles$value + ", userRefs$value=" + this.userRefs$value + ", users$value=" + this.users$value + ", viewRoles$value=" + this.viewRoles$value + ", viewUserRefs$value=" + this.viewUserRefs$value + ", viewUsers$value=" + this.viewUsers$value + ", negativeViewRoles$value=" + this.negativeViewRoles$value + ", negativeViewUsers$value=" + this.negativeViewUsers$value + ", startDate=" + this.startDate + ", finishDate=" + this.finishDate + ", finishedBy=" + this.finishedBy + ", transactionId=" + this.transactionId + ", requiredFilled=" + this.requiredFilled + ", immediateDataFields$value=" + this.immediateDataFields$value + ", immediateData$value=" + this.immediateData$value + ", icon=" + this.icon + ", assignPolicy$value=" + this.assignPolicy$value + ", dataFocusPolicy$value=" + this.dataFocusPolicy$value + ", finishPolicy$value=" + this.finishPolicy$value + ", eventTitles$value=" + this.eventTitles$value + ", assignedUserPolicy$value=" + this.assignedUserPolicy$value + ", consumedTokens=" + this.consumedTokens + ", tags$value=" + this.tags$value + ")";
        }
    }

    public static enum Type {
        USER,
        AUTO,
        TIME,
        MESSAGE;

    }
}

