/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.domain.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.netgrif.application.engine.workflow.domain.filter.Configuration;
import com.netgrif.application.engine.workflow.domain.filter.DoubleValueHolder;
import com.netgrif.application.engine.workflow.domain.filter.PredicateValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Predicate
extends DoubleValueHolder {
    protected String category;
    protected Configuration configuration;
    @JacksonXmlElementWrapper(localName="stringValues")
    @JacksonXmlProperty(localName="stringValue")
    protected List<String> stringValues;
    @JacksonXmlElementWrapper(localName="doubleValues")
    @JacksonXmlProperty(localName="doubleValue")
    protected List<Double> doubleValues;
    @JacksonXmlElementWrapper(localName="booleanValues")
    @JacksonXmlProperty(localName="booleanValue")
    protected List<Boolean> booleanValues;
    @JacksonXmlElementWrapper(localName="mapValues")
    @JacksonXmlProperty(localName="mapValue")
    protected List<PredicateValue> mapValues;
    @JacksonXmlElementWrapper(localName="longValues")
    @JacksonXmlProperty(localName="longValue")
    protected List<Long> longValues;

    public Predicate(Map<String, Object> value) {
        value.forEach((k, v) -> {
            switch (k) {
                case "category": {
                    this.category = (String)v;
                    break;
                }
                case "configuration": {
                    this.configuration = new Configuration((Map)v);
                    break;
                }
                case "values": {
                    List list = (List)v;
                    if (list.get(0) instanceof String) {
                        this.stringValues = new ArrayList<String>();
                        for (Object val : list) {
                            this.stringValues.add((String)val);
                        }
                    } else if (list.get(0) instanceof Boolean) {
                        this.booleanValues = new ArrayList<Boolean>();
                        for (Object val : list) {
                            this.booleanValues.add((Boolean)val);
                        }
                    } else if (list.get(0) instanceof Integer || list.get(0) instanceof Double || list.get(0) instanceof Float) {
                        this.doubleValues = new ArrayList<Double>();
                        for (Object val : list) {
                            this.doubleValues.add(this.convertObjectToDouble(val));
                        }
                    } else if (list.get(0) instanceof Long) {
                        this.longValues = new ArrayList<Long>();
                        for (Object val : list) {
                            this.longValues.add((Long)val);
                        }
                    } else {
                        this.mapValues = new ArrayList<PredicateValue>();
                        for (Object val : list) {
                            this.mapValues.add(new PredicateValue((Map)val));
                        }
                    }
                    break;
                }
                case "stringValues": {
                    this.stringValues = new ArrayList<String>();
                    List stringList = (List)v;
                    this.stringValues.addAll(stringList);
                    break;
                }
                case "doubleValues": {
                    this.doubleValues = new ArrayList<Double>();
                    for (Object val : (List)v) {
                        this.doubleValues.add(this.convertObjectToDouble(val));
                    }
                    break;
                }
                case "longValues": {
                    this.longValues = new ArrayList<Long>();
                    for (Object val : (List)v) {
                        if (val instanceof Long) {
                            this.longValues.add((Long)val);
                            continue;
                        }
                        if (val instanceof String) {
                            this.longValues.add(Long.parseLong((String)val));
                            continue;
                        }
                        throw new IllegalArgumentException("The provided Object (" + val.toString() + ") cannot be converted to Long");
                    }
                    break;
                }
                case "booleanValues": {
                    this.booleanValues = new ArrayList<Boolean>();
                    for (Object val : (List)v) {
                        if (val instanceof Boolean) {
                            this.booleanValues.add((Boolean)val);
                            continue;
                        }
                        if (val instanceof String) {
                            this.booleanValues.add(Boolean.parseBoolean((String)val));
                            continue;
                        }
                        throw new IllegalArgumentException("The provided Object (" + val.toString() + ") cannot be converted to Boolean");
                    }
                    break;
                }
                case "mapValues": {
                    this.mapValues = new ArrayList<PredicateValue>();
                    List mapList = (List)v;
                    for (Map val : mapList) {
                        this.mapValues.add(new PredicateValue(val));
                    }
                    break;
                }
            }
        });
    }

    @JsonIgnore
    public Map<String, Object> getMapObject() {
        HashMap<String, Object> mapObject = new HashMap<String, Object>();
        mapObject.put("category", this.category);
        mapObject.put("configuration", this.configuration.getMapObject());
        if (this.mapValues != null) {
            ArrayList<Map<String, Object>> tmpList = new ArrayList<Map<String, Object>>();
            for (PredicateValue val : this.mapValues) {
                tmpList.add(val.getMapObject());
            }
            mapObject.put("values", tmpList);
        } else if (this.stringValues != null) {
            mapObject.put("values", this.stringValues);
        } else if (this.doubleValues != null) {
            mapObject.put("values", this.doubleValues);
        } else if (this.booleanValues != null) {
            mapObject.put("values", this.booleanValues);
        } else if (this.longValues != null) {
            mapObject.put("values", this.longValues);
        }
        return mapObject;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$stringValues = this.getStringValues();
        List<String> other$stringValues = other.getStringValues();
        if (this$stringValues == null ? other$stringValues != null : !((Object)this$stringValues).equals(other$stringValues)) {
            return false;
        }
        List<Double> this$doubleValues = this.getDoubleValues();
        List<Double> other$doubleValues = other.getDoubleValues();
        if (this$doubleValues == null ? other$doubleValues != null : !((Object)this$doubleValues).equals(other$doubleValues)) {
            return false;
        }
        List<Boolean> this$booleanValues = this.getBooleanValues();
        List<Boolean> other$booleanValues = other.getBooleanValues();
        if (this$booleanValues == null ? other$booleanValues != null : !((Object)this$booleanValues).equals(other$booleanValues)) {
            return false;
        }
        List<PredicateValue> this$mapValues = this.getMapValues();
        List<PredicateValue> other$mapValues = other.getMapValues();
        if (this$mapValues == null ? other$mapValues != null : !((Object)this$mapValues).equals(other$mapValues)) {
            return false;
        }
        List<Long> this$longValues = this.getLongValues();
        List<Long> other$longValues = other.getLongValues();
        return !(this$longValues == null ? other$longValues != null : !((Object)this$longValues).equals(other$longValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Predicate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $stringValues = this.getStringValues();
        result = result * 59 + ($stringValues == null ? 43 : ((Object)$stringValues).hashCode());
        List<Double> $doubleValues = this.getDoubleValues();
        result = result * 59 + ($doubleValues == null ? 43 : ((Object)$doubleValues).hashCode());
        List<Boolean> $booleanValues = this.getBooleanValues();
        result = result * 59 + ($booleanValues == null ? 43 : ((Object)$booleanValues).hashCode());
        List<PredicateValue> $mapValues = this.getMapValues();
        result = result * 59 + ($mapValues == null ? 43 : ((Object)$mapValues).hashCode());
        List<Long> $longValues = this.getLongValues();
        result = result * 59 + ($longValues == null ? 43 : ((Object)$longValues).hashCode());
        return result;
    }

    @Generated
    public Predicate() {
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public List<String> getStringValues() {
        return this.stringValues;
    }

    @Generated
    public List<Double> getDoubleValues() {
        return this.doubleValues;
    }

    @Generated
    public List<Boolean> getBooleanValues() {
        return this.booleanValues;
    }

    @Generated
    public List<PredicateValue> getMapValues() {
        return this.mapValues;
    }

    @Generated
    public List<Long> getLongValues() {
        return this.longValues;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @JacksonXmlElementWrapper(localName="stringValues")
    @JacksonXmlProperty(localName="stringValue")
    @Generated
    public void setStringValues(List<String> stringValues) {
        this.stringValues = stringValues;
    }

    @JacksonXmlElementWrapper(localName="doubleValues")
    @JacksonXmlProperty(localName="doubleValue")
    @Generated
    public void setDoubleValues(List<Double> doubleValues) {
        this.doubleValues = doubleValues;
    }

    @JacksonXmlElementWrapper(localName="booleanValues")
    @JacksonXmlProperty(localName="booleanValue")
    @Generated
    public void setBooleanValues(List<Boolean> booleanValues) {
        this.booleanValues = booleanValues;
    }

    @JacksonXmlElementWrapper(localName="mapValues")
    @JacksonXmlProperty(localName="mapValue")
    @Generated
    public void setMapValues(List<PredicateValue> mapValues) {
        this.mapValues = mapValues;
    }

    @JacksonXmlElementWrapper(localName="longValues")
    @JacksonXmlProperty(localName="longValue")
    @Generated
    public void setLongValues(List<Long> longValues) {
        this.longValues = longValues;
    }
}

