/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.domain.menu;

import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.menu.MenuItemConstants;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;

public class MenuItemBody {
    private I18nString menuName;
    private I18nString tabName;
    private String menuIcon = "filter_none";
    private String tabIcon;
    private String uri;
    private String identifier;
    private Case filter;
    private Map<String, I18nString> allowedRoles;
    private Map<String, I18nString> bannedRoles;
    private boolean useTabIcon = true;
    private boolean useCustomView = false;
    private String customViewSelector;
    private String caseViewSearchType = "fulltext_advanced";
    private String createCaseButtonTitle;
    private String createCaseButtonIcon = "add";
    private boolean caseRequireTitleInCreation = true;
    private boolean showCreateCaseButton = true;
    private String bannedNetsInCreation;
    private boolean caseShowMoreMenu = false;
    private boolean caseAllowHeaderTableMode = true;
    private List<String> caseHeadersMode = new ArrayList<String>(List.of("sort", "edit", "search"));
    private String caseHeadersDefaultMode = "sort";
    private List<String> caseDefaultHeaders;
    private boolean caseIsHeaderModeChangeable = true;
    private boolean caseUseDefaultHeaders = true;
    private Case additionalFilter;
    private boolean mergeFilters = true;
    private String taskViewSearchType = "fulltext_advanced";
    private List<String> taskHeadersMode = new ArrayList<String>(List.of("sort", "edit"));
    private String taskHeadersDefaultMode = "sort";
    private boolean taskIsHeaderModeChangeable = true;
    private boolean taskAllowHeaderTableMode = true;
    private boolean taskUseDefaultHeaders = true;
    private List<String> taskDefaultHeaders;
    private boolean taskShowMoreMenu = true;

    public MenuItemBody(I18nString name, String icon) {
        this.menuName = name;
        this.tabName = name;
        this.menuIcon = icon;
        this.tabIcon = icon;
    }

    public MenuItemBody(I18nString menuName, I18nString tabName, String menuIcon, String tabIcon) {
        this.menuName = menuName;
        this.tabName = tabName;
        this.menuIcon = menuIcon;
        this.tabIcon = tabIcon;
    }

    public MenuItemBody(String uri, String identifier, I18nString name, String icon) {
        this.uri = uri;
        this.identifier = identifier;
        this.menuName = name;
        this.tabName = name;
        this.menuIcon = icon;
        this.tabIcon = icon;
    }

    public MenuItemBody(String uri, String identifier, I18nString menuName, I18nString tabName, String menuIcon, String tabIcon) {
        this.uri = uri;
        this.identifier = identifier;
        this.menuName = menuName;
        this.tabName = tabName;
        this.menuIcon = menuIcon;
        this.tabIcon = tabIcon;
    }

    public MenuItemBody(String uri, String identifier, String name, String icon) {
        this.uri = uri;
        this.identifier = identifier;
        this.menuName = new I18nString(name);
        this.tabName = new I18nString(name);
        this.menuIcon = icon;
        this.tabIcon = icon;
    }

    public MenuItemBody(String uri, String identifier, String menuName, String tabName, String menuIcon, String tabIcon) {
        this.uri = uri;
        this.identifier = identifier;
        this.menuName = new I18nString(menuName);
        this.tabName = new I18nString(tabName);
        this.menuIcon = menuIcon;
        this.tabIcon = tabIcon;
    }

    private static void putDataSetEntry(Map<String, Map<String, Object>> dataSet, MenuItemConstants fieldId, FieldType fieldType, @Nullable Object fieldValue) {
        LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
        fieldMap.put("type", fieldType.getName());
        fieldMap.put("value", fieldValue);
        dataSet.put(fieldId.getAttributeId(), fieldMap);
    }

    private static String sanitize(String input) {
        if (input == null) {
            return null;
        }
        return Normalizer.normalize(input.trim(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[\\W-]+", "-").toLowerCase();
    }

    public String getIdentifier() {
        return MenuItemBody.sanitize(this.identifier);
    }

    public void setMenuName(I18nString name) {
        this.menuName = name;
    }

    public void setMenuName(String name) {
        this.menuName = new I18nString(name);
    }

    public void setTabName(I18nString name) {
        this.tabName = name;
    }

    public void setTabName(String name) {
        this.tabName = new I18nString(name);
    }

    public Map<String, Map<String, Object>> toDataSet() {
        return this.toDataSet(null, null, true);
    }

    public Map<String, Map<String, Object>> toDataSet(String parentId, String nodePath) {
        return this.toDataSet(parentId, nodePath, false);
    }

    private Map<String, Map<String, Object>> toDataSet(String parentId, String nodePath, boolean ignoreParentId) {
        LinkedHashMap<String, Map<String, Object>> dataSet = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> filterIdCaseRefValue = new ArrayList<String>();
        if (this.filter != null) {
            filterIdCaseRefValue.add(this.filter.getStringId());
        }
        ArrayList<String> parentIdCaseRef = new ArrayList<String>();
        if (parentId != null) {
            parentIdCaseRef.add(parentId);
        }
        if (nodePath != null) {
            MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_NODE_PATH, FieldType.TEXT, nodePath);
        }
        if (!ignoreParentId) {
            MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_PARENT_ID, FieldType.CASE_REF, parentIdCaseRef);
        }
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_MENU_NAME, FieldType.I18N, this.menuName);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_MENU_ICON, FieldType.TEXT, this.menuIcon);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TAB_NAME, FieldType.I18N, this.tabName);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TAB_ICON, FieldType.TEXT, this.tabIcon);
        if (this.identifier != null) {
            MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_IDENTIFIER, FieldType.TEXT, this.getIdentifier());
        }
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_FILTER_CASE, FieldType.CASE_REF, filterIdCaseRefValue);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_USE_TAB_ICON, FieldType.BOOLEAN, this.useTabIcon);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_USE_CUSTOM_VIEW, FieldType.BOOLEAN, this.useCustomView);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CUSTOM_VIEW_SELECTOR, FieldType.TEXT, this.customViewSelector);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_VIEW_SEARCH_TYPE, FieldType.ENUMERATION_MAP, this.caseViewSearchType);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CREATE_CASE_BUTTON_TITLE, FieldType.TEXT, this.createCaseButtonTitle);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CREATE_CASE_BUTTON_ICON, FieldType.TEXT, this.createCaseButtonIcon);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_REQUIRE_TITLE_IN_CREATION, FieldType.BOOLEAN, this.caseRequireTitleInCreation);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_SHOW_CREATE_CASE_BUTTON, FieldType.BOOLEAN, this.showCreateCaseButton);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_BANNED_NETS_IN_CREATION, FieldType.TEXT, this.bannedNetsInCreation);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_SHOW_MORE_MENU, FieldType.BOOLEAN, this.caseShowMoreMenu);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_ALLOW_HEADER_TABLE_MODE, FieldType.BOOLEAN, this.caseAllowHeaderTableMode);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_HEADERS_MODE, FieldType.MULTICHOICE_MAP, this.caseHeadersMode == null ? new ArrayList() : this.caseHeadersMode);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_HEADERS_DEFAULT_MODE, FieldType.ENUMERATION_MAP, this.caseHeadersDefaultMode);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_DEFAULT_HEADERS, FieldType.TEXT, this.caseDefaultHeaders != null ? String.join((CharSequence)",", this.caseDefaultHeaders) : null);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_CASE_IS_HEADER_MODE_CHANGEABLE, FieldType.BOOLEAN, this.caseIsHeaderModeChangeable);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_USE_CASE_DEFAULT_HEADERS, FieldType.BOOLEAN, this.caseUseDefaultHeaders);
        ArrayList<String> additionalFilterIdCaseRefValue = new ArrayList<String>();
        if (this.additionalFilter != null) {
            additionalFilterIdCaseRefValue.add(this.additionalFilter.getStringId());
        }
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_ADDITIONAL_FILTER_CASE, FieldType.CASE_REF, additionalFilterIdCaseRefValue);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_MERGE_FILTERS, FieldType.BOOLEAN, this.mergeFilters);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_VIEW_SEARCH_TYPE, FieldType.ENUMERATION_MAP, this.taskViewSearchType);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_HEADERS_MODE, FieldType.MULTICHOICE_MAP, this.taskHeadersMode == null ? new ArrayList() : this.taskHeadersMode);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_HEADERS_DEFAULT_MODE, FieldType.ENUMERATION_MAP, this.taskHeadersDefaultMode);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_IS_HEADER_MODE_CHANGEABLE, FieldType.BOOLEAN, this.taskIsHeaderModeChangeable);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_ALLOW_HEADER_TABLE_MODE, FieldType.BOOLEAN, this.taskAllowHeaderTableMode);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_USE_TASK_DEFAULT_HEADERS, FieldType.BOOLEAN, this.taskUseDefaultHeaders);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_DEFAULT_HEADERS, FieldType.TEXT, this.taskDefaultHeaders != null ? String.join((CharSequence)",", this.taskDefaultHeaders) : null);
        MenuItemBody.putDataSetEntry(dataSet, MenuItemConstants.PREFERENCE_ITEM_FIELD_TASK_SHOW_MORE_MENU, FieldType.BOOLEAN, this.taskShowMoreMenu);
        return dataSet;
    }

    @Generated
    public I18nString getMenuName() {
        return this.menuName;
    }

    @Generated
    public I18nString getTabName() {
        return this.tabName;
    }

    @Generated
    public String getMenuIcon() {
        return this.menuIcon;
    }

    @Generated
    public String getTabIcon() {
        return this.tabIcon;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public Case getFilter() {
        return this.filter;
    }

    @Generated
    public Map<String, I18nString> getAllowedRoles() {
        return this.allowedRoles;
    }

    @Generated
    public Map<String, I18nString> getBannedRoles() {
        return this.bannedRoles;
    }

    @Generated
    public boolean isUseTabIcon() {
        return this.useTabIcon;
    }

    @Generated
    public boolean isUseCustomView() {
        return this.useCustomView;
    }

    @Generated
    public String getCustomViewSelector() {
        return this.customViewSelector;
    }

    @Generated
    public String getCaseViewSearchType() {
        return this.caseViewSearchType;
    }

    @Generated
    public String getCreateCaseButtonTitle() {
        return this.createCaseButtonTitle;
    }

    @Generated
    public String getCreateCaseButtonIcon() {
        return this.createCaseButtonIcon;
    }

    @Generated
    public boolean isCaseRequireTitleInCreation() {
        return this.caseRequireTitleInCreation;
    }

    @Generated
    public boolean isShowCreateCaseButton() {
        return this.showCreateCaseButton;
    }

    @Generated
    public String getBannedNetsInCreation() {
        return this.bannedNetsInCreation;
    }

    @Generated
    public boolean isCaseShowMoreMenu() {
        return this.caseShowMoreMenu;
    }

    @Generated
    public boolean isCaseAllowHeaderTableMode() {
        return this.caseAllowHeaderTableMode;
    }

    @Generated
    public List<String> getCaseHeadersMode() {
        return this.caseHeadersMode;
    }

    @Generated
    public String getCaseHeadersDefaultMode() {
        return this.caseHeadersDefaultMode;
    }

    @Generated
    public List<String> getCaseDefaultHeaders() {
        return this.caseDefaultHeaders;
    }

    @Generated
    public boolean isCaseIsHeaderModeChangeable() {
        return this.caseIsHeaderModeChangeable;
    }

    @Generated
    public boolean isCaseUseDefaultHeaders() {
        return this.caseUseDefaultHeaders;
    }

    @Generated
    public Case getAdditionalFilter() {
        return this.additionalFilter;
    }

    @Generated
    public boolean isMergeFilters() {
        return this.mergeFilters;
    }

    @Generated
    public String getTaskViewSearchType() {
        return this.taskViewSearchType;
    }

    @Generated
    public List<String> getTaskHeadersMode() {
        return this.taskHeadersMode;
    }

    @Generated
    public String getTaskHeadersDefaultMode() {
        return this.taskHeadersDefaultMode;
    }

    @Generated
    public boolean isTaskIsHeaderModeChangeable() {
        return this.taskIsHeaderModeChangeable;
    }

    @Generated
    public boolean isTaskAllowHeaderTableMode() {
        return this.taskAllowHeaderTableMode;
    }

    @Generated
    public boolean isTaskUseDefaultHeaders() {
        return this.taskUseDefaultHeaders;
    }

    @Generated
    public List<String> getTaskDefaultHeaders() {
        return this.taskDefaultHeaders;
    }

    @Generated
    public boolean isTaskShowMoreMenu() {
        return this.taskShowMoreMenu;
    }

    @Generated
    public void setMenuIcon(String menuIcon) {
        this.menuIcon = menuIcon;
    }

    @Generated
    public void setTabIcon(String tabIcon) {
        this.tabIcon = tabIcon;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setFilter(Case filter) {
        this.filter = filter;
    }

    @Generated
    public void setAllowedRoles(Map<String, I18nString> allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    @Generated
    public void setBannedRoles(Map<String, I18nString> bannedRoles) {
        this.bannedRoles = bannedRoles;
    }

    @Generated
    public void setUseTabIcon(boolean useTabIcon) {
        this.useTabIcon = useTabIcon;
    }

    @Generated
    public void setUseCustomView(boolean useCustomView) {
        this.useCustomView = useCustomView;
    }

    @Generated
    public void setCustomViewSelector(String customViewSelector) {
        this.customViewSelector = customViewSelector;
    }

    @Generated
    public void setCaseViewSearchType(String caseViewSearchType) {
        this.caseViewSearchType = caseViewSearchType;
    }

    @Generated
    public void setCreateCaseButtonTitle(String createCaseButtonTitle) {
        this.createCaseButtonTitle = createCaseButtonTitle;
    }

    @Generated
    public void setCreateCaseButtonIcon(String createCaseButtonIcon) {
        this.createCaseButtonIcon = createCaseButtonIcon;
    }

    @Generated
    public void setCaseRequireTitleInCreation(boolean caseRequireTitleInCreation) {
        this.caseRequireTitleInCreation = caseRequireTitleInCreation;
    }

    @Generated
    public void setShowCreateCaseButton(boolean showCreateCaseButton) {
        this.showCreateCaseButton = showCreateCaseButton;
    }

    @Generated
    public void setBannedNetsInCreation(String bannedNetsInCreation) {
        this.bannedNetsInCreation = bannedNetsInCreation;
    }

    @Generated
    public void setCaseShowMoreMenu(boolean caseShowMoreMenu) {
        this.caseShowMoreMenu = caseShowMoreMenu;
    }

    @Generated
    public void setCaseAllowHeaderTableMode(boolean caseAllowHeaderTableMode) {
        this.caseAllowHeaderTableMode = caseAllowHeaderTableMode;
    }

    @Generated
    public void setCaseHeadersMode(List<String> caseHeadersMode) {
        this.caseHeadersMode = caseHeadersMode;
    }

    @Generated
    public void setCaseHeadersDefaultMode(String caseHeadersDefaultMode) {
        this.caseHeadersDefaultMode = caseHeadersDefaultMode;
    }

    @Generated
    public void setCaseDefaultHeaders(List<String> caseDefaultHeaders) {
        this.caseDefaultHeaders = caseDefaultHeaders;
    }

    @Generated
    public void setCaseIsHeaderModeChangeable(boolean caseIsHeaderModeChangeable) {
        this.caseIsHeaderModeChangeable = caseIsHeaderModeChangeable;
    }

    @Generated
    public void setCaseUseDefaultHeaders(boolean caseUseDefaultHeaders) {
        this.caseUseDefaultHeaders = caseUseDefaultHeaders;
    }

    @Generated
    public void setAdditionalFilter(Case additionalFilter) {
        this.additionalFilter = additionalFilter;
    }

    @Generated
    public void setMergeFilters(boolean mergeFilters) {
        this.mergeFilters = mergeFilters;
    }

    @Generated
    public void setTaskViewSearchType(String taskViewSearchType) {
        this.taskViewSearchType = taskViewSearchType;
    }

    @Generated
    public void setTaskHeadersMode(List<String> taskHeadersMode) {
        this.taskHeadersMode = taskHeadersMode;
    }

    @Generated
    public void setTaskHeadersDefaultMode(String taskHeadersDefaultMode) {
        this.taskHeadersDefaultMode = taskHeadersDefaultMode;
    }

    @Generated
    public void setTaskIsHeaderModeChangeable(boolean taskIsHeaderModeChangeable) {
        this.taskIsHeaderModeChangeable = taskIsHeaderModeChangeable;
    }

    @Generated
    public void setTaskAllowHeaderTableMode(boolean taskAllowHeaderTableMode) {
        this.taskAllowHeaderTableMode = taskAllowHeaderTableMode;
    }

    @Generated
    public void setTaskUseDefaultHeaders(boolean taskUseDefaultHeaders) {
        this.taskUseDefaultHeaders = taskUseDefaultHeaders;
    }

    @Generated
    public void setTaskDefaultHeaders(List<String> taskDefaultHeaders) {
        this.taskDefaultHeaders = taskDefaultHeaders;
    }

    @Generated
    public void setTaskShowMoreMenu(boolean taskShowMoreMenu) {
        this.taskShowMoreMenu = taskShowMoreMenu;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuItemBody)) {
            return false;
        }
        MenuItemBody other = (MenuItemBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseTabIcon() != other.isUseTabIcon()) {
            return false;
        }
        if (this.isUseCustomView() != other.isUseCustomView()) {
            return false;
        }
        if (this.isCaseRequireTitleInCreation() != other.isCaseRequireTitleInCreation()) {
            return false;
        }
        if (this.isShowCreateCaseButton() != other.isShowCreateCaseButton()) {
            return false;
        }
        if (this.isCaseShowMoreMenu() != other.isCaseShowMoreMenu()) {
            return false;
        }
        if (this.isCaseAllowHeaderTableMode() != other.isCaseAllowHeaderTableMode()) {
            return false;
        }
        if (this.isCaseIsHeaderModeChangeable() != other.isCaseIsHeaderModeChangeable()) {
            return false;
        }
        if (this.isCaseUseDefaultHeaders() != other.isCaseUseDefaultHeaders()) {
            return false;
        }
        if (this.isMergeFilters() != other.isMergeFilters()) {
            return false;
        }
        if (this.isTaskIsHeaderModeChangeable() != other.isTaskIsHeaderModeChangeable()) {
            return false;
        }
        if (this.isTaskAllowHeaderTableMode() != other.isTaskAllowHeaderTableMode()) {
            return false;
        }
        if (this.isTaskUseDefaultHeaders() != other.isTaskUseDefaultHeaders()) {
            return false;
        }
        if (this.isTaskShowMoreMenu() != other.isTaskShowMoreMenu()) {
            return false;
        }
        I18nString this$menuName = this.getMenuName();
        I18nString other$menuName = other.getMenuName();
        if (this$menuName == null ? other$menuName != null : !((Object)this$menuName).equals(other$menuName)) {
            return false;
        }
        I18nString this$tabName = this.getTabName();
        I18nString other$tabName = other.getTabName();
        if (this$tabName == null ? other$tabName != null : !((Object)this$tabName).equals(other$tabName)) {
            return false;
        }
        String this$menuIcon = this.getMenuIcon();
        String other$menuIcon = other.getMenuIcon();
        if (this$menuIcon == null ? other$menuIcon != null : !this$menuIcon.equals(other$menuIcon)) {
            return false;
        }
        String this$tabIcon = this.getTabIcon();
        String other$tabIcon = other.getTabIcon();
        if (this$tabIcon == null ? other$tabIcon != null : !this$tabIcon.equals(other$tabIcon)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Case this$filter = this.getFilter();
        Case other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Map<String, I18nString> this$allowedRoles = this.getAllowedRoles();
        Map<String, I18nString> other$allowedRoles = other.getAllowedRoles();
        if (this$allowedRoles == null ? other$allowedRoles != null : !((Object)this$allowedRoles).equals(other$allowedRoles)) {
            return false;
        }
        Map<String, I18nString> this$bannedRoles = this.getBannedRoles();
        Map<String, I18nString> other$bannedRoles = other.getBannedRoles();
        if (this$bannedRoles == null ? other$bannedRoles != null : !((Object)this$bannedRoles).equals(other$bannedRoles)) {
            return false;
        }
        String this$customViewSelector = this.getCustomViewSelector();
        String other$customViewSelector = other.getCustomViewSelector();
        if (this$customViewSelector == null ? other$customViewSelector != null : !this$customViewSelector.equals(other$customViewSelector)) {
            return false;
        }
        String this$caseViewSearchType = this.getCaseViewSearchType();
        String other$caseViewSearchType = other.getCaseViewSearchType();
        if (this$caseViewSearchType == null ? other$caseViewSearchType != null : !this$caseViewSearchType.equals(other$caseViewSearchType)) {
            return false;
        }
        String this$createCaseButtonTitle = this.getCreateCaseButtonTitle();
        String other$createCaseButtonTitle = other.getCreateCaseButtonTitle();
        if (this$createCaseButtonTitle == null ? other$createCaseButtonTitle != null : !this$createCaseButtonTitle.equals(other$createCaseButtonTitle)) {
            return false;
        }
        String this$createCaseButtonIcon = this.getCreateCaseButtonIcon();
        String other$createCaseButtonIcon = other.getCreateCaseButtonIcon();
        if (this$createCaseButtonIcon == null ? other$createCaseButtonIcon != null : !this$createCaseButtonIcon.equals(other$createCaseButtonIcon)) {
            return false;
        }
        String this$bannedNetsInCreation = this.getBannedNetsInCreation();
        String other$bannedNetsInCreation = other.getBannedNetsInCreation();
        if (this$bannedNetsInCreation == null ? other$bannedNetsInCreation != null : !this$bannedNetsInCreation.equals(other$bannedNetsInCreation)) {
            return false;
        }
        List<String> this$caseHeadersMode = this.getCaseHeadersMode();
        List<String> other$caseHeadersMode = other.getCaseHeadersMode();
        if (this$caseHeadersMode == null ? other$caseHeadersMode != null : !((Object)this$caseHeadersMode).equals(other$caseHeadersMode)) {
            return false;
        }
        String this$caseHeadersDefaultMode = this.getCaseHeadersDefaultMode();
        String other$caseHeadersDefaultMode = other.getCaseHeadersDefaultMode();
        if (this$caseHeadersDefaultMode == null ? other$caseHeadersDefaultMode != null : !this$caseHeadersDefaultMode.equals(other$caseHeadersDefaultMode)) {
            return false;
        }
        List<String> this$caseDefaultHeaders = this.getCaseDefaultHeaders();
        List<String> other$caseDefaultHeaders = other.getCaseDefaultHeaders();
        if (this$caseDefaultHeaders == null ? other$caseDefaultHeaders != null : !((Object)this$caseDefaultHeaders).equals(other$caseDefaultHeaders)) {
            return false;
        }
        Case this$additionalFilter = this.getAdditionalFilter();
        Case other$additionalFilter = other.getAdditionalFilter();
        if (this$additionalFilter == null ? other$additionalFilter != null : !this$additionalFilter.equals(other$additionalFilter)) {
            return false;
        }
        String this$taskViewSearchType = this.getTaskViewSearchType();
        String other$taskViewSearchType = other.getTaskViewSearchType();
        if (this$taskViewSearchType == null ? other$taskViewSearchType != null : !this$taskViewSearchType.equals(other$taskViewSearchType)) {
            return false;
        }
        List<String> this$taskHeadersMode = this.getTaskHeadersMode();
        List<String> other$taskHeadersMode = other.getTaskHeadersMode();
        if (this$taskHeadersMode == null ? other$taskHeadersMode != null : !((Object)this$taskHeadersMode).equals(other$taskHeadersMode)) {
            return false;
        }
        String this$taskHeadersDefaultMode = this.getTaskHeadersDefaultMode();
        String other$taskHeadersDefaultMode = other.getTaskHeadersDefaultMode();
        if (this$taskHeadersDefaultMode == null ? other$taskHeadersDefaultMode != null : !this$taskHeadersDefaultMode.equals(other$taskHeadersDefaultMode)) {
            return false;
        }
        List<String> this$taskDefaultHeaders = this.getTaskDefaultHeaders();
        List<String> other$taskDefaultHeaders = other.getTaskDefaultHeaders();
        return !(this$taskDefaultHeaders == null ? other$taskDefaultHeaders != null : !((Object)this$taskDefaultHeaders).equals(other$taskDefaultHeaders));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MenuItemBody;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTabIcon() ? 79 : 97);
        result = result * 59 + (this.isUseCustomView() ? 79 : 97);
        result = result * 59 + (this.isCaseRequireTitleInCreation() ? 79 : 97);
        result = result * 59 + (this.isShowCreateCaseButton() ? 79 : 97);
        result = result * 59 + (this.isCaseShowMoreMenu() ? 79 : 97);
        result = result * 59 + (this.isCaseAllowHeaderTableMode() ? 79 : 97);
        result = result * 59 + (this.isCaseIsHeaderModeChangeable() ? 79 : 97);
        result = result * 59 + (this.isCaseUseDefaultHeaders() ? 79 : 97);
        result = result * 59 + (this.isMergeFilters() ? 79 : 97);
        result = result * 59 + (this.isTaskIsHeaderModeChangeable() ? 79 : 97);
        result = result * 59 + (this.isTaskAllowHeaderTableMode() ? 79 : 97);
        result = result * 59 + (this.isTaskUseDefaultHeaders() ? 79 : 97);
        result = result * 59 + (this.isTaskShowMoreMenu() ? 79 : 97);
        I18nString $menuName = this.getMenuName();
        result = result * 59 + ($menuName == null ? 43 : $menuName.hashCode());
        I18nString $tabName = this.getTabName();
        result = result * 59 + ($tabName == null ? 43 : $tabName.hashCode());
        String $menuIcon = this.getMenuIcon();
        result = result * 59 + ($menuIcon == null ? 43 : $menuIcon.hashCode());
        String $tabIcon = this.getTabIcon();
        result = result * 59 + ($tabIcon == null ? 43 : $tabIcon.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Case $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Map<String, I18nString> $allowedRoles = this.getAllowedRoles();
        result = result * 59 + ($allowedRoles == null ? 43 : ((Object)$allowedRoles).hashCode());
        Map<String, I18nString> $bannedRoles = this.getBannedRoles();
        result = result * 59 + ($bannedRoles == null ? 43 : ((Object)$bannedRoles).hashCode());
        String $customViewSelector = this.getCustomViewSelector();
        result = result * 59 + ($customViewSelector == null ? 43 : $customViewSelector.hashCode());
        String $caseViewSearchType = this.getCaseViewSearchType();
        result = result * 59 + ($caseViewSearchType == null ? 43 : $caseViewSearchType.hashCode());
        String $createCaseButtonTitle = this.getCreateCaseButtonTitle();
        result = result * 59 + ($createCaseButtonTitle == null ? 43 : $createCaseButtonTitle.hashCode());
        String $createCaseButtonIcon = this.getCreateCaseButtonIcon();
        result = result * 59 + ($createCaseButtonIcon == null ? 43 : $createCaseButtonIcon.hashCode());
        String $bannedNetsInCreation = this.getBannedNetsInCreation();
        result = result * 59 + ($bannedNetsInCreation == null ? 43 : $bannedNetsInCreation.hashCode());
        List<String> $caseHeadersMode = this.getCaseHeadersMode();
        result = result * 59 + ($caseHeadersMode == null ? 43 : ((Object)$caseHeadersMode).hashCode());
        String $caseHeadersDefaultMode = this.getCaseHeadersDefaultMode();
        result = result * 59 + ($caseHeadersDefaultMode == null ? 43 : $caseHeadersDefaultMode.hashCode());
        List<String> $caseDefaultHeaders = this.getCaseDefaultHeaders();
        result = result * 59 + ($caseDefaultHeaders == null ? 43 : ((Object)$caseDefaultHeaders).hashCode());
        Case $additionalFilter = this.getAdditionalFilter();
        result = result * 59 + ($additionalFilter == null ? 43 : $additionalFilter.hashCode());
        String $taskViewSearchType = this.getTaskViewSearchType();
        result = result * 59 + ($taskViewSearchType == null ? 43 : $taskViewSearchType.hashCode());
        List<String> $taskHeadersMode = this.getTaskHeadersMode();
        result = result * 59 + ($taskHeadersMode == null ? 43 : ((Object)$taskHeadersMode).hashCode());
        String $taskHeadersDefaultMode = this.getTaskHeadersDefaultMode();
        result = result * 59 + ($taskHeadersDefaultMode == null ? 43 : $taskHeadersDefaultMode.hashCode());
        List<String> $taskDefaultHeaders = this.getTaskDefaultHeaders();
        result = result * 59 + ($taskDefaultHeaders == null ? 43 : ((Object)$taskDefaultHeaders).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MenuItemBody(menuName=" + this.getMenuName() + ", tabName=" + this.getTabName() + ", menuIcon=" + this.getMenuIcon() + ", tabIcon=" + this.getTabIcon() + ", uri=" + this.getUri() + ", identifier=" + this.getIdentifier() + ", filter=" + this.getFilter() + ", allowedRoles=" + this.getAllowedRoles() + ", bannedRoles=" + this.getBannedRoles() + ", useTabIcon=" + this.isUseTabIcon() + ", useCustomView=" + this.isUseCustomView() + ", customViewSelector=" + this.getCustomViewSelector() + ", caseViewSearchType=" + this.getCaseViewSearchType() + ", createCaseButtonTitle=" + this.getCreateCaseButtonTitle() + ", createCaseButtonIcon=" + this.getCreateCaseButtonIcon() + ", caseRequireTitleInCreation=" + this.isCaseRequireTitleInCreation() + ", showCreateCaseButton=" + this.isShowCreateCaseButton() + ", bannedNetsInCreation=" + this.getBannedNetsInCreation() + ", caseShowMoreMenu=" + this.isCaseShowMoreMenu() + ", caseAllowHeaderTableMode=" + this.isCaseAllowHeaderTableMode() + ", caseHeadersMode=" + this.getCaseHeadersMode() + ", caseHeadersDefaultMode=" + this.getCaseHeadersDefaultMode() + ", caseDefaultHeaders=" + this.getCaseDefaultHeaders() + ", caseIsHeaderModeChangeable=" + this.isCaseIsHeaderModeChangeable() + ", caseUseDefaultHeaders=" + this.isCaseUseDefaultHeaders() + ", additionalFilter=" + this.getAdditionalFilter() + ", mergeFilters=" + this.isMergeFilters() + ", taskViewSearchType=" + this.getTaskViewSearchType() + ", taskHeadersMode=" + this.getTaskHeadersMode() + ", taskHeadersDefaultMode=" + this.getTaskHeadersDefaultMode() + ", taskIsHeaderModeChangeable=" + this.isTaskIsHeaderModeChangeable() + ", taskAllowHeaderTableMode=" + this.isTaskAllowHeaderTableMode() + ", taskUseDefaultHeaders=" + this.isTaskUseDefaultHeaders() + ", taskDefaultHeaders=" + this.getTaskDefaultHeaders() + ", taskShowMoreMenu=" + this.isTaskShowMoreMenu() + ")";
    }

    @Generated
    public MenuItemBody() {
    }
}

