/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.domain.repositories;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.Reference;
import com.netgrif.application.engine.workflow.domain.DataField;
import com.netgrif.application.engine.workflow.domain.QCase;
import com.netgrif.application.engine.workflow.domain.QDataField;
import com.netgrif.application.engine.workflow.domain.repositories.CaseRepository;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Repository;

@Repository(value="caseRepository")
public abstract class CaseRepositoryImpl
implements CaseRepository {
    @Autowired
    private IPetriNetService petriNetService;

    @Override
    public void customize(QuerydslBindings bindings, QCase qCase) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        List<PetriNetReference> nets = this.petriNetService.getReferencesByUsersProcessRoles(((LoggedUser)((Object)auth.getPrincipal())).getSelfOrImpersonated(), null);
        Set netIds = nets.stream().map(Reference::getStringId).collect(Collectors.toSet());
        Set netIdentifiers = nets.stream().map(PetriNetReference::getIdentifier).collect(Collectors.toSet());
        bindings.bind((Path)qCase.petriNetId).first((stringPath, s) -> {
            if (!netIds.contains(s)) {
                return Expressions.asBoolean((boolean)false);
            }
            return stringPath.equalsIgnoreCase(s);
        });
        bindings.bind((Path)qCase.processIdentifier).first((path, string) -> {
            if (!netIdentifiers.contains(string)) {
                return Expressions.asBoolean((boolean)false);
            }
            return path.equalsIgnoreCase(string);
        });
        bindings.bind(String.class).first(StringExpression::equalsIgnoreCase);
        bindings.bind(qCase.dataSet).first((path, map) -> (Predicate)map.entrySet().stream().map(o -> {
            QDataField field = (QDataField)qCase.dataSet.get((Object)((String)o.getKey()));
            if (field == null || o.getValue() == null || ((DataField)o.getValue()).getValue() == null) {
                return Expressions.asBoolean((boolean)false);
            }
            return field.value.eq((Object)((DataField)o.getValue()).getValue().toString());
        }).reduce(BooleanExpression::and).get());
        bindings.bind((Path)qCase.title).first(StringExpression::likeIgnoreCase);
    }
}

