/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.importer.service.FieldFactory;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.QCase;
import com.netgrif.application.engine.workflow.domain.QDataField;
import com.netgrif.application.engine.workflow.domain.QTaskPair;
import com.netgrif.application.engine.workflow.service.MongoSearchService;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CaseSearchService
extends MongoSearchService<Case> {
    private static final Logger log = LoggerFactory.getLogger((String)CaseSearchService.class.getName());
    public static final String ROLE = "role";
    public static final String DATA = "data";
    public static final String TAGS = "tags";
    public static final String PETRINET_IDENTIFIER = "identifier";
    public static final String PETRINET_ID = "id";
    public static final String PETRINET = "petriNet";
    public static final String AUTHOR = "author";
    public static final String AUTHOR_ID = "id";
    public static final String AUTHOR_EMAIL = "email";
    public static final String AUTHOR_NAME = "name";
    public static final String TRANSITION = "transition";
    public static final String FULLTEXT = "fullText";
    public static final String CASE_ID = "stringId";
    public static final String GROUP = "group";
    @Autowired
    private IPetriNetService petriNetService;

    public Predicate buildQuery(Map<String, Object> requestQuery, LoggedUser user, Locale locale) {
        BooleanBuilder builder = new BooleanBuilder();
        LoggedUser loggedOrImpersonated = user.getSelfOrImpersonated();
        if (requestQuery.containsKey(PETRINET)) {
            builder.and(this.petriNet(requestQuery.get(PETRINET), loggedOrImpersonated, locale));
        }
        if (requestQuery.containsKey(AUTHOR)) {
            builder.and(this.author(requestQuery.get(AUTHOR)));
        }
        if (requestQuery.containsKey(TRANSITION)) {
            builder.and(this.transition(requestQuery.get(TRANSITION)));
        }
        if (requestQuery.containsKey(FULLTEXT)) {
            builder.and(this.fullText(requestQuery.getOrDefault(PETRINET, null), (String)requestQuery.get(FULLTEXT)));
        }
        if (requestQuery.containsKey(ROLE)) {
            builder.and(this.role(requestQuery.get(ROLE)));
        }
        if (requestQuery.containsKey(DATA)) {
            builder.and(this.data(requestQuery.get(DATA)));
        }
        if (requestQuery.containsKey(TAGS)) {
            builder.and(this.tags(requestQuery.get(TAGS)));
        }
        if (requestQuery.containsKey(CASE_ID)) {
            builder.and(this.caseId(requestQuery.get(CASE_ID)));
        }
        if (requestQuery.containsKey(GROUP)) {
            Predicate groupPredicate = this.group(requestQuery.get(GROUP), loggedOrImpersonated, locale);
            if (groupPredicate != null) {
                builder.and(groupPredicate);
            } else {
                return null;
            }
        }
        BooleanBuilder permissionConstraints = new BooleanBuilder(this.buildViewRoleQueryConstraint(loggedOrImpersonated));
        permissionConstraints.andNot(this.buildNegativeViewRoleQueryConstraint(loggedOrImpersonated));
        permissionConstraints.or(this.buildViewUserQueryConstraint(loggedOrImpersonated));
        permissionConstraints.andNot(this.buildNegativeViewUsersQueryConstraint(loggedOrImpersonated));
        builder.and((Predicate)permissionConstraints);
        return builder;
    }

    protected Predicate buildViewRoleQueryConstraint(LoggedUser user) {
        List<Predicate> roleConstraints = user.getProcessRoles().stream().map(this::viewRoleQuery).collect(Collectors.toList());
        return this.constructPredicateTree(roleConstraints, BooleanBuilder::or);
    }

    public Predicate viewRoleQuery(String role) {
        return QCase.case$.viewUserRefs.isEmpty().and((Predicate)QCase.case$.viewRoles.isEmpty()).or((Predicate)QCase.case$.viewRoles.contains((Object)role));
    }

    protected Predicate buildViewUserQueryConstraint(LoggedUser user) {
        Predicate roleConstraints = this.viewUserQuery(user.getId());
        return this.constructPredicateTree(Collections.singletonList(roleConstraints), BooleanBuilder::or);
    }

    public Predicate viewUserQuery(String userId) {
        return QCase.case$.viewUserRefs.isEmpty().and((Predicate)QCase.case$.viewRoles.isEmpty()).or((Predicate)QCase.case$.viewUsers.contains((Object)userId));
    }

    protected Predicate buildNegativeViewRoleQueryConstraint(LoggedUser user) {
        List<Predicate> roleConstraints = user.getProcessRoles().stream().map(this::negativeViewRoleQuery).collect(Collectors.toList());
        return this.constructPredicateTree(roleConstraints, BooleanBuilder::or);
    }

    public Predicate negativeViewRoleQuery(String role) {
        return QCase.case$.negativeViewRoles.contains((Object)role);
    }

    protected Predicate buildNegativeViewUsersQueryConstraint(LoggedUser user) {
        Predicate roleConstraints = this.negativeViewUserQuery(user.getId());
        return this.constructPredicateTree(Collections.singletonList(roleConstraints), BooleanBuilder::or);
    }

    public Predicate negativeViewUserQuery(String userId) {
        return QCase.case$.negativeViewUsers.contains((Object)userId);
    }

    public Predicate petriNet(Object query, LoggedUser user, Locale locale) {
        List<PetriNetReference> allowedNets = this.petriNetService.getReferencesByUsersProcessRoles(user, locale);
        if (query instanceof ArrayList) {
            BooleanBuilder builder = new BooleanBuilder();
            List<BooleanExpression> expressions = ((ArrayList)query).stream().filter(q -> q instanceof HashMap).map(q -> CaseSearchService.petriNetObject((HashMap)q, allowedNets)).collect(Collectors.toList());
            expressions.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
            return builder;
        }
        if (query instanceof HashMap) {
            return CaseSearchService.petriNetObject((HashMap)query, allowedNets);
        }
        return null;
    }

    private static BooleanExpression petriNetObject(HashMap<String, String> query, List<PetriNetReference> allowedNets) {
        if (query.containsKey(PETRINET_IDENTIFIER) && allowedNets.stream().anyMatch(net -> net.getIdentifier().equalsIgnoreCase((String)query.get(PETRINET_IDENTIFIER)))) {
            return QCase.case$.processIdentifier.equalsIgnoreCase(query.get(PETRINET_IDENTIFIER));
        }
        return null;
    }

    public Predicate author(Object query) {
        if (query instanceof ArrayList) {
            BooleanBuilder builder = new BooleanBuilder();
            List<BooleanExpression> expressions = ((ArrayList)query).stream().filter(q -> q instanceof HashMap).map(q -> CaseSearchService.authorObject((HashMap)q)).collect(Collectors.toList());
            expressions.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
            return builder;
        }
        if (query instanceof HashMap) {
            return CaseSearchService.authorObject((HashMap)query);
        }
        return null;
    }

    public Predicate role(Object o) {
        if (o instanceof ArrayList) {
            return ((StringPath)QCase.case$.enabledRoles.any()).in((Collection)((ArrayList)o));
        }
        return null;
    }

    private static BooleanExpression authorObject(HashMap<String, Object> query) {
        if (query.containsKey(AUTHOR_EMAIL)) {
            return QCase.case$.author.email.equalsIgnoreCase((String)query.get(AUTHOR_EMAIL));
        }
        if (query.containsKey(AUTHOR_NAME)) {
            return QCase.case$.author.fullName.equalsIgnoreCase((String)query.get(AUTHOR_NAME));
        }
        if (query.containsKey("id")) {
            String searchValue = "";
            if (query.get("id") instanceof String) {
                searchValue = (String)query.get("id");
            }
            return QCase.case$.author.id.eq((Object)searchValue);
        }
        return null;
    }

    public Predicate transition(Object query) {
        if (query instanceof ArrayList) {
            BooleanBuilder builder = new BooleanBuilder();
            List<BooleanExpression> expressions = ((ArrayList)query).stream().filter(q -> q instanceof String).map(q -> CaseSearchService.transitionString((String)q)).collect(Collectors.toList());
            expressions.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
            return builder;
        }
        if (query instanceof String) {
            return CaseSearchService.transitionString((String)query);
        }
        return null;
    }

    private static BooleanExpression transitionString(String transition) {
        return ((QTaskPair)QCase.case$.tasks.any()).transition.eq((Object)transition);
    }

    public Predicate data(Object data) {
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Unsupported class " + data.getClass().getName());
        }
        Map dataQueries = (Map)data;
        ArrayList predicates = new ArrayList();
        dataQueries.forEach((k, v) -> {
            if (v instanceof Map) {
                Map.Entry entry = ((Map)v).entrySet().iterator().next();
                Object fieldValue = entry.getValue();
                try {
                    FieldType type = FieldType.fromString((String)entry.getKey());
                    switch (type) {
                        case USER: {
                            SimplePath valuePath = Expressions.simplePath(UserFieldValue.class, (Path)((Path)QCase.case$.dataSet.get((Object)((String)k))), (String)"value");
                            StringPath idPath = Expressions.stringPath((Path)valuePath, (String)"id");
                            Expression constant = Expressions.constant((Object)Long.valueOf("" + fieldValue));
                            predicates.add(Expressions.predicate((Operator)Ops.EQ, (Expression[])new Expression[]{idPath, constant}));
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    log.error("Unrecognized Field type " + (String)entry.getKey());
                }
            } else {
                predicates.add(((QDataField)QCase.case$.dataSet.get((Object)((String)k))).value.eq(v));
            }
        });
        BooleanBuilder builder = new BooleanBuilder();
        predicates.forEach(arg_0 -> ((BooleanBuilder)builder).and(arg_0));
        return builder;
    }

    public Predicate tags(Object tags) {
        if (!(tags instanceof Map)) {
            throw new IllegalArgumentException("Unsupported class " + tags.getClass().getName());
        }
        Map tagsQueries = (Map)tags;
        ArrayList predicates = new ArrayList();
        tagsQueries.forEach((k, v) -> {
            if (!(k instanceof String) || !(v instanceof String)) {
                throw new IllegalArgumentException("Unsupported class in key or value tags element (" + k.getClass().getName() + "," + v.getClass().getName() + ")");
            }
            predicates.add(((StringPath)QCase.case$.tags.get((Object)((String)k))).eq((Object)((String)v)));
        });
        BooleanBuilder builder = new BooleanBuilder();
        predicates.forEach(arg_0 -> ((BooleanBuilder)builder).and(arg_0));
        return builder;
    }

    public Predicate fullText(Object petriNetQuery, String searchPhrase) {
        ArrayList<String> processes = new ArrayList<String>();
        if (petriNetQuery instanceof ArrayList) {
            ((ArrayList)petriNetQuery).forEach(net -> {
                if (net instanceof HashMap) {
                    processes.add(this.parseProcessIdentifier((HashMap)net));
                }
            });
        } else if (petriNetQuery instanceof HashMap) {
            processes.add(this.parseProcessIdentifier((HashMap)petriNetQuery));
        }
        List<PetriNet> petriNets = processes.isEmpty() ? this.petriNetService.getAll() : processes.stream().map(process -> this.petriNetService.getNewestVersionByIdentifier((String)process)).collect(Collectors.toList());
        if (petriNets.isEmpty()) {
            return null;
        }
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(QCase.case$.visualId.startsWithIgnoreCase(searchPhrase));
        predicates.add(QCase.case$.title.containsIgnoreCase(searchPhrase));
        predicates.add(QCase.case$.author.fullName.containsIgnoreCase(searchPhrase));
        predicates.add(QCase.case$.author.email.containsIgnoreCase(searchPhrase));
        try {
            LocalDateTime creation = FieldFactory.parseDateTime(searchPhrase);
            if (creation != null) {
                predicates.add(QCase.case$.creationDate.eq((Object)creation));
            }
        }
        catch (Exception creation) {
            // empty catch block
        }
        petriNets.forEach(net -> net.getImmediateFields().forEach(field -> {
            try {
                if (field.getType() == FieldType.TEXT) {
                    SimplePath<Object> path = ((QDataField)QCase.case$.dataSet.get((Object)field.getStringId())).value;
                    Expression constant = Expressions.constant((Object)searchPhrase);
                    predicates.add((BooleanExpression)Expressions.predicate((Operator)Ops.STRING_CONTAINS_IC, (Expression[])new Expression[]{path, constant}));
                } else if (field.getType() == FieldType.NUMBER) {
                    Double value = FieldFactory.parseDouble(searchPhrase);
                    if (value != null) {
                        predicates.add(((QDataField)QCase.case$.dataSet.get((Object)field.getStringId())).value.eq((Object)value));
                    }
                } else if (field.getType() == FieldType.DATE) {
                    LocalDate value = FieldFactory.parseDate(searchPhrase);
                    if (value != null) {
                        predicates.add(((QDataField)QCase.case$.dataSet.get((Object)field.getStringId())).value.eq((Object)value));
                    }
                } else if (field.getType() == FieldType.DATETIME) {
                    LocalDateTime value = FieldFactory.parseDateTime(searchPhrase);
                    if (value != null) {
                        predicates.add(((QDataField)QCase.case$.dataSet.get((Object)field.getStringId())).value.eq((Object)value));
                    }
                } else if (field.getType() == FieldType.ENUMERATION) {
                    SimplePath valuePath = Expressions.simplePath(I18nString.class, (Path)((Path)QCase.case$.dataSet.get((Object)field.getStringId())), (String)"value");
                    StringPath defaultValuePath = Expressions.stringPath((Path)valuePath, (String)"defaultValue");
                    Expression constant = Expressions.constant((Object)searchPhrase);
                    predicates.add((BooleanExpression)Expressions.predicate((Operator)Ops.STRING_CONTAINS_IC, (Expression[])new Expression[]{defaultValuePath, constant}));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }));
        BooleanBuilder builder = new BooleanBuilder();
        predicates.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
        return builder;
    }

    private String parseProcessIdentifier(HashMap<String, String> petriNet) {
        if (petriNet.containsKey(PETRINET_IDENTIFIER)) {
            return petriNet.get(PETRINET_IDENTIFIER);
        }
        return "";
    }

    public Predicate caseId(Object query) {
        if (query instanceof ArrayList) {
            BooleanBuilder builder = new BooleanBuilder();
            List<BooleanExpression> expressions = ((ArrayList)query).stream().filter(q -> q instanceof String).map(q -> CaseSearchService.caseIdString((String)q)).collect(Collectors.toList());
            expressions.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
            return builder;
        }
        if (query instanceof String) {
            return CaseSearchService.caseIdString((String)query);
        }
        return null;
    }

    private static BooleanExpression caseIdString(String caseId) {
        return caseId.equals("") ? QCase.case$._id.isNull() : QCase.case$._id.eq(new ObjectId(caseId));
    }

    public Predicate group(Object query, LoggedUser user, Locale locale) {
        PetriNetSearch processQuery = new PetriNetSearch();
        if (query instanceof List) {
            processQuery.setGroup((List)query);
        } else if (query instanceof String) {
            processQuery.setGroup(new ArrayList<String>(Arrays.asList((String)query)));
        }
        List groupProcesses = this.petriNetService.search(processQuery, user, (Pageable)new FullPageRequest(), locale).getContent();
        if (groupProcesses.size() == 0) {
            return null;
        }
        List<BooleanExpression> processQueries = groupProcesses.stream().map(PetriNetReference::getIdentifier).map(arg_0 -> ((StringPath)QCase.case$.processIdentifier).eq(arg_0)).collect(Collectors.toList());
        BooleanBuilder builder = new BooleanBuilder();
        processQueries.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
        return builder;
    }
}

