/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.auth.domain.Author;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceMapField;
import com.netgrif.application.engine.petrinet.domain.version.StringToVersionConverter;
import com.netgrif.application.engine.petrinet.domain.version.Version;
import com.netgrif.application.engine.petrinet.service.PetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.workflow.service.interfaces.IConfigurableMenuService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ConfigurableMenuService
implements IConfigurableMenuService {
    protected final String GLOBAL_ROLE = "GLOBAL_ROLE";
    @Autowired
    private PetriNetService petriNetService;
    @Autowired
    private StringToVersionConverter converter;
    @Autowired
    private IProcessRoleService processRoleService;

    @Override
    public Map<String, I18nString> getNetsByAuthorAsMapOptions(IUser author, Locale locale) {
        LoggedUser loggedAuthor = author.transformToLoggedUser();
        PetriNetSearch requestQuery = new PetriNetSearch();
        Author authorQuery = new Author();
        authorQuery.setEmail(author.getEmail());
        requestQuery.setAuthor(authorQuery);
        List nets = this.petriNetService.search(requestQuery, loggedAuthor, (Pageable)new FullPageRequest(), locale).getContent();
        LinkedHashMap<String, I18nString> options = new LinkedHashMap<String, I18nString>();
        options.put("GLOBAL_ROLE", new I18nString("\ud83c\udf0d Global role"));
        for (PetriNetReference net : nets) {
            String[] versionSplit = net.getVersion().split("\\.");
            I18nString titleAndVersion = new I18nString(net.getTitle() + " :" + net.getVersion());
            options.put(net.getIdentifier() + ":" + versionSplit[0] + "-" + versionSplit[1] + "-" + versionSplit[2], titleAndVersion);
        }
        return options;
    }

    @Override
    public Map<String, I18nString> getAvailableRolesFromNet(EnumerationMapField processField, MultichoiceMapField permittedRoles, MultichoiceMapField bannedRoles) {
        if ("GLOBAL_ROLE".equals(processField.getValue())) {
            return this.processRoleService.findAllGlobalRoles().stream().filter(role -> !permittedRoles.getOptions().containsKey(role.getImportId() + ":GLOBAL_ROLE") && !bannedRoles.getOptions().containsKey(role.getImportId() + ":GLOBAL_ROLE")).collect(Collectors.toMap(role -> role.getImportId() + ":GLOBAL_ROLE", role -> new I18nString(role.getName())));
        }
        String netImportId = ((String)processField.getValue()).split(":")[0];
        String versionString = ((String)processField.getValue()).split(":")[1].replace("-", ".");
        Version version = this.converter.convert(versionString);
        PetriNet net = this.petriNetService.getPetriNet(netImportId, version);
        return net.getRoles().values().stream().filter(role -> !permittedRoles.getOptions().containsKey(role.getImportId() + ":" + netImportId) && !bannedRoles.getOptions().containsKey(role.getImportId() + ":" + netImportId) && !role.isGlobal()).collect(Collectors.toMap(o -> o.getImportId() + ":" + netImportId, v -> new I18nString(v.getName())));
    }

    @Override
    public Map<String, I18nString> removeSelectedRoles(MultichoiceMapField mapField) {
        LinkedHashMap<String, I18nString> updatedRoles = new LinkedHashMap<String, I18nString>(mapField.getOptions());
        updatedRoles.keySet().removeAll((Collection)mapField.getValue());
        return updatedRoles;
    }

    @Override
    public Map<String, I18nString> addSelectedRoles(MultichoiceMapField addedRoles, EnumerationMapField processField, MultichoiceMapField rolesAvailable) {
        String netName = " (" + processField.getOptions().get(processField.getValue()).toString().split(":")[0] + ")";
        LinkedHashMap<String, I18nString> updatedRoles = new LinkedHashMap<String, I18nString>(addedRoles.getOptions());
        updatedRoles.putAll(((LinkedHashSet)rolesAvailable.getValue()).stream().collect(Collectors.toMap(x -> x, v -> new I18nString(rolesAvailable.getOptions().get(v).toString() + netName))));
        return updatedRoles;
    }
}

