/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.files.StorageResolverService;
import com.netgrif.application.engine.files.interfaces.IStorageService;
import com.netgrif.application.engine.files.throwable.StorageException;
import com.netgrif.application.engine.history.domain.dataevents.GetDataEventLog;
import com.netgrif.application.engine.history.domain.dataevents.SetDataEventLog;
import com.netgrif.application.engine.history.service.IHistoryService;
import com.netgrif.application.engine.importer.service.FieldFactory;
import com.netgrif.application.engine.petrinet.domain.Component;
import com.netgrif.application.engine.petrinet.domain.DataFieldLogic;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.I18nStringDeserializer;
import com.netgrif.application.engine.petrinet.domain.Imported;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import com.netgrif.application.engine.petrinet.domain.dataset.FileField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldDataType;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.NumberField;
import com.netgrif.application.engine.petrinet.domain.dataset.TaskField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.ChangedField;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.FieldActionsRunner;
import com.netgrif.application.engine.petrinet.domain.events.DataEvent;
import com.netgrif.application.engine.petrinet.domain.events.DataEventType;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.validation.service.interfaces.IValidationService;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.DataField;
import com.netgrif.application.engine.workflow.domain.EventNotExecutableException;
import com.netgrif.application.engine.workflow.domain.QTask;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.EventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.GetDataEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.GetDataGroupsEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.SetDataEventOutcome;
import com.netgrif.application.engine.workflow.service.FileFieldInputStream;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.IEventService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.netgrif.application.engine.workflow.web.responsebodies.DataFieldsResource;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedField;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataService
implements IDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataService.class);
    public static final int MONGO_ID_LENGTH = 24;
    @Autowired
    protected ApplicationEventPublisher publisher;
    @Autowired
    protected ITaskService taskService;
    @Autowired
    protected IWorkflowService workflowService;
    @Autowired
    protected IUserService userService;
    @Autowired
    protected FieldFactory fieldFactory;
    @Autowired
    protected FieldActionsRunner actionsRunner;
    @Autowired
    protected IEventService eventService;
    @Autowired
    protected IHistoryService historyService;
    @Autowired
    protected IPetriNetService petriNetService;
    @Autowired
    protected IValidationService validation;
    @Autowired
    private StorageResolverService storageResolverService;
    @Value(value="${nae.image.preview.scaling.px:400}")
    protected int imageScale;
    @Value(value="${nae.validation.setData.enable:false}")
    protected boolean validationEnable;

    @Override
    public GetDataEventOutcome getData(String taskId) {
        return this.getData(taskId, new HashMap<String, String>());
    }

    @Override
    public GetDataEventOutcome getData(String taskId, Map<String, String> params) {
        Task task = this.taskService.findOne(taskId);
        Case useCase = this.workflowService.findOne(task.getCaseId());
        return this.getData(task, useCase, params);
    }

    @Override
    public GetDataEventOutcome getData(Task task, Case useCase) {
        return this.getData(task, useCase, new HashMap<String, String>());
    }

    @Override
    public GetDataEventOutcome getData(Task task, Case useCase, Map<String, String> params) {
        log.info("[" + useCase.getStringId() + "]: Getting data of task " + task.getTransitionId() + " [" + task.getStringId() + "]");
        IUser user = this.userService.getLoggedOrSystem();
        Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
        Set<String> fieldsIds = transition.getDataSet().keySet();
        ArrayList<Field> dataSetFields = new ArrayList<Field>();
        if (task.getUserId() != null) {
            task.setUser(this.userService.findById(task.getUserId(), false));
        }
        GetDataEventOutcome outcome = new GetDataEventOutcome(useCase, task);
        fieldsIds.forEach(fieldId -> {
            Field validationField;
            if (this.isForbidden((String)fieldId, transition, useCase.getDataField((String)fieldId))) {
                return;
            }
            Field field = useCase.getPetriNet().getField((String)fieldId).get();
            outcome.addOutcomes(this.resolveDataEvents(field, DataEventType.GET, EventPhase.PRE, useCase, task, params));
            this.historyService.save(new GetDataEventLog(task, useCase, EventPhase.PRE, user));
            if (outcome.getMessage() == null) {
                LinkedHashMap<String, DataFieldLogic> dataSet = useCase.getPetriNet().getTransition(task.getTransitionId()).getDataSet();
                if (field.getEvents().containsKey((Object)DataEventType.GET) && field.getEvents().get((Object)DataEventType.GET).getMessage() != null) {
                    outcome.setMessage(field.getEvents().get((Object)DataEventType.GET).getMessage());
                } else if (dataSet.containsKey(fieldId) && ((DataFieldLogic)dataSet.get(fieldId)).getEvents().containsKey((Object)DataEventType.GET) && ((DataFieldLogic)dataSet.get(fieldId)).getEvents().get((Object)DataEventType.GET).getMessage() != null) {
                    outcome.setMessage(useCase.getPetriNet().getTransition(task.getTransitionId()).getDataSet().get(fieldId).getEvents().get((Object)DataEventType.GET).getMessage());
                }
            }
            if (useCase.hasFieldBehavior((String)fieldId, transition.getStringId())) {
                if (useCase.getDataSet().get(fieldId).isDisplayable(transition.getStringId())) {
                    validationField = this.fieldFactory.buildFieldWithValidation(useCase, (String)fieldId, transition.getStringId());
                    validationField.setBehavior(useCase.getDataSet().get(fieldId).applyBehavior(transition.getStringId()));
                    if (transition.getDataSet().get(fieldId).layoutExist() && transition.getDataSet().get(fieldId).getLayout().layoutFilled()) {
                        validationField.setLayout(transition.getDataSet().get(fieldId).getLayout().clone());
                    }
                    dataSetFields.add(validationField);
                }
            } else if (transition.getDataSet().get(fieldId).isDisplayable()) {
                validationField = this.fieldFactory.buildFieldWithValidation(useCase, (String)fieldId, transition.getStringId());
                validationField.setBehavior(transition.getDataSet().get(fieldId).applyBehavior());
                if (transition.getDataSet().get(fieldId).layoutExist() && transition.getDataSet().get(fieldId).getLayout().layoutFilled()) {
                    validationField.setLayout(transition.getDataSet().get(fieldId).getLayout().clone());
                }
                dataSetFields.add(validationField);
            }
            outcome.addOutcomes(this.resolveDataEvents(field, DataEventType.GET, EventPhase.POST, useCase, task, params));
            this.historyService.save(new GetDataEventLog(task, useCase, EventPhase.POST, user));
        });
        this.workflowService.save(useCase);
        dataSetFields.stream().filter(field -> field instanceof NumberField).forEach(field -> {
            DataField dataField = useCase.getDataSet().get(field.getImportId());
            if (dataField.getVersion().equals(0L) && dataField.getValue().equals(0.0)) {
                field.setValue(null);
            }
        });
        LongStream.range(0L, dataSetFields.size()).forEach(index -> ((Field)dataSetFields.get((int)index)).setOrder(index));
        outcome.setData(dataSetFields);
        return outcome;
    }

    private boolean isForbidden(String fieldId, Transition transition, DataField dataField) {
        if (dataField.getBehavior().containsKey(transition.getImportId())) {
            return dataField.isForbidden(transition.getImportId());
        }
        return transition.getDataSet().get(fieldId).isForbidden();
    }

    @Override
    public SetDataEventOutcome setData(String taskId, ObjectNode values) {
        return this.setData(taskId, values, new HashMap<String, String>());
    }

    @Override
    public SetDataEventOutcome setData(String taskId, ObjectNode values, Map<String, String> params) {
        Task task = this.taskService.findOne(taskId);
        return this.setData(task, values, params);
    }

    @Override
    public SetDataEventOutcome setData(Task task, ObjectNode values) {
        return this.setData(task, values, new HashMap<String, String>());
    }

    @Override
    public SetDataEventOutcome setData(Task task, ObjectNode values, Map<String, String> params) {
        Case useCase = this.workflowService.findOne(task.getCaseId());
        IUser user = this.userService.getLoggedOrSystem();
        log.info("[" + useCase.getStringId() + "]: Setting data of task " + task.getTransitionId() + " [" + task.getStringId() + "]");
        if (task.getUserId() != null) {
            task.setUser(this.userService.findById(task.getUserId(), false));
        }
        SetDataEventOutcome outcome = new SetDataEventOutcome(useCase, task);
        values.fields().forEachRemaining(entry -> {
            String fieldId = (String)entry.getKey();
            DataField dataField = useCase.getDataSet().get(fieldId);
            if (dataField != null) {
                Map<String, String> properties;
                Set<I18nString> choices;
                Map<String, I18nString> options;
                List<String> allowedNets;
                Field field = useCase.getPetriNet().getField(fieldId).get();
                outcome.addOutcomes(this.resolveDataEvents(field, DataEventType.SET, EventPhase.PRE, useCase, task, params));
                if (outcome.getMessage() == null) {
                    LinkedHashMap<String, DataFieldLogic> dataSet = useCase.getPetriNet().getTransition(task.getTransitionId()).getDataSet();
                    if (field.getEvents().containsKey((Object)DataEventType.SET) && field.getEvents().get((Object)DataEventType.SET).getMessage() != null) {
                        outcome.setMessage(field.getEvents().get((Object)DataEventType.SET).getMessage());
                    } else if (dataSet.containsKey(fieldId) && ((DataFieldLogic)dataSet.get(fieldId)).getEvents().containsKey((Object)DataEventType.SET) && ((DataFieldLogic)dataSet.get(fieldId)).getEvents().get((Object)DataEventType.SET).getMessage() != null) {
                        outcome.setMessage(((DataFieldLogic)dataSet.get(fieldId)).getEvents().get((Object)DataEventType.SET).getMessage());
                    }
                }
                boolean modified = false;
                ChangedField changedField = new ChangedField();
                changedField.setId(fieldId);
                Object newValue = this.parseFieldsValues((JsonNode)entry.getValue(), dataField, task.getStringId());
                if (((JsonNode)entry.getValue()).has("value") || this.getFieldTypeFromNode((ObjectNode)entry.getValue()).equals("button")) {
                    dataField.setValue(newValue);
                    changedField.addAttribute("value", newValue);
                    modified = true;
                }
                if ((allowedNets = this.parseAllowedNetsValue((JsonNode)entry.getValue())) != null) {
                    dataField.setAllowedNets(allowedNets);
                    changedField.addAttribute("allowedNets", allowedNets);
                    modified = true;
                }
                String fieldType = this.getFieldTypeFromNode((ObjectNode)entry.getValue());
                Map<String, Object> filterMetadata = this.parseFilterMetadataValue((ObjectNode)entry.getValue(), fieldType);
                if (filterMetadata != null) {
                    dataField.setFilterMetadata(filterMetadata);
                    changedField.addAttribute("filterMetadata", filterMetadata);
                    modified = true;
                }
                if ((options = this.parseOptionsNode((JsonNode)entry.getValue(), fieldType)) != null) {
                    this.setDataFieldOptions(options, dataField, changedField, fieldType);
                    modified = true;
                }
                if ((choices = this.parseChoicesNode((ObjectNode)entry.getValue(), fieldType)) != null) {
                    dataField.setChoices(choices);
                    changedField.addAttribute("choices", choices.stream().map(i18nString -> i18nString.getTranslation(LocaleContextHolder.getLocale())).collect(Collectors.toSet()));
                    modified = true;
                }
                if ((properties = this.parseProperties((JsonNode)entry.getValue())) != null) {
                    outcome.addOutcome(this.changeComponentProperties(useCase, task, field.getStringId(), properties));
                    modified = true;
                }
                if (modified) {
                    dataField.setLastModified(LocalDateTime.now());
                }
                if (this.validationEnable) {
                    this.validation.valid(useCase.getPetriNet().getDataSet().get(entry.getKey()), dataField);
                }
                outcome.addChangedField(fieldId, changedField);
                this.workflowService.save(useCase);
                this.historyService.save(new SetDataEventLog(task, useCase, EventPhase.PRE, Collections.singletonMap(fieldId, changedField), user));
                outcome.addOutcomes(this.resolveDataEvents(field, DataEventType.SET, EventPhase.POST, useCase, task, params));
                this.historyService.save(new SetDataEventLog(task, useCase, EventPhase.POST, null, user));
                this.applyFieldConnectedChanges(useCase, field);
            }
        });
        this.updateDataset(useCase);
        outcome.setCase(this.workflowService.save(useCase));
        return outcome;
    }

    @Override
    public GetDataGroupsEventOutcome getDataGroups(String taskId, Locale locale) {
        return this.getDataGroups(taskId, locale, new HashSet<String>(), 0, null);
    }

    private GetDataGroupsEventOutcome getDataGroups(String taskId, Locale locale, Set<String> collectedTaskIds, int level, String parentTaskRefId) {
        Task task = this.taskService.findOne(taskId);
        Case useCase = this.workflowService.findOne(task.getCaseId());
        PetriNet net = useCase.getPetriNet();
        Transition transition = net.getTransition(task.getTransitionId());
        GetDataGroupsEventOutcome outcome = new GetDataGroupsEventOutcome(useCase, task);
        log.info("Getting groups of task " + taskId + " in case " + useCase.getTitle() + " level: " + level);
        ArrayList<DataGroup> resultDataGroups = new ArrayList<DataGroup>();
        List<Field> data = this.getData(task, useCase).getData();
        Map<String, Field> dataFieldMap = data.stream().collect(Collectors.toMap(Imported::getImportId, field -> field));
        List dataGroups = transition.getDataGroups().values().stream().map(DataGroup::clone).collect(Collectors.toList());
        for (DataGroup dataGroup : dataGroups) {
            this.resolveTaskRefOrderOnGrid(dataGroup, dataFieldMap);
            resultDataGroups.add(dataGroup);
            log.debug("Setting groups of task " + taskId + " in case " + useCase.getTitle() + " level: " + level + " " + dataGroup.getImportId());
            LinkedList<Field> resources = new LinkedList<Field>();
            for (String dataFieldId : dataGroup.getData()) {
                Field field2 = net.getDataSet().get(dataFieldId);
                if (!dataFieldMap.containsKey(dataFieldId)) continue;
                Field resource = dataFieldMap.get(dataFieldId);
                if (level != 0) {
                    dataGroup.setParentCaseId(useCase.getStringId());
                    resource.setParentCaseId(useCase.getStringId());
                    dataGroup.setParentTaskId(taskId);
                    dataGroup.setParentTransitionId(task.getTransitionId());
                    dataGroup.setParentTaskRefId(parentTaskRefId);
                    dataGroup.setNestingLevel(level);
                    resource.setParentTaskId(taskId);
                }
                resources.add(resource);
                if (field2.getType() != FieldType.TASK_REF || !this.shouldResolveTaskRefData(field2, transition.getDataSet().get(field2.getStringId()))) continue;
                resultDataGroups.addAll(this.collectTaskRefDataGroups((TaskField)dataFieldMap.get(dataFieldId), locale, collectedTaskIds, level));
            }
            dataGroup.setFields(new DataFieldsResource(resources, locale));
        }
        outcome.setData(resultDataGroups);
        return outcome;
    }

    private boolean shouldResolveTaskRefData(Field<?> field, DataFieldLogic dataRef) {
        if (dataRef.getComponent() != null) {
            return this.hasRequiredComponentProperty(dataRef.getComponent(), "resolve_data", "true");
        }
        if (field.getComponent() != null) {
            return this.hasRequiredComponentProperty(field.getComponent(), "resolve_data", "true");
        }
        return true;
    }

    private boolean hasRequiredComponentProperty(Component component, String propertyName, String propertyValue) {
        return component != null && component.getProperties() != null && component.getProperties().containsKey(propertyName) && component.getProperties().get(propertyName).equals(propertyValue);
    }

    private List<DataGroup> collectTaskRefDataGroups(TaskField taskRefField, Locale locale, Set<String> collectedTaskIds, int level) {
        List<String> taskIds = (List<String>)taskRefField.getValue();
        ArrayList<DataGroup> groups = new ArrayList<DataGroup>();
        if (taskIds != null) {
            taskIds = taskIds.stream().filter(id -> !collectedTaskIds.contains(id)).collect(Collectors.toList());
            taskIds.forEach(id -> {
                collectedTaskIds.add((String)id);
                List<DataGroup> taskRefDataGroups = this.getDataGroups((String)id, locale, collectedTaskIds, level + 1, taskRefField.getStringId()).getData();
                this.resolveTaskRefBehavior(taskRefField, taskRefDataGroups);
                groups.addAll(taskRefDataGroups);
            });
        }
        return groups;
    }

    private void resolveTaskRefOrderOnGrid(DataGroup dataGroup, Map<String, Field> dataFieldMap) {
        if (dataGroup.getLayout() != null && Objects.equals(dataGroup.getLayout().getType(), "grid")) {
            dataGroup.setData(dataGroup.getData().stream().filter(dataFieldMap::containsKey).map(dataFieldMap::get).sorted(Comparator.comparingInt(a -> a.getLayout().getY())).map(Field::getStringId).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
    }

    private void resolveTaskRefBehavior(TaskField taskRefField, List<DataGroup> taskRefDataGroups) {
        if (taskRefField.getBehavior().has("visible") && taskRefField.getBehavior().get("visible").asBoolean()) {
            taskRefDataGroups.forEach(dataGroup -> dataGroup.getFields().getContent().forEach(field -> {
                if (field.getBehavior().has("editable") && field.getBehavior().get("editable").asBoolean()) {
                    this.changeTaskRefBehavior((LocalisedField)field, FieldBehavior.VISIBLE);
                }
            }));
        } else if (taskRefField.getBehavior().has("hidden") && taskRefField.getBehavior().get("hidden").asBoolean()) {
            taskRefDataGroups.forEach(dataGroup -> dataGroup.getFields().getContent().forEach(field -> {
                if (!field.getBehavior().has("forbidden") || !field.getBehavior().get("forbidden").asBoolean()) {
                    this.changeTaskRefBehavior((LocalisedField)field, FieldBehavior.HIDDEN);
                }
            }));
        }
    }

    private void changeTaskRefBehavior(LocalisedField field, FieldBehavior behavior) {
        List<FieldBehavior> antonymBehaviors = Arrays.asList(behavior.getAntonyms());
        antonymBehaviors.forEach(beh -> field.getBehavior().remove(beh.name()));
        ObjectNode behaviorNode = JsonNodeFactory.instance.objectNode();
        behaviorNode.put(behavior.toString(), true);
        field.setBehavior(behaviorNode);
    }

    @Override
    public FileFieldInputStream getFileByTask(String taskId, String fieldId, boolean forPreview) throws FileNotFoundException {
        Task task = this.taskService.findOne(taskId);
        FileFieldInputStream fileFieldInputStream = this.getFileByCase(task.getCaseId(), task, fieldId, forPreview);
        if (fileFieldInputStream == null || fileFieldInputStream.getInputStream() == null) {
            throw new FileNotFoundException("File in field " + fieldId + " within task " + taskId + " was not found!");
        }
        return fileFieldInputStream;
    }

    @Override
    public FileFieldInputStream getFileByTaskAndName(String taskId, String fieldId, String name) throws FileNotFoundException {
        return this.getFileByTaskAndName(taskId, fieldId, name, new HashMap<String, String>());
    }

    @Override
    public FileFieldInputStream getFileByTaskAndName(String taskId, String fieldId, String name, Map<String, String> params) throws FileNotFoundException {
        Task task = this.taskService.findOne(taskId);
        return this.getFileByCaseAndName(task.getCaseId(), fieldId, name, params);
    }

    @Override
    public FileFieldInputStream getFileByCase(String caseId, Task task, String fieldId, boolean forPreview) throws FileNotFoundException {
        Case useCase = this.workflowService.findOne(caseId);
        FileField field = (FileField)useCase.getPetriNet().getDataSet().get(fieldId);
        return this.getFile(useCase, task, field, forPreview);
    }

    @Override
    public FileFieldInputStream getFileByCaseAndName(String caseId, String fieldId, String name) throws FileNotFoundException {
        return this.getFileByCaseAndName(caseId, fieldId, name, new HashMap<String, String>());
    }

    @Override
    public FileFieldInputStream getFileByCaseAndName(String caseId, String fieldId, String name, Map<String, String> params) throws FileNotFoundException {
        Case useCase = this.workflowService.findOne(caseId);
        FileListField field = (FileListField)useCase.getPetriNet().getDataSet().get(fieldId);
        return this.getFileByName(useCase, field, name, params);
    }

    @Override
    public FileFieldInputStream getFileByName(Case useCase, FileListField field, String name) throws FileNotFoundException {
        return this.getFileByName(useCase, field, name, new HashMap<String, String>());
    }

    @Override
    public FileFieldInputStream getFileByName(Case useCase, FileListField field, String name, Map<String, String> params) throws FileNotFoundException {
        this.runGetActionsFromFileField(field.getEvents(), useCase, params);
        if (useCase.getFieldValue(field.getStringId()) == null) {
            return null;
        }
        this.workflowService.save(useCase);
        field.setValue((FileListFieldValue)useCase.getFieldValue(field.getStringId()));
        Optional<FileFieldValue> fileFieldValue = ((FileListFieldValue)field.getValue()).getNamesPaths().stream().filter(namePath -> namePath.getName().equals(name)).findFirst();
        if (fileFieldValue.isEmpty() || fileFieldValue.get().getPath() == null) {
            log.error("File " + name + " not found!");
            throw new FileNotFoundException("File " + name + " not found!");
        }
        return new FileFieldInputStream(this.storageResolverService.resolve(field.getStorageType()).get(field, fileFieldValue.get().getPath()), name);
    }

    @Override
    public FileFieldInputStream getFile(Case useCase, Task task, FileField field, boolean forPreview) throws FileNotFoundException {
        return this.getFile(useCase, task, field, forPreview, new HashMap<String, String>());
    }

    @Override
    public FileFieldInputStream getFile(Case useCase, Task task, FileField field, boolean forPreview, Map<String, String> params) throws FileNotFoundException {
        this.runGetActionsFromFileField(field.getEvents(), useCase, params);
        if (useCase.getFieldValue(field.getStringId()) == null) {
            throw new FileNotFoundException("Field " + field.getStringId() + " not found on case " + useCase.getStringId());
        }
        this.workflowService.save(useCase);
        field.setValue((FileFieldValue)useCase.getFieldValue(field.getStringId()));
        try {
            if (forPreview) {
                return this.getFilePreview(field, useCase);
            }
            return new FileFieldInputStream(field, this.storageResolverService.resolve(field.getStorageType()).get(field, ((FileFieldValue)field.getValue()).getPath()));
        }
        catch (StorageException | IOException e) {
            log.error("Getting file failed: ", (Throwable)e);
            return null;
        }
    }

    private void runGetActionsFromFileField(Map<DataEventType, DataEvent> events, Case useCase, Map<String, String> params) {
        if (events != null && !events.isEmpty() && events.containsKey((Object)DataEventType.GET)) {
            DataEvent event = events.get((Object)DataEventType.GET);
            event.getPreActions().forEach(action -> this.actionsRunner.run((Action)action, useCase, params));
            event.getPostActions().forEach(action -> this.actionsRunner.run((Action)action, useCase, params));
        }
    }

    private FileFieldInputStream getFilePreview(FileField field, Case useCase) throws IOException, StorageException {
        FileFieldInputStream fileFieldInputStream;
        IStorageService storageService = this.storageResolverService.resolve(field.getStorageType());
        InputStream stream = storageService.get(field, ((FileFieldValue)field.getValue()).getPath());
        File file = File.createTempFile(field.getStringId(), "." + FileFieldDataType.resolveTypeFromName((String)((FileFieldValue)field.getValue()).getName()).extension);
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        IOUtils.copy((InputStream)stream, (OutputStream)fos);
        fos.close();
        stream.close();
        byte[] bytes = this.generateFilePreviewToStream(file).toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            String previewPath = storageService.getPreviewPath(useCase.getStringId(), field.getImportId(), ((FileFieldValue)field.getValue()).getName());
            storageService.save(field, previewPath, inputStream);
            ((FileFieldValue)field.getValue()).setPreviewPath(previewPath);
            ((InputStream)inputStream).reset();
            fileFieldInputStream = new FileFieldInputStream(field, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (StorageException e) {
                stream.close();
                throw new EventNotExecutableException("File preview cannot be saved", e);
            }
        }
        ((InputStream)inputStream).close();
        return fileFieldInputStream;
    }

    private ByteArrayOutputStream generateFilePreviewToStream(File file) throws IOException {
        FileFieldDataType fileType = FileFieldDataType.resolveTypeFromName(file.getName());
        BufferedImage image = this.getBufferedImageFromFile(file, fileType);
        if (image.getWidth() > this.imageScale || image.getHeight() > this.imageScale) {
            image = this.scaleImagePreview(image);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, !fileType.extension.equals(FileFieldDataType.PDF.extension) ? fileType.extension : FileFieldDataType.JPG.extension, os);
        return os;
    }

    private BufferedImage getBufferedImageFromFile(File file, FileFieldDataType fileType) throws IOException {
        BufferedImage image;
        if (fileType.equals((Object)FileFieldDataType.PDF)) {
            PDDocument document = PDDocument.load((File)file);
            PDFRenderer renderer = new PDFRenderer(document);
            image = renderer.renderImage(0);
            document.close();
        } else {
            image = ImageIO.read(file);
        }
        return image;
    }

    private BufferedImage scaleImagePreview(BufferedImage image) {
        float ratio = image.getHeight() > image.getWidth() ? (float)image.getHeight() / (float)this.imageScale : (float)image.getWidth() / (float)this.imageScale;
        int targetWidth = Math.round((float)image.getWidth() / ratio);
        int targetHeight = Math.round((float)image.getHeight() / ratio);
        Image targetImage = image.getScaledInstance(targetWidth, targetHeight, 1);
        image = new BufferedImage(targetWidth, targetHeight, 1);
        image.getGraphics().drawImage(targetImage, 0, 0, null);
        return image;
    }

    @Override
    public InputStream download(FileListField field, FileFieldValue fieldValue) throws StorageException, FileNotFoundException {
        return this.storageResolverService.resolve(field.getStorageType()).get(field, fieldValue.getPath());
    }

    @Override
    public SetDataEventOutcome saveFile(String taskId, String fieldId, MultipartFile multipartFile) {
        return this.saveFile(taskId, fieldId, multipartFile, new HashMap<String, String>());
    }

    @Override
    public SetDataEventOutcome saveFile(String taskId, String fieldId, MultipartFile multipartFile, Map<String, String> params) {
        Task task = this.taskService.findOne(taskId);
        ImmutablePair<Case, FileField> pair = this.getCaseAndFileField(taskId, fieldId);
        FileField field = (FileField)pair.getRight();
        Case useCase = (Case)pair.getLeft();
        IStorageService storageService = this.storageResolverService.resolve(field.getStorageType());
        try {
            if (useCase.getDataSet().get(field.getStringId()).getValue() != null && ((FileFieldValue)field.getValue()).getPath() != null) {
                storageService.delete(field, ((FileFieldValue)field.getValue()).getPath());
                if (((FileFieldValue)field.getValue()).getPreviewPath() != null) {
                    storageService.delete(field, ((FileFieldValue)field.getValue()).getPreviewPath());
                }
                useCase.getDataSet().get(field.getStringId()).setValue(null);
            }
            field.setValue(multipartFile.getOriginalFilename());
            String path = storageService.getPath(useCase.getStringId(), field.getStringId(), multipartFile.getOriginalFilename());
            ((FileFieldValue)field.getValue()).setPath(path);
            storageService.save(field, path, multipartFile);
        }
        catch (StorageException e) {
            log.error("File " + multipartFile.getOriginalFilename() + " in case " + useCase.getStringId() + " could not be saved to file field " + field.getStringId(), (Throwable)e);
            throw new EventNotExecutableException("File " + multipartFile.getOriginalFilename() + " in case " + useCase.getStringId() + " could not be saved to file field " + field.getStringId(), e);
        }
        useCase.getDataSet().get(field.getStringId()).setValue(field.getValue());
        return new SetDataEventOutcome(useCase, task, this.getChangedFieldByFileFieldContainer(fieldId, task, useCase, params));
    }

    @Override
    public SetDataEventOutcome saveFiles(String taskId, String fieldId, MultipartFile[] multipartFiles) {
        return this.saveFiles(taskId, fieldId, multipartFiles, new HashMap<String, String>());
    }

    @Override
    public SetDataEventOutcome saveFiles(String taskId, String fieldId, MultipartFile[] multipartFiles, Map<String, String> params) {
        Task task = this.taskService.findOne(taskId);
        ImmutablePair<Case, FileListField> pair = this.getCaseAndFileListField(taskId, fieldId);
        FileListField field = (FileListField)pair.getRight();
        Case useCase = (Case)pair.getLeft();
        IStorageService storageService = this.storageResolverService.resolve(field.getStorageType());
        for (MultipartFile multipartFile : multipartFiles) {
            try {
                Optional<FileFieldValue> fileFieldValue;
                if (field.getValue() != null && ((FileListFieldValue)field.getValue()).getNamesPaths() != null && (fileFieldValue = ((FileListFieldValue)field.getValue()).getNamesPaths().stream().filter(namePath -> namePath.getName().equals(multipartFile.getOriginalFilename())).findFirst()).isPresent()) {
                    storageService.delete(field, fileFieldValue.get().getPath());
                    ((FileListFieldValue)field.getValue()).getNamesPaths().remove(fileFieldValue.get());
                }
                String path = storageService.getPath(useCase.getStringId(), field.getStringId(), multipartFile.getOriginalFilename());
                field.addValue(multipartFile.getOriginalFilename(), path);
                storageService.save(field, path, multipartFile);
            }
            catch (StorageException e) {
                log.error(e.getMessage());
                throw new EventNotExecutableException("File " + multipartFile.getOriginalFilename() + " in case " + useCase.getStringId() + " could not be saved to file list field " + field.getStringId(), e);
            }
        }
        useCase.getDataSet().get(field.getStringId()).setValue(field.getValue());
        return new SetDataEventOutcome(useCase, task, this.getChangedFieldByFileFieldContainer(fieldId, task, useCase, params));
    }

    private List<EventOutcome> getChangedFieldByFileFieldContainer(String fieldId, Task referencingTask, Case useCase, Map<String, String> params) {
        ArrayList<EventOutcome> outcomes = new ArrayList<EventOutcome>(this.resolveDataEvents(useCase.getPetriNet().getField(fieldId).get(), DataEventType.SET, EventPhase.PRE, useCase, referencingTask, params));
        outcomes.addAll(this.resolveDataEvents(useCase.getPetriNet().getField(fieldId).get(), DataEventType.SET, EventPhase.POST, useCase, referencingTask, params));
        this.updateDataset(useCase);
        this.workflowService.save(useCase);
        return outcomes;
    }

    @Override
    public SetDataEventOutcome deleteFile(String taskId, String fieldId) {
        return this.deleteFile(taskId, fieldId, new HashMap<String, String>());
    }

    @Override
    public SetDataEventOutcome deleteFile(String taskId, String fieldId, Map<String, String> params) {
        ImmutablePair<Case, FileField> pair = this.getCaseAndFileField(taskId, fieldId);
        FileField field = (FileField)pair.getRight();
        Case useCase = (Case)pair.getLeft();
        Task task = this.taskService.findById(taskId);
        IStorageService storageService = this.storageResolverService.resolve(field.getStorageType());
        if (useCase.getDataSet().get(field.getStringId()).getValue() != null) {
            try {
                storageService.delete(field, ((FileFieldValue)field.getValue()).getPath());
                if (((FileFieldValue)field.getValue()).getPreviewPath() != null) {
                    storageService.delete(field, ((FileFieldValue)field.getValue()).getPreviewPath());
                }
            }
            catch (StorageException e) {
                log.error(e.getMessage());
                throw new EventNotExecutableException("File " + ((FileFieldValue)field.getValue()).getName() + " in case " + useCase.getStringId() + " and field " + fieldId + "  could not be deleted.", e);
            }
            useCase.getDataSet().get(field.getStringId()).setValue(null);
        }
        return new SetDataEventOutcome(useCase, task, this.getChangedFieldByFileFieldContainer(fieldId, task, useCase, params));
    }

    private ImmutablePair<Case, FileField> getCaseAndFileField(String taskId, String fieldId) {
        Task task = this.taskService.findOne(taskId);
        Case useCase = this.workflowService.findOne(task.getCaseId());
        FileField field = (FileField)useCase.getPetriNet().getDataSet().get(fieldId);
        field.setValue((FileFieldValue)useCase.getDataField(field.getStringId()).getValue());
        return new ImmutablePair((Object)useCase, (Object)field);
    }

    @Override
    public SetDataEventOutcome deleteFileByName(String taskId, String fieldId, String name) {
        return this.deleteFileByName(taskId, fieldId, name, new HashMap<String, String>());
    }

    @Override
    public SetDataEventOutcome deleteFileByName(String taskId, String fieldId, String name, Map<String, String> params) {
        ImmutablePair<Case, FileListField> pair = this.getCaseAndFileListField(taskId, fieldId);
        FileListField field = (FileListField)pair.getRight();
        Case useCase = (Case)pair.getLeft();
        Task task = this.taskService.findOne(taskId);
        IStorageService storageService = this.storageResolverService.resolve(field.getStorageType());
        Optional<FileFieldValue> fileFieldValue = ((FileListFieldValue)field.getValue()).getNamesPaths().stream().filter(namePath -> namePath.getName().equals(name)).findFirst();
        if (fileFieldValue.isPresent()) {
            try {
                storageService.delete(field, fileFieldValue.get().getPath());
                ((FileListFieldValue)field.getValue()).getNamesPaths().remove(fileFieldValue.get());
                useCase.getDataSet().get(field.getStringId()).setValue(field.getValue());
            }
            catch (StorageException e) {
                log.error(e.getMessage());
                throw new EventNotExecutableException("File " + name + " in case " + useCase.getStringId() + " and field " + fieldId + "  could not be deleted.", e);
            }
        }
        return new SetDataEventOutcome(useCase, task, this.getChangedFieldByFileFieldContainer(fieldId, task, useCase, params));
    }

    private ImmutablePair<Case, FileListField> getCaseAndFileListField(String taskId, String fieldId) {
        Task task = this.taskService.findOne(taskId);
        Case useCase = this.workflowService.findOne(task.getCaseId());
        FileListField field = (FileListField)useCase.getPetriNet().getDataSet().get(fieldId);
        field.setValue((FileListFieldValue)useCase.getDataField(field.getStringId()).getValue());
        return new ImmutablePair((Object)useCase, (Object)field);
    }

    @Override
    public Page<Task> setImmediateFields(Page<Task> tasks) {
        tasks.getContent().forEach(task -> task.setImmediateData(this.getImmediateFields((Task)task)));
        return tasks;
    }

    @Override
    public List<Field> getImmediateFields(Task task) {
        Case useCase = this.workflowService.findOne(task.getCaseId());
        List<Field> fields = task.getImmediateDataFields().stream().map(id -> this.fieldFactory.buildFieldWithoutValidation(useCase, (String)id, task.getTransitionId())).collect(Collectors.toList());
        LongStream.range(0L, fields.size()).forEach(index -> ((Field)fields.get((int)index)).setOrder(index));
        return fields;
    }

    @Override
    public UserFieldValue makeUserFieldValue(String id) {
        IUser user = this.userService.resolveById(id, true);
        return new UserFieldValue(user);
    }

    private void updateDataset(Case useCase) {
        Case actual = this.workflowService.findOne(useCase.getStringId());
        actual.getDataSet().forEach((id, dataField) -> {
            if (dataField.isNewerThen(useCase.getDataField((String)id))) {
                useCase.getDataSet().put((String)id, (DataField)dataField);
            }
        });
    }

    @Override
    public Case applyFieldConnectedChanges(Case useCase, String fieldId) {
        PetriNet petriNet = this.petriNetService.getPetriNet(useCase.getPetriNetId());
        Optional<Field> field = petriNet.getField(fieldId);
        if (field.isEmpty()) {
            throw new IllegalArgumentException("Field with given id [" + fieldId + "] does not exists on Petri net [" + petriNet.getStringId() + " " + petriNet.getIdentifier() + "]");
        }
        return this.applyFieldConnectedChanges(useCase, field.get());
    }

    @Override
    public Case applyFieldConnectedChanges(Case useCase, Field field) {
        switch (field.getType()) {
            case USERLIST: {
                return this.workflowService.resolveUserRef(useCase);
            }
        }
        return useCase;
    }

    @Override
    public SetDataEventOutcome changeComponentProperties(Case useCase, String transitionId, String fieldId, Map<String, String> properties) {
        BooleanExpression predicate = QTask.task.caseId.eq((Object)useCase.getStringId()).and((Predicate)QTask.task.transitionId.eq((Object)transitionId));
        Task task = this.taskService.searchOne((Predicate)predicate);
        return this.changeComponentProperties(useCase, task, fieldId, properties);
    }

    @Override
    public SetDataEventOutcome changeComponentProperties(Case useCase, Task task, String fieldId, Map<String, String> properties) {
        Component comp = useCase.getDataField(fieldId).getDataRefComponents().get(task.getTransitionId());
        return this.resolveComponentProperties(comp, useCase, task, fieldId, properties);
    }

    @Override
    public SetDataEventOutcome changeComponentProperties(Case useCase, String fieldId, Map<String, String> properties) {
        Component comp = useCase.getDataField(fieldId).getComponent();
        return this.resolveComponentProperties(comp, useCase, null, fieldId, properties);
    }

    private SetDataEventOutcome resolveComponentProperties(Component comp, Case useCase, Task task, String fieldId, Map<String, String> properties) {
        SetDataEventOutcome outcome = new SetDataEventOutcome(useCase, task);
        ChangedField changedField = new ChangedField();
        changedField.setId(fieldId);
        if (comp != null) {
            properties.forEach((key, value) -> comp.getProperties().put((String)key, (String)value));
            changedField.addAttribute("component", comp);
            outcome.addChangedField(fieldId, changedField);
            if (task == null) {
                useCase.getDataField(fieldId).setComponent(comp);
            } else {
                useCase.getDataField(fieldId).addDataRefComponent(task.getTransitionId(), comp);
            }
        } else if (task == null) {
            log.debug("Setting component on field " + fieldId + " in case [" + useCase.getTitle() + "] as default");
            Component newComp = new Component("default", properties);
            useCase.getDataField(fieldId).setComponent(newComp);
            changedField.addAttribute("component", newComp);
            outcome.addChangedField(fieldId, changedField);
        } else {
            log.warn("Setting properties on field " + fieldId + " on task [" + task.getStringId() + "] in case [" + useCase.getTitle() + "] failed, field dont have component!");
        }
        outcome.setCase(this.workflowService.save(useCase));
        return outcome;
    }

    private List<EventOutcome> resolveDataEvents(Field field, DataEventType trigger, EventPhase phase, Case useCase, Task task, Map<String, String> params) {
        return this.eventService.processDataEvents(field, trigger, phase, useCase, task, params);
    }

    private Object parseFieldsValues(JsonNode jsonNode, DataField dataField, String taskId) {
        Object value;
        ObjectNode node = (ObjectNode)jsonNode;
        switch (this.getFieldTypeFromNode(node)) {
            case "date": {
                if (node.get("value") == null || node.get("value").isNull()) {
                    value = null;
                    break;
                }
                value = FieldFactory.parseDate(node.get("value").asText());
                break;
            }
            case "dateTime": {
                if (node.get("value") == null || node.get("value").isNull()) {
                    value = null;
                    break;
                }
                value = FieldFactory.parseDateTime(node.get("value").asText());
                break;
            }
            case "boolean": {
                value = node.get("value") != null && !node.get("value").isNull() && node.get("value").asBoolean();
                break;
            }
            case "multichoice": {
                value = this.parseMultichoiceFieldValues(node).stream().map(I18nString::new).collect(Collectors.toCollection(LinkedHashSet::new));
                break;
            }
            case "multichoice_map": {
                value = this.parseMultichoiceFieldValues(node);
                break;
            }
            case "enumeration": {
                if (node.get("value") == null || node.get("value").asText() == null || "null".equals(node.get("value").asText())) {
                    value = null;
                    break;
                }
                value = this.parseI18nString(node.get("value"));
                break;
            }
            case "user": {
                if (node.get("value") == null || node.get("value").isNull()) {
                    value = null;
                    break;
                }
                value = this.makeUserFieldValue(node.get("value").asText());
                break;
            }
            case "number": {
                if (node.get("value") == null || node.get("value").isNull()) {
                    value = null;
                    break;
                }
                value = node.get("value").asDouble();
                break;
            }
            case "file": {
                if (node.get("value") == null || node.get("value").isNull()) {
                    value = new FileFieldValue();
                    break;
                }
                value = FileFieldValue.fromString(node.get("value").asText());
                break;
            }
            case "caseRef": {
                List<String> list = this.parseListStringValues(node);
                if (list == null) {
                    value = null;
                    break;
                }
                this.validateCaseRefValue(list, dataField.getAllowedNets());
                value = list;
                break;
            }
            case "taskRef": {
                List<String> listTask = this.parseListStringValues(node);
                value = listTask;
                break;
            }
            case "stringCollection": {
                value = this.parseListStringValues(node);
                break;
            }
            case "userList": {
                if (node.get("value") == null) {
                    value = null;
                    break;
                }
                value = this.makeUserListFieldValue(node);
                break;
            }
            case "button": {
                if (node.get("value") == null) {
                    if (dataField.getValue() == null) {
                        value = 1;
                        break;
                    }
                    value = Integer.parseInt(dataField.getValue().toString()) + 1;
                    break;
                }
                value = node.get("value").asInt();
                break;
            }
            case "i18n": {
                if (node.get("value") == null) {
                    value = new I18nString("");
                    break;
                }
                value = this.parseI18nStringValues((ObjectNode)node.get("value"));
                break;
            }
            default: {
                value = node.get("value") == null || node.get("value").isNull() ? null : node.get("value").asText();
            }
        }
        if (value instanceof String && ((String)value).equalsIgnoreCase("null")) {
            return null;
        }
        return value;
    }

    private Set<String> parseMultichoiceFieldValues(ObjectNode node) {
        ArrayNode arrayNode = (ArrayNode)node.get("value");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        arrayNode.forEach(item -> set.add(item.asText()));
        return set;
    }

    private UserListFieldValue makeUserListFieldValue(ObjectNode nodes) {
        LinkedHashSet<String> userIds = new LinkedHashSet<String>(this.parseListStringValues(nodes));
        return new UserListFieldValue(userIds.stream().map(this::makeUserFieldValue).collect(Collectors.toSet()));
    }

    private List<String> parseListStringValues(ObjectNode node) {
        return this.parseListString(node, "value");
    }

    private List<Long> parseListLongValues(ObjectNode node) {
        ArrayNode arrayNode = (ArrayNode)node.get("value");
        ArrayList<Long> list = new ArrayList<Long>();
        arrayNode.forEach(string -> list.add(string.asLong()));
        return list;
    }

    private List<String> parseAllowedNetsValue(JsonNode jsonNode) {
        ObjectNode node = (ObjectNode)jsonNode;
        String fieldType = this.getFieldTypeFromNode(node);
        if (Objects.equals(fieldType, FieldType.CASE_REF.getName()) || Objects.equals(fieldType, FieldType.FILTER.getName())) {
            return this.parseListStringAllowedNets(node);
        }
        return null;
    }

    private List<String> parseListStringAllowedNets(ObjectNode node) {
        return this.parseListString(node, "allowedNets");
    }

    private List<String> parseListString(ObjectNode node, String attributeKey) {
        ArrayNode arrayNode = (ArrayNode)node.get(attributeKey);
        if (arrayNode == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        arrayNode.forEach(string -> list.add(string.asText()));
        return list;
    }

    private List<I18nString> parseListI18nString(ObjectNode node, String attributeKey) {
        ArrayNode arrayNode = (ArrayNode)node.get(attributeKey);
        if (arrayNode == null) {
            return null;
        }
        ArrayList<I18nString> list = new ArrayList<I18nString>();
        arrayNode.forEach(item -> list.add(this.parseI18nString((JsonNode)item)));
        return list;
    }

    private I18nString parseI18nString(JsonNode node) {
        if (node.isTextual()) {
            return new I18nString(node.asText());
        }
        return this.parseI18nStringValues((ObjectNode)node);
    }

    private String getFieldTypeFromNode(ObjectNode node) {
        return node.get("type").asText();
    }

    private Map<String, Object> parseFilterMetadataValue(ObjectNode node, String fieldType) {
        if (Objects.equals(fieldType, FieldType.FILTER.getName())) {
            JsonNode filterMetadata = node.get("filterMetadata");
            if (filterMetadata == null) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.convertValue((Object)filterMetadata, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return null;
    }

    private I18nString parseI18nStringValues(ObjectNode node) {
        String defaultValue = node.get("defaultValue") != null ? node.get("defaultValue").asText() : "";
        HashMap<String, String> translations = new HashMap<String, String>();
        if (node.get("translations") != null) {
            node.get("translations").fields().forEachRemaining(entry -> translations.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
        }
        return new I18nString(defaultValue, translations);
    }

    private Map<String, I18nString> parseOptionsNode(JsonNode node, String fieldType) {
        if (Objects.equals(fieldType, FieldType.ENUMERATION_MAP.getName()) || Objects.equals(fieldType, FieldType.MULTICHOICE_MAP.getName()) || Objects.equals(fieldType, FieldType.ENUMERATION.getName()) || Objects.equals(fieldType, FieldType.MULTICHOICE.getName())) {
            return this.parseOptions(node);
        }
        return null;
    }

    private Map<String, I18nString> parseOptions(JsonNode node) {
        JsonNode optionsNode = node.get("options");
        if (optionsNode == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(I18nString.class, (JsonDeserializer)new I18nStringDeserializer());
        mapper.registerModule((Module)module);
        Map optionsMapped = (Map)mapper.convertValue((Object)optionsNode, (TypeReference)new TypeReference<Map<String, I18nString>>(){});
        if (optionsMapped.isEmpty()) {
            return null;
        }
        return optionsMapped;
    }

    private void setDataFieldOptions(Map<String, I18nString> options, DataField dataField, ChangedField changedField, String fieldType) {
        if (Objects.equals(fieldType, FieldType.ENUMERATION_MAP.getName()) || Objects.equals(fieldType, FieldType.MULTICHOICE_MAP.getName())) {
            dataField.setOptions(options);
            changedField.addAttribute("options", options.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((I18nString)e.getValue()).getTranslation(LocaleContextHolder.getLocale()))));
        } else {
            LinkedHashSet<I18nString> choices = new LinkedHashSet<I18nString>();
            options.forEach((key, value) -> choices.add((I18nString)value));
            dataField.setChoices(choices);
            changedField.addAttribute("choices", choices.stream().map(i18nString -> i18nString.getTranslation(LocaleContextHolder.getLocale())).collect(Collectors.toSet()));
        }
    }

    private Set<I18nString> parseChoicesNode(ObjectNode node, String fieldType) {
        List<I18nString> list;
        if ((Objects.equals(fieldType, FieldType.ENUMERATION.getName()) || Objects.equals(fieldType, FieldType.MULTICHOICE.getName())) && (list = this.parseListI18nString(node, "choices")) != null) {
            return new HashSet<I18nString>(list);
        }
        return null;
    }

    private Map<String, String> parseProperties(JsonNode node) {
        JsonNode propertiesNode = node.get("properties");
        if (propertiesNode == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        Map propertiesMapped = (Map)mapper.convertValue((Object)propertiesNode, (TypeReference)new TypeReference<Map<String, String>>(){});
        if (propertiesMapped.isEmpty()) {
            return null;
        }
        return propertiesMapped;
    }

    @Override
    public void validateCaseRefValue(List<String> value, List<String> allowedNets) throws IllegalArgumentException {
        List<Case> cases = this.workflowService.findAllById(value);
        HashSet<String> nets = new HashSet<String>(allowedNets);
        cases.forEach(_case -> {
            if (!nets.contains(_case.getProcessIdentifier())) {
                throw new IllegalArgumentException(String.format("Case '%s' with id '%s' cannot be added to case ref, since it is an instance of process with identifier '%s', which is not one of the allowed nets", _case.getTitle(), _case.getStringId(), _case.getProcessIdentifier()));
            }
        });
    }
}

