/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.petrinet.domain.DataFieldLogic;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.FieldActionsRunner;
import com.netgrif.application.engine.petrinet.domain.events.DataEventType;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.EventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.SetDataEventOutcome;
import com.netgrif.application.engine.workflow.service.interfaces.IEventService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class EventService
implements IEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventService.class);
    private final FieldActionsRunner actionsRunner;
    private final IWorkflowService workflowService;

    public EventService(FieldActionsRunner actionsRunner, IWorkflowService workflowService) {
        this.actionsRunner = actionsRunner;
        this.workflowService = workflowService;
    }

    @Override
    public List<EventOutcome> runActions(List<Action> actions, Case useCase, Task task, Transition transition, Map<String, String> params) {
        log.info("[" + useCase.getStringId() + "]: Running actions of transition " + transition.getStringId());
        return this.runActions(actions, useCase, Optional.of(task), params);
    }

    @Override
    public List<EventOutcome> runActions(List<Action> actions, Map<String, String> params) {
        return this.runActions(actions, null, Optional.empty(), params);
    }

    @Override
    public List<EventOutcome> runActions(List<Action> actions, Case useCase, Optional<Task> task, Map<String, String> params) {
        ArrayList<EventOutcome> allOutcomes = new ArrayList<EventOutcome>();
        if (actions.isEmpty()) {
            return allOutcomes;
        }
        actions.forEach(action -> {
            List<EventOutcome> outcomes = this.actionsRunner.run((Action)action, useCase, task, params, useCase == null ? Collections.emptyList() : useCase.getPetriNet().getFunctions());
            outcomes.stream().filter(SetDataEventOutcome.class::isInstance).forEach(outcome -> {
                if (((SetDataEventOutcome)outcome).getChangedFields().isEmpty()) {
                    return;
                }
                this.runEventActionsOnChanged(task.orElse(null), (SetDataEventOutcome)outcome, DataEventType.SET, params);
            });
            allOutcomes.addAll(outcomes);
        });
        if (useCase != null) {
            this.workflowService.save(useCase);
        }
        return allOutcomes;
    }

    @Override
    public List<EventOutcome> runEventActions(Case useCase, Task task, List<Action> actions, DataEventType trigger, Map<String, String> params) {
        ArrayList<EventOutcome> allOutcomes = new ArrayList<EventOutcome>();
        if (actions.isEmpty()) {
            return allOutcomes;
        }
        actions.forEach(action -> {
            List<EventOutcome> outcomes = this.actionsRunner.run((Action)action, useCase, (Optional<Task>)(task == null ? Optional.empty() : Optional.of(task)), params, useCase == null ? Collections.emptyList() : useCase.getPetriNet().getFunctions());
            outcomes.stream().filter(SetDataEventOutcome.class::isInstance).forEach(outcome -> {
                if (((SetDataEventOutcome)outcome).getChangedFields().isEmpty()) {
                    return;
                }
                this.runEventActionsOnChanged(task, (SetDataEventOutcome)outcome, trigger, params);
            });
            allOutcomes.addAll(outcomes);
        });
        return allOutcomes;
    }

    @Override
    public List<EventOutcome> processDataEvents(Field field, DataEventType actionTrigger, EventPhase phase, Case useCase, Task task, Map<String, String> params) {
        Transition transition;
        LinkedList<Action> fieldActions = new LinkedList<Action>();
        if (field.getEvents() != null && field.getEvents().containsKey((Object)actionTrigger)) {
            fieldActions.addAll(DataFieldLogic.getEventAction(field.getEvents().get((Object)actionTrigger), phase));
        }
        if (task != null && (transition = useCase.getPetriNet().getTransition(task.getTransitionId())).getDataSet().containsKey(field.getStringId()) && !transition.getDataSet().get(field.getStringId()).getEvents().isEmpty()) {
            fieldActions.addAll(DataFieldLogic.getEventAction(transition.getDataSet().get(field.getStringId()).getEvents().get((Object)actionTrigger), phase));
        }
        if (fieldActions.isEmpty()) {
            return Collections.emptyList();
        }
        return this.runEventActions(useCase, task, fieldActions, actionTrigger, params);
    }

    @Override
    public void runEventActionsOnChanged(Task task, SetDataEventOutcome outcome, DataEventType trigger) {
        this.runEventActionsOnChanged(task, outcome, trigger, new HashMap<String, String>());
    }

    @Override
    public void runEventActionsOnChanged(Task task, SetDataEventOutcome outcome, DataEventType trigger, Map<String, String> params) {
        outcome.getChangedFields().forEach((s, changedField) -> {
            if (changedField.getAttributes().containsKey("value") && trigger == DataEventType.SET) {
                Field field = outcome.getCase().getField((String)s);
                log.info("[" + outcome.getCase().getStringId() + "] " + outcome.getCase().getTitle() + ": Running actions on changed field " + s);
                outcome.addOutcomes(this.processDataEvents(field, trigger, EventPhase.PRE, outcome.getCase(), outcome.getTask(), params));
                outcome.addOutcomes(this.processDataEvents(field, trigger, EventPhase.POST, outcome.getCase(), outcome.getTask(), params));
            }
        });
    }
}

