/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.common.collect.Lists;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.configuration.properties.FilterProperties;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.throwable.TransitionNotExecutableException;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.startup.DefaultFiltersRunner;
import com.netgrif.application.engine.startup.ImportHelper;
import com.netgrif.application.engine.utils.InputStreamToString;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.DataField;
import com.netgrif.application.engine.workflow.domain.FileStorageConfiguration;
import com.netgrif.application.engine.workflow.domain.FilterDeserializer;
import com.netgrif.application.engine.workflow.domain.IllegalFilterFileException;
import com.netgrif.application.engine.workflow.domain.QCase;
import com.netgrif.application.engine.workflow.domain.QTask;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.filter.FilterImportExport;
import com.netgrif.application.engine.workflow.domain.filter.FilterImportExportList;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.IFilterImportExportService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.querydsl.core.types.Predicate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FilterImportExportService
implements IFilterImportExportService {
    private static final Logger log = LoggerFactory.getLogger(FilterImportExportService.class);
    private static final String EXPORT_NET_IDENTIFIER = "export_filters";
    private static final String IMPORT_NET_IDENTIFIER = "import_filters";
    private static final String FILTER_NET_IDENTIFIER = "filter";
    private static final String UPLOAD_FILE_FIELD = "upload_file";
    private static final String IMPORT_FILTER_TRANSITION = "import_filter";
    private static final String FIELD_VISIBILITY = "visibility";
    private static final String FIELD_FILTER_TYPE = "filter_type";
    private static final String FIELD_FILTER = "filter";
    private static final String FIELD_NAME = "i18n_filter_name";
    private static final String FIELD_PARENT_CASE_ID = "parent_filter_id";
    private static final String FIELD_PARENT_VIEW_ID = "origin_view_id";
    private static final String FIELD_MISSING_ALLOWED_NETS = "missing_allowed_nets";
    private static final String FIELD_MISSING_NETS_TRANSLATION = "missing_nets_translation";
    @Autowired
    IUserService userService;
    @Autowired
    IWorkflowService workflowService;
    @Autowired
    IPetriNetService petriNetService;
    @Autowired
    DefaultFiltersRunner defaultFiltersRunner;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private IDataService dataService;
    @Autowired
    private FileStorageConfiguration fileStorageConfiguration;
    @Autowired
    private FilterProperties filterProperties;

    @Override
    public void createFilterImport(IUser author) {
        this.workflowService.createCaseByIdentifier(IMPORT_NET_IDENTIFIER, "Import filters " + author.getFullName(), "", author.transformToLoggedUser());
    }

    @Override
    public void createFilterExport(IUser author) {
        this.workflowService.createCaseByIdentifier(EXPORT_NET_IDENTIFIER, "Export filters " + author.getFullName(), "", author.transformToLoggedUser());
    }

    @Override
    public FileFieldValue exportFiltersToFile(Collection<String> filtersToExport) throws IOException {
        log.info("Exporting selected filters");
        return this.createXML(this.exportFilters(filtersToExport));
    }

    @Override
    public FilterImportExportList exportFilters(Collection<String> filtersToExport) {
        List<Case> selectedFilterCases = this.workflowService.findAllById(Lists.newArrayList(filtersToExport));
        FilterImportExportList filterList = new FilterImportExportList();
        HashSet<String> exportedFilterIds = new HashSet<String>();
        for (Case exportedFilter : selectedFilterCases) {
            LinkedList<FilterImportExport> chain = new LinkedList<FilterImportExport>();
            Case currentCase = exportedFilter;
            while (!exportedFilterIds.contains(currentCase.getStringId())) {
                exportedFilterIds.add(currentCase.getStringId());
                FilterImportExport currentFilter = this.createExportClass(currentCase);
                chain.push(currentFilter);
                if (currentFilter.getParentCaseId() == null) break;
                currentCase = this.workflowService.findOne(currentFilter.getParentCaseId());
            }
            filterList.getFilters().addAll(chain);
        }
        return filterList;
    }

    @Override
    public List<String> importFilters() throws IOException, IllegalFilterFileException, TransitionNotExecutableException {
        log.info("Importing filters");
        FilterImportExportList filterList = this.loadFromXML();
        return new ArrayList<String>(this.performImport(filterList).values());
    }

    @Override
    public Map<String, String> importFilters(FilterImportExportList filterList) throws IOException, TransitionNotExecutableException {
        log.info("Importing filters from imported menu");
        return this.performImport(filterList);
    }

    protected Map<String, String> performImport(FilterImportExportList filterList) throws IOException, TransitionNotExecutableException {
        HashMap oldToNewFilterId = new HashMap();
        HashMap<String, String> importedFilterTaskIds = new HashMap<String, String>();
        if (filterList == null) {
            throw new FileNotFoundException();
        }
        filterList.getFilters().forEach(filter -> {
            Optional<Case> filterCase;
            if (filter.getAllowedNets() == null) {
                filter.setAllowedNets(new ArrayList<String>());
            }
            String parentId = null;
            boolean viewOrigin = false;
            if (filter.getParentCaseId() != null && !filter.getParentCaseId().equals("")) {
                parentId = (String)oldToNewFilterId.get(filter.getParentCaseId());
                if (parentId == null) {
                    log.error("Imported filter with ID '" + filter.getCaseId() + "' could not find an imported mapping of its parent case with original ID '" + filter.getParentCaseId() + "'");
                }
            } else if (filter.getParentViewId() != null && !filter.getParentViewId().equals("")) {
                parentId = filter.getParentViewId();
                viewOrigin = true;
            }
            if ((filterCase = this.defaultFiltersRunner.createFilter(filter.getFilterName().getDefaultValue(), filter.getIcon(), filter.getType(), filter.getVisibility(), filter.getFilterValue(), filter.getAllowedNets(), filter.getFilterMetadataExport().getMapObject(), filter.getFilterName().getTranslations(), filter.getFilterMetadataExport().isDefaultSearchCategories(), filter.getFilterMetadataExport().isInheritAllowedNets(), parentId, viewOrigin, true)).isEmpty()) {
                return;
            }
            oldToNewFilterId.put(filter.getCaseId(), filterCase.get().getStringId());
            Task importedFilterTask = this.taskService.searchOne((Predicate)QTask.task.transitionId.eq((Object)IMPORT_FILTER_TRANSITION).and((Predicate)QTask.task.caseId.eq((Object)filterCase.get().getStringId())));
            importedFilterTaskIds.put(filter.getCaseId(), importedFilterTask.getStringId());
            filterCase.get().getDataSet().get(FIELD_MISSING_ALLOWED_NETS).addBehavior(IMPORT_FILTER_TRANSITION, Collections.singleton(FieldBehavior.HIDDEN));
            filterCase.get().getDataSet().get("filter").addBehavior(IMPORT_FILTER_TRANSITION, Collections.singleton(FieldBehavior.VISIBLE));
            this.workflowService.save(filterCase.get());
        });
        this.taskService.assignTasks(this.taskService.findAllById(new ArrayList<String>(importedFilterTaskIds.values())), this.userService.getLoggedUser());
        this.changeFilterField(importedFilterTaskIds.values());
        return importedFilterTaskIds;
    }

    @Override
    public void changeFilterField(Collection<String> filterFields) {
        filterFields.forEach(f -> {
            Task importedFilterTask = this.taskService.findOne((String)f);
            Case filterCase = this.workflowService.findOne(importedFilterTask.getCaseId());
            PetriNet filterNet = this.petriNetService.getNewestVersionByIdentifier("filter");
            List<String> requiredNets = filterCase.getDataSet().get("filter").getAllowedNets();
            List<String> currentNets = this.petriNetService.getExistingPetriNetIdentifiersFromIdentifiersList(requiredNets);
            if (currentNets.size() < requiredNets.size()) {
                requiredNets.removeAll(currentNets);
                StringBuilder htmlTextAreaValue = new StringBuilder(((EnumerationMapField)filterNet.getDataSet().get(FIELD_MISSING_NETS_TRANSLATION)).getOptions().get(LocaleContextHolder.getLocale().getLanguage()).getDefaultValue());
                htmlTextAreaValue.append("<ul style=\"color: red\">");
                requiredNets.forEach(net -> htmlTextAreaValue.append("<li>").append((String)net).append("</li>"));
                htmlTextAreaValue.append("</ul>");
                HashMap<String, Map<String, String>> taskData = new HashMap<String, Map<String, String>>();
                HashMap<String, String> missingNets = new HashMap<String, String>();
                missingNets.put("type", "text");
                missingNets.put("value", htmlTextAreaValue.toString());
                taskData.put(FIELD_MISSING_ALLOWED_NETS, missingNets);
                this.dataService.setData(importedFilterTask, ImportHelper.populateDataset(taskData));
                filterCase = this.workflowService.findOne(filterCase.getStringId());
                this.changeVisibilityByAllowedNets(true, filterCase);
            } else {
                this.changeVisibilityByAllowedNets(false, filterCase);
            }
            this.workflowService.save(filterCase);
        });
    }

    private void changeVisibilityByAllowedNets(boolean allowedNetsMissing, Case filterCase) {
        filterCase.getDataSet().get(allowedNetsMissing ? FIELD_MISSING_ALLOWED_NETS : "filter").makeVisible(IMPORT_FILTER_TRANSITION);
        filterCase.getDataSet().get(allowedNetsMissing ? "filter" : FIELD_MISSING_ALLOWED_NETS).makeHidden(IMPORT_FILTER_TRANSITION);
    }

    @Transactional
    protected FilterImportExportList loadFromXML() throws IOException, IllegalFilterFileException {
        Case exportCase = this.workflowService.searchOne((Predicate)QCase.case$.processIdentifier.eq((Object)IMPORT_NET_IDENTIFIER).and((Predicate)QCase.case$.author.id.eq((Object)this.userService.getLoggedUser().getStringId())));
        FileFieldValue ffv = (FileFieldValue)exportCase.getDataSet().get(UPLOAD_FILE_FIELD).getValue();
        if (ffv == null) {
            throw new FileNotFoundException();
        }
        File f = new File(ffv.getPath());
        FilterImportExportService.validateFilterXML(new FileInputStream(f));
        String importedFilter = InputStreamToString.inputStreamToString(new FileInputStream(f));
        SimpleModule module = new SimpleModule().addDeserializer(Object.class, (JsonDeserializer)FilterDeserializer.getInstance());
        XmlMapper xmlMapper = (XmlMapper)new XmlMapper().registerModule((Module)module);
        return (FilterImportExportList)xmlMapper.readValue(importedFilter, FilterImportExportList.class);
    }

    @Transactional
    protected FileFieldValue createXML(FilterImportExportList filters) throws IOException {
        String filePath = this.fileStorageConfiguration.getStoragePath() + "/filterExport/" + this.userService.getLoggedUser().getStringId() + "/" + this.filterProperties.getFileName();
        File f = new File(filePath);
        f.getParentFile().mkdirs();
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xmlMapper.writeValue((OutputStream)baos, (Object)filters);
        FileOutputStream fos = new FileOutputStream(f);
        baos.writeTo(fos);
        return new FileFieldValue(this.filterProperties.getFileName(), filePath);
    }

    protected FilterImportExport createExportClass(Case filter) {
        DataField parentViewId;
        FilterImportExport exportFilter = new FilterImportExport();
        exportFilter.setCaseId(filter.getStringId());
        exportFilter.setIcon(filter.getIcon());
        DataField parentCaseId = filter.getDataField(FIELD_PARENT_CASE_ID);
        if (parentCaseId.getValue() != null && !parentCaseId.getValue().equals("")) {
            exportFilter.setParentCaseId((String)parentCaseId.getValue());
        }
        if ((parentViewId = filter.getDataField(FIELD_PARENT_VIEW_ID)).getValue() != null && !parentViewId.getValue().equals("")) {
            exportFilter.setParentViewId((String)parentViewId.getValue());
        }
        DataField filterField = filter.getDataField("filter");
        exportFilter.setFilterValue((String)filterField.getValue());
        exportFilter.setAllowedNets(filterField.getAllowedNets());
        exportFilter.setFilterMetadataExport(filterField.getFilterMetadata());
        DataField visibility = filter.getDataField(FIELD_VISIBILITY);
        exportFilter.setVisibility(visibility.getValue().toString());
        DataField type = filter.getDataField(FIELD_FILTER_TYPE);
        exportFilter.setType(type.getValue().toString());
        DataField name = filter.getDataField(FIELD_NAME);
        exportFilter.setFilterName((I18nString)name.getValue());
        return exportFilter;
    }

    private static void validateFilterXML(InputStream xml) throws IllegalFilterFileException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(FilterImportExportService.class.getResource("/petriNets/filter_export_schema.xsd"));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
        }
        catch (Exception ex) {
            throw new IllegalFilterFileException(ex);
        }
    }
}

