/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.ChoiceField;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.MapOptionsField;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.CaseFieldsExpressionRunner;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.service.interfaces.IInitValueExpressionEvaluator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitValueExpressionEvaluator
implements IInitValueExpressionEvaluator {
    @Autowired
    private CaseFieldsExpressionRunner runner;

    @Override
    public <T> T evaluate(Case useCase, Field<T> defaultField, Map<String, String> params) {
        return (T)this.evaluate(useCase, defaultField.getInitExpression(), params);
    }

    @Override
    public Map<String, I18nString> evaluateOptions(Case useCase, MapOptionsField<I18nString, ?> field, Map<String, String> params) {
        Object result = this.evaluate(useCase, field.getExpression(), params);
        if (!(result instanceof Map)) {
            throw new IllegalArgumentException("[" + useCase.getStringId() + "] Dynamic options not an instance of Map: " + field.getImportId());
        }
        Map map = (Map)result;
        if (map.values().stream().anyMatch(it -> !(it instanceof I18nString))) {
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> new I18nString(it.getValue().toString()), (o1, o2) -> o1, LinkedHashMap::new));
        }
        return (Map)result;
    }

    @Override
    public Set<I18nString> evaluateChoices(Case useCase, ChoiceField<?> field, Map<String, String> params) {
        Object result = this.evaluate(useCase, field.getExpression(), params);
        if (!(result instanceof Collection)) {
            throw new IllegalArgumentException("[" + useCase.getStringId() + "] Dynamic choices not an instance of Collection: " + field.getImportId());
        }
        Collection collection = (Collection)result;
        return collection.stream().map(it -> it instanceof I18nString ? (I18nString)it : new I18nString(it.toString())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public I18nString evaluateCaseName(Case useCase, Expression expression, Map<String, String> params) {
        Object result = this.evaluate(useCase, expression, params);
        if (result instanceof I18nString) {
            return (I18nString)result;
        }
        return new I18nString(result.toString());
    }

    @Override
    public Object evaluate(Case useCase, Expression expression, Map<String, String> params) {
        return this.runner.run(useCase, expression, params);
    }
}

