/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.files.StorageResolverService;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceMapField;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.domain.throwable.TransitionNotExecutableException;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.startup.DefaultFiltersRunner;
import com.netgrif.application.engine.startup.ImportHelper;
import com.netgrif.application.engine.utils.InputStreamToString;
import com.netgrif.application.engine.workflow.domain.AuthorizationType;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.FilterDeserializer;
import com.netgrif.application.engine.workflow.domain.IllegalMenuFileException;
import com.netgrif.application.engine.workflow.domain.QTask;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.menu.Menu;
import com.netgrif.application.engine.workflow.domain.menu.MenuAndFilters;
import com.netgrif.application.engine.workflow.domain.menu.MenuEntry;
import com.netgrif.application.engine.workflow.domain.menu.MenuEntryRole;
import com.netgrif.application.engine.workflow.service.FilterImportExportService;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.IFilterImportExportService;
import com.netgrif.application.engine.workflow.service.interfaces.IMenuImportExportService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.querydsl.core.types.Predicate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuImportExportService
implements IMenuImportExportService {
    private static final Logger log = LoggerFactory.getLogger(MenuImportExportService.class);
    private static final String MENU_ITEM_NAME = "entry_name";
    private static final String USE_ICON = "use_icon";
    private static final String ALLOWED_ROLES = "allowed_roles";
    private static final String BANNED_ROLES = "banned_roles";
    private static final String MENU_IDENTIFIER = "menu_identifier";
    private static final String PARENT_ID = "parentId";
    private static final String ENTRY_DEFAULT_NAME = "entry_default_name";
    private static final String GROUP_NAV_TASK = "navigationMenuConfig";
    @Autowired
    IUserService userService;
    @Autowired
    IWorkflowService workflowService;
    @Autowired
    IPetriNetService petriNetService;
    @Autowired
    DefaultFiltersRunner defaultFiltersRunner;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private IDataService dataService;
    @Autowired
    private IFilterImportExportService filterImportExportService;
    @Autowired
    private StorageResolverService storageResolverService;

    @Override
    public FileFieldValue exportMenu(EnumerationMapField menusForExport, String groupId, FileField fileField) throws IOException {
        log.info("Exporting menu");
        MenuAndFilters menuAndFilters = new MenuAndFilters();
        for (Map.Entry<String, I18nString> option : menusForExport.getOptions().entrySet()) {
            Menu menu = new Menu();
            menu.setMenuIdentifier(option.getValue().toString());
            List<String> menuItemCaseIds = Arrays.asList(option.getKey().split(","));
            ArrayList<String> filterCaseIds = new ArrayList<String>();
            menu.setMenuEntries(new ArrayList<MenuEntry>());
            menuItemCaseIds.forEach(menuItemCaseId -> {
                Case menuItem = this.workflowService.findOne((String)menuItemCaseId);
                String filterId = (String)((List)menuItem.getDataSet().get("filter_case").getValue()).get(0);
                menu.getMenuEntries().add(this.createMenuEntryExportClass(menuItem, filterId));
                filterCaseIds.add(filterId);
            });
            menuAndFilters.getFilterList().getFilters().addAll(this.filterImportExportService.exportFilters(filterCaseIds).getFilters());
            menuAndFilters.getMenuList().getMenus().add(menu);
        }
        return this.createXML(menuAndFilters, groupId, fileField);
    }

    @Override
    public List<String> importMenu(List<Case> menuItemCases, FileFieldValue ffv, String parentId) throws IOException, IllegalMenuFileException, TransitionNotExecutableException {
        StringBuilder resultMessage = new StringBuilder("");
        ArrayList<String> importedEntryAndFilterCaseIds = new ArrayList<String>();
        MenuAndFilters menuAndFilters = this.loadFromXML(ffv);
        List<String> menuItemIdsToReplace = menuItemCases.stream().filter(caze -> menuAndFilters.getMenuList().getMenus().stream().anyMatch(menu -> Objects.equals(menu.getMenuIdentifier(), caze.getDataSet().get(MENU_IDENTIFIER).getValue()))).map(Case::getStringId).collect(Collectors.toList());
        if (!menuItemIdsToReplace.isEmpty()) {
            menuItemIdsToReplace.forEach(id -> {
                HashMap<String, Map<String, String>> caseToRemoveData = new HashMap<String, Map<String, String>>();
                HashMap<String, String> removeBtnData = new HashMap<String, String>();
                removeBtnData.put("type", "button");
                removeBtnData.put("value", "removed");
                caseToRemoveData.put("remove_option", removeBtnData);
                Case caseToRemove = this.workflowService.findOne((String)id);
                QTask qTask = new QTask("task");
                Task task = this.taskService.searchOne((Predicate)qTask.transitionId.eq((Object)"view").and((Predicate)qTask.caseId.eq((Object)caseToRemove.getStringId())));
                this.dataService.setData(task, ImportHelper.populateDataset(caseToRemoveData));
            });
        }
        Map<String, String> importedFilterTaskIds = this.filterImportExportService.importFilters(menuAndFilters.getFilterList());
        menuAndFilters.getMenuList().getMenus().forEach(menu -> {
            resultMessage.append("\nIMPORTING MENU \"").append(menu.getMenuIdentifier()).append("\":\n");
            menu.getMenuEntries().forEach(menuItem -> {
                String entryAndFilterCaseId = this.createMenuItemCase(resultMessage, (MenuEntry)menuItem, menu.getMenuIdentifier(), parentId, (String)importedFilterTaskIds.get(menuItem.getFilterCaseId()));
                if (!entryAndFilterCaseId.equals("")) {
                    importedEntryAndFilterCaseIds.add(entryAndFilterCaseId);
                }
            });
            QTask qTask = new QTask("task");
            Task task = this.taskService.searchOne((Predicate)qTask.transitionId.eq((Object)GROUP_NAV_TASK).and((Predicate)qTask.caseId.eq((Object)parentId)));
            HashMap<String, Map<String, String>> groupData = new HashMap<String, Map<String, String>>();
            HashMap<String, String> groupImportResultMessage = new HashMap<String, String>();
            groupImportResultMessage.put("type", "text");
            groupImportResultMessage.put("value", resultMessage.toString());
            groupData.put("import_results", groupImportResultMessage);
            this.dataService.setData(task, ImportHelper.populateDataset(groupData));
        });
        importedFilterTaskIds.values().forEach(taskId -> {
            Task importedFilterTask = this.taskService.findOne((String)taskId);
            Case filterCase = this.workflowService.findOne(importedFilterTask.getCaseId());
            try {
                this.taskService.assignTask(importedFilterTask.getStringId());
                this.taskService.finishTask(importedFilterTask.getStringId());
                this.workflowService.save(filterCase);
            }
            catch (TransitionNotExecutableException e) {
                log.error("Failed to execute \"import_filter\" task with id: " + taskId, (Throwable)e);
            }
        });
        return importedEntryAndFilterCaseIds;
    }

    @Override
    public String createMenuItemCase(StringBuilder resultMessage, MenuEntry item, String menuIdentifier, String parentId, String filterTaskId) {
        AtomicBoolean netCheck = new AtomicBoolean(true);
        resultMessage.append("\nMenu entry \"").append(item.getEntryName()).append("\": ");
        Task importedFilterTask = this.taskService.findOne(filterTaskId);
        Case filterCase = this.workflowService.findOne(importedFilterTask.getCaseId());
        if (filterCase == null) {
            resultMessage.append("Filter not found! Menu entry was skipped.\n");
            return "";
        }
        LinkedHashMap<String, I18nString> allowedRoles = new LinkedHashMap<String, I18nString>();
        LinkedHashMap<String, I18nString> bannedRoles = new LinkedHashMap<String, I18nString>();
        if (item.getMenuEntryRoleList() != null && !item.getMenuEntryRoleList().isEmpty()) {
            item.getMenuEntryRoleList().forEach(menuEntryRole -> {
                String roleImportId = menuEntryRole.getRoleImportId();
                String netImportId = menuEntryRole.getNetImportId();
                if (netImportId != null) {
                    PetriNet net = this.petriNetService.getNewestVersionByIdentifier(netImportId);
                    if (net == null) {
                        resultMessage.append("\n- Missing net with import ID: \"").append(netImportId).append("\"").append("for role ").append(roleImportId).append("\n");
                        netCheck.set(false);
                    } else {
                        Optional<ProcessRole> role = net.getRoles().values().stream().filter(r -> r.getImportId().equals(roleImportId)).findFirst();
                        if (role.isPresent()) {
                            if (menuEntryRole.getAuthorizationType().equals((Object)AuthorizationType.allowed)) {
                                allowedRoles.put(roleImportId + ":" + netImportId, new I18nString(role.get().getName() + "(" + net.getTitle() + ")"));
                            } else {
                                bannedRoles.put(roleImportId + ":" + netImportId, new I18nString(role.get().getName() + "(" + net.getTitle() + ")"));
                            }
                        } else {
                            resultMessage.append("\n- Role with import ID \"").append(roleImportId).append("\" ").append("does not exist in the latest present version of net \"").append(netImportId).append("\"\n");
                            netCheck.set(false);
                        }
                    }
                }
            });
        }
        Case menuItemCase = this.workflowService.createCase(this.petriNetService.getNewestVersionByIdentifier("preference_filter_item").getStringId(), item.getEntryName() + "_" + menuIdentifier, "", this.userService.getSystem().transformToLoggedUser()).getCase();
        QTask qTask = new QTask("task");
        Task task = this.taskService.searchOne((Predicate)qTask.transitionId.eq((Object)"init").and((Predicate)qTask.caseId.eq((Object)menuItemCase.getStringId())));
        try {
            this.taskService.assignTask(task, this.userService.getLoggedUser());
            menuItemCase.getDataSet().get(MENU_IDENTIFIER).setValue(menuIdentifier);
            menuItemCase.getDataSet().get(PARENT_ID).setValue(parentId);
            menuItemCase.getDataSet().get(ALLOWED_ROLES).setOptions(allowedRoles);
            menuItemCase.getDataSet().get(BANNED_ROLES).setOptions(bannedRoles);
            this.workflowService.save(menuItemCase);
        }
        catch (TransitionNotExecutableException e) {
            log.error("Failed to execute \"init\" task on preference filter item case with id: " + menuItemCase.getStringId(), (Throwable)e);
            netCheck.set(false);
            resultMessage.append("- Failed to execute \"init\" task");
        }
        if (netCheck.get()) {
            resultMessage.append("OK\n");
        }
        return task.getCaseId() + "," + filterCase.getStringId() + "," + item.getUseIcon().toString();
    }

    @Transactional
    protected MenuAndFilters loadFromXML(FileFieldValue ffv) throws IOException, IllegalMenuFileException {
        File f = new File(ffv.getPath());
        MenuImportExportService.validateFilterXML(new FileInputStream(f));
        SimpleModule module = new SimpleModule().addDeserializer(Object.class, (JsonDeserializer)FilterDeserializer.getInstance());
        XmlMapper xmlMapper = (XmlMapper)new XmlMapper().registerModule((Module)module);
        String xml = InputStreamToString.inputStreamToString(new FileInputStream(f));
        return (MenuAndFilters)xmlMapper.readValue(xml, MenuAndFilters.class);
    }

    @Transactional
    protected FileFieldValue createXML(MenuAndFilters menuAndFilters, String parentId, FileField fileField) throws IOException {
        FileFieldValue ffv = new FileFieldValue();
        try {
            ffv.setName("menu_" + this.userService.getLoggedUser().getFullName().replaceAll("\\s+", "") + ".xml");
            ffv.setPath(this.storageResolverService.resolve(fileField.getStorageType()).getPath(parentId, fileField.getImportId(), ffv.getName()));
            File f = new File(ffv.getPath());
            XmlMapper xmlMapper = new XmlMapper();
            xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
            xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            xmlMapper.writeValue((OutputStream)baos, (Object)menuAndFilters);
            FileOutputStream fos = new FileOutputStream(f);
            baos.writeTo(fos);
        }
        catch (Exception e) {
            log.error("Failed to export menu!", (Throwable)e);
        }
        return ffv;
    }

    private MenuEntry createMenuEntryExportClass(Case menuItemCase, String filterCaseId) {
        Map<String, I18nString> allowedRoles = menuItemCase.getDataSet().get(ALLOWED_ROLES).getOptions();
        Map<String, I18nString> bannedRoles = menuItemCase.getDataSet().get(BANNED_ROLES).getOptions();
        ArrayList<MenuEntryRole> menuEntryRoleList = new ArrayList<MenuEntryRole>();
        if (allowedRoles != null && !allowedRoles.isEmpty()) {
            menuEntryRoleList.addAll(allowedRoles.keySet().stream().map(roleNet -> {
                MenuEntryRole newMenuEntryRole = new MenuEntryRole();
                newMenuEntryRole.setRoleImportId(roleNet.split(":")[0]);
                newMenuEntryRole.setNetImportId(roleNet.split(":")[1]);
                newMenuEntryRole.setAuthorizationType(AuthorizationType.allowed);
                return newMenuEntryRole;
            }).collect(Collectors.toList()));
        }
        if (bannedRoles != null && !bannedRoles.isEmpty()) {
            menuEntryRoleList.addAll(bannedRoles.keySet().stream().map(roleNet -> {
                MenuEntryRole newMenuEntryRole = new MenuEntryRole();
                newMenuEntryRole.setRoleImportId(roleNet.split(":")[0]);
                newMenuEntryRole.setNetImportId(roleNet.split(":")[1]);
                newMenuEntryRole.setAuthorizationType(AuthorizationType.banned);
                return newMenuEntryRole;
            }).collect(Collectors.toList()));
        }
        MenuEntry exportMenuItem = new MenuEntry();
        exportMenuItem.setEntryName(menuItemCase.getDataSet().get(MENU_ITEM_NAME).toString());
        exportMenuItem.setFilterCaseId(filterCaseId);
        exportMenuItem.setUseIcon((Boolean)menuItemCase.getDataSet().get(USE_ICON).getValue());
        if (!menuEntryRoleList.isEmpty()) {
            exportMenuItem.setMenuEntryRoleList(menuEntryRoleList);
        }
        return exportMenuItem;
    }

    @Override
    public Map<String, I18nString> createAvailableEntriesChoices(List<Case> menuItemCases) {
        Map<String, I18nString> availableItems = menuItemCases.stream().collect(Collectors.toMap(Case::getStringId, v -> new I18nString((String)v.getDataSet().get(ENTRY_DEFAULT_NAME).getValue())));
        return availableItems;
    }

    @Override
    public Map<String, I18nString> addSelectedEntriesToExport(MultichoiceMapField availableEntries, EnumerationMapField menusForExport, String menuIdentifier) {
        LinkedHashMap<String, I18nString> updatedOptions = new LinkedHashMap<String, I18nString>(menusForExport.getOptions());
        String menuCaseIds = "";
        if (availableEntries.getOptions().size() != 0) {
            for (String id : (LinkedHashSet)availableEntries.getValue()) {
                menuCaseIds = menuCaseIds.concat(id + ",");
            }
            updatedOptions.put(menuCaseIds, new I18nString(menuIdentifier));
        }
        return updatedOptions;
    }

    private static void validateFilterXML(InputStream xml) throws IllegalMenuFileException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(FilterImportExportService.class.getResource("/petriNets/menu_export_schema.xsd"));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
        }
        catch (Exception ex) {
            throw new IllegalMenuFileException(ex);
        }
    }
}

