/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.workflow.service.IllegalQueryException;
import com.querydsl.core.BooleanBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MongoSearchService<T> {
    private static final Logger log = LoggerFactory.getLogger((String)MongoSearchService.class.getName());
    private static final String ERROR_KEY = "ERROR";
    @Autowired
    private IUserService userService;
    @Autowired
    private MongoTemplate mongoTemplate;
    private Class<T> tClass;

    public static String oid(String id) {
        return "{$oid:\"" + id + "\"}";
    }

    public static String in(List<Object> values, Function<Object, String> valueQueryBuilder, Predicate<Object> typeTest) {
        StringBuilder builder = new StringBuilder();
        builder.append("{$in:[");
        values.forEach(o -> {
            if (typeTest != null && !typeTest.test(o)) {
                return;
            }
            builder.append((String)valueQueryBuilder.apply(o));
            builder.append(",");
        });
        if (!values.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]}");
        return builder.toString();
    }

    public static String all(List<Object> values, Function<Object, String> valueQueryBuilder) {
        StringBuilder builder = new StringBuilder();
        builder.append("{$all:[");
        values.forEach(v -> {
            builder.append((String)valueQueryBuilder.apply(v));
            builder.append(",");
        });
        if (!values.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]}");
        return builder.toString();
    }

    public static String ref(String attr, Object id) {
        return "{$ref:\"" + attr + "\",$id:" + MongoSearchService.oid((String)id) + "}";
    }

    public static String or(Collection<Object> expressions) {
        if (expressions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("$or:[");
        expressions.forEach(obj -> {
            builder.append("{");
            if (obj instanceof String && ((String)obj).equalsIgnoreCase(":")) {
                builder.append("");
            } else {
                builder.append(obj);
            }
            builder.append("},");
        });
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    public static String exists(boolean val) {
        return "{$exists:" + val + "}";
    }

    public static String regex(String val, String opt) {
        return "{$regex:'" + val + "',$options:'" + opt + "'}";
    }

    public static String lessThenOrEqual(Object val) {
        return "{$lte:" + val + "}";
    }

    public static String elemMatch(Object obj, Function<Object, String> valueQueryBuilder) {
        return "{$elemMatch:" + valueQueryBuilder.apply(obj) + "}";
    }

    public static Object resolveDataValue(Object val, String type) {
        switch (type) {
            case "string": {
                return "\"" + val + "\"";
            }
            case "date": {
                return MongoSearchService.resolveDateValue((String)val);
            }
            case "array": {
                return val;
            }
            case "user": {
                return val;
            }
        }
        return val;
    }

    public static String resolveDateValue(String val) {
        String queryValue = "{";
        return queryValue;
    }

    public Page<T> search(Map<String, Object> searchRequest, Pageable pageable, Class<T> clazz) {
        try {
            this.tClass = clazz;
            return this.executeQuery(this.buildQuery(this.resolveRequest(searchRequest)), pageable);
        }
        catch (IllegalQueryException e) {
            log.error("Searching failed: ", (Throwable)e);
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
    }

    protected Map<String, Object> resolveRequest(Map<String, Object> request) {
        LinkedHashMap<String, Object> queryParts = new LinkedHashMap<String, Object>();
        boolean match = request.entrySet().stream().allMatch(entry -> {
            try {
                Method method = this.getClass().getMethod((String)entry.getKey() + "Query", Object.class);
                Object part = method.invoke((Object)this, entry.getValue());
                if (part != null) {
                    queryParts.put((String)entry.getKey(), part);
                }
                return true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Resolving request failed: ", (Throwable)e);
                queryParts.put(ERROR_KEY, "Parameter " + (String)entry.getKey() + " is not supported in " + this.tClass.getSimpleName() + " search!");
                return false;
            }
        });
        return queryParts;
    }

    public String buildQuery(Map<String, Object> queryParts) throws IllegalQueryException {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean result = queryParts.entrySet().stream().allMatch(entry -> {
            if (((String)entry.getKey()).equals(ERROR_KEY)) {
                return false;
            }
            if (((String)entry.getValue()).endsWith(":")) {
                queryParts.put(ERROR_KEY, "Query attribute " + (String)entry.getKey() + " has wrong value " + entry.getValue());
                return false;
            }
            builder.append(entry.getValue());
            builder.append(",");
            return true;
        });
        if (!result) {
            throw new IllegalQueryException((String)queryParts.get(ERROR_KEY));
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    protected Page<T> executeQuery(String queryString, Pageable pageable) {
        Query query = new BasicQuery(queryString).with(pageable);
        log.info("Executing search query: " + queryString);
        return new PageImpl(this.mongoTemplate.find(query, this.tClass), pageable, this.mongoTemplate.count((Query)new BasicQuery(queryString, "{_id:1}"), this.tClass));
    }

    public String idQuery(Object obj) {
        HashMap<Class, Function<Object, String>> builder = new HashMap<Class, Function<Object, String>>();
        builder.put(ArrayList.class, o -> MongoSearchService.in((List)obj, ob -> MongoSearchService.oid((String)ob), null));
        builder.put(String.class, o -> MongoSearchService.oid((String)o));
        return this.buildQueryPart("_id", obj, builder);
    }

    public String orQuery(Object obj) throws IllegalQueryException {
        if (!(obj instanceof Map)) {
            throw new IllegalQueryException("Parameter or must have JSON Object as value!");
        }
        Map<String, Object> orMap = this.resolveRequest((Map)obj);
        return MongoSearchService.or(orMap.values());
    }

    protected String buildQueryPart(String attribute, Object obj, Map<Class, Function<Object, String>> builder) {
        try {
            if (obj == null || obj instanceof List && ((List)obj).isEmpty()) {
                return ":";
            }
            Object attr = attribute != null ? "\"" + attribute + "\":" : "";
            return (String)attr + builder.get(obj.getClass()).apply(obj);
        }
        catch (NullPointerException e) {
            e.getStackTrace();
            return ":";
        }
    }

    protected String resolveAuthorByEmail(String email) {
        IUser user = this.userService.findByEmail(email, true);
        return user != null ? user.getStringId() : null;
    }

    protected BooleanBuilder constructPredicateTree(List<com.querydsl.core.types.Predicate> elementaryPredicates, BiFunction<BooleanBuilder, com.querydsl.core.types.Predicate, BooleanBuilder> nodeOperation) {
        if (elementaryPredicates.size() == 0) {
            return new BooleanBuilder();
        }
        ArrayDeque<BooleanBuilder> subtrees = new ArrayDeque<BooleanBuilder>(elementaryPredicates.size() / 2 + elementaryPredicates.size() % 2);
        Iterator<com.querydsl.core.types.Predicate> predicateIterator = elementaryPredicates.iterator();
        while (predicateIterator.hasNext()) {
            BooleanBuilder subtree = new BooleanBuilder(predicateIterator.next());
            if (predicateIterator.hasNext()) {
                nodeOperation.apply(subtree, predicateIterator.next());
            }
            subtrees.addFirst(subtree);
        }
        while (subtrees.size() != 1) {
            subtrees.addLast(nodeOperation.apply((BooleanBuilder)subtrees.pollFirst(), (com.querydsl.core.types.Predicate)subtrees.pollFirst()));
        }
        return (BooleanBuilder)subtrees.peekFirst();
    }
}

