/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.auth.domain.AnonymousUser;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.petrinet.domain.roles.RolePermission;
import com.netgrif.application.engine.petrinet.domain.throwable.IllegalTaskStateException;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.service.AbstractAuthorizationService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskAuthorizationService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskAuthorizationService
extends AbstractAuthorizationService
implements ITaskAuthorizationService {
    @Autowired
    ITaskService taskService;

    @Override
    public Boolean userHasAtLeastOneRolePermission(LoggedUser loggedUser, String taskId, RolePermission ... permissions) {
        return this.userHasAtLeastOneRolePermission(loggedUser.transformToUser(), this.taskService.findById(taskId), permissions);
    }

    @Override
    public Boolean userHasAtLeastOneRolePermission(IUser user, Task task, RolePermission ... permissions) {
        if (task.getRoles() == null || task.getRoles().isEmpty()) {
            return null;
        }
        Map<String, Boolean> aggregatePermissions = this.getAggregatePermissions(user, task.getRoles());
        for (RolePermission permission2 : permissions) {
            if (!this.hasRestrictedPermission(aggregatePermissions.get(permission2.toString()))) continue;
            return false;
        }
        return Arrays.stream(permissions).anyMatch(permission -> this.hasPermission((Boolean)aggregatePermissions.get(permission.toString())));
    }

    @Override
    public Boolean userHasUserListPermission(LoggedUser loggedUser, String taskId, RolePermission ... permissions) {
        return this.userHasUserListPermission(loggedUser.transformToUser(), this.taskService.findById(taskId), permissions);
    }

    @Override
    public Boolean userHasUserListPermission(IUser user, Task task, RolePermission ... permissions) {
        if (task.getUserRefs() == null || task.getUserRefs().isEmpty()) {
            return null;
        }
        if (!task.getUsers().containsKey(user.getSelfOrImpersonated().getStringId())) {
            return null;
        }
        Map<String, Boolean> userPermissions = task.getUsers().get(user.getSelfOrImpersonated().getStringId());
        for (RolePermission permission2 : permissions) {
            Boolean perm = userPermissions.get(permission2.toString());
            if (!this.hasRestrictedPermission(perm)) continue;
            return false;
        }
        return Arrays.stream(permissions).anyMatch(permission -> this.hasPermission((Boolean)userPermissions.get(permission.toString())));
    }

    @Override
    public boolean isAssignee(LoggedUser loggedUser, String taskId) {
        if (loggedUser.isAnonymous()) {
            return this.isAssignee((IUser)loggedUser.transformToAnonymousUser(), this.taskService.findById(taskId));
        }
        return this.isAssignee(loggedUser.transformToUser(), this.taskService.findById(taskId));
    }

    @Override
    public boolean isAssignee(IUser user, String taskId) {
        return this.isAssignee(user, this.taskService.findById(taskId));
    }

    @Override
    public boolean isAssignee(IUser user, Task task) {
        if (!this.isAssigned(task)) {
            return false;
        }
        return task.getUserId().equals(user.getSelfOrImpersonated().getStringId()) || user instanceof AnonymousUser;
    }

    private boolean isAssigned(String taskId) {
        return this.isAssigned(this.taskService.findById(taskId));
    }

    private boolean isAssigned(Task task) {
        return task.getUserId() != null;
    }

    @Override
    public boolean canCallAssign(LoggedUser loggedUser, String taskId) {
        Boolean rolePerm = this.userHasAtLeastOneRolePermission(loggedUser, taskId, RolePermission.ASSIGN);
        Boolean userPerm = this.userHasUserListPermission(loggedUser, taskId, RolePermission.ASSIGN);
        return loggedUser.getSelfOrImpersonated().isAdmin() || (userPerm == null ? rolePerm != null && rolePerm != false : userPerm != false);
    }

    @Override
    public boolean canCallDelegate(LoggedUser loggedUser, String taskId) {
        Boolean rolePerm = this.userHasAtLeastOneRolePermission(loggedUser, taskId, RolePermission.DELEGATE);
        Boolean userPerm = this.userHasUserListPermission(loggedUser, taskId, RolePermission.DELEGATE);
        return loggedUser.getSelfOrImpersonated().isAdmin() || (userPerm == null ? rolePerm != null && rolePerm != false : userPerm != false);
    }

    @Override
    public boolean canCallFinish(LoggedUser loggedUser, String taskId) throws IllegalTaskStateException {
        if (!this.isAssigned(taskId)) {
            throw new IllegalTaskStateException("Task with ID '" + taskId + "' cannot be finished, because it is not assigned!");
        }
        Boolean rolePerm = this.userHasAtLeastOneRolePermission(loggedUser, taskId, RolePermission.FINISH);
        Boolean userPerm = this.userHasUserListPermission(loggedUser, taskId, RolePermission.FINISH);
        return loggedUser.getSelfOrImpersonated().isAdmin() || (userPerm == null ? rolePerm != null && rolePerm != false : userPerm != false) && this.isAssignee(loggedUser, taskId);
    }

    private boolean canAssignedCancel(IUser user, String taskId) {
        Task task = this.taskService.findById(taskId);
        if (!this.isAssigned(task) || !task.getUserId().equals(user.getSelfOrImpersonated().getStringId())) {
            return true;
        }
        return task.getAssignedUserPolicy() == null || task.getAssignedUserPolicy().get("cancel") == null || task.getAssignedUserPolicy().get("cancel") != false;
    }

    @Override
    public boolean canCallCancel(LoggedUser loggedUser, String taskId) throws IllegalTaskStateException {
        if (!this.isAssigned(taskId)) {
            throw new IllegalTaskStateException("Task with ID '" + taskId + "' cannot be canceled, because it is not assigned!");
        }
        Boolean rolePerm = this.userHasAtLeastOneRolePermission(loggedUser, taskId, RolePermission.CANCEL);
        Boolean userPerm = this.userHasUserListPermission(loggedUser, taskId, RolePermission.CANCEL);
        return loggedUser.getSelfOrImpersonated().isAdmin() || (userPerm == null ? rolePerm != null && rolePerm != false : userPerm != false) && this.isAssignee(loggedUser, taskId) && this.canAssignedCancel(loggedUser.transformToUser(), taskId);
    }

    @Override
    public boolean canCallSaveData(LoggedUser loggedUser, String taskId) {
        return loggedUser.getSelfOrImpersonated().isAdmin() || this.isAssignee(loggedUser, taskId);
    }

    @Override
    public boolean canCallSaveFile(LoggedUser loggedUser, String taskId) {
        return loggedUser.getSelfOrImpersonated().isAdmin() || this.isAssignee(loggedUser, taskId);
    }
}

