/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.web.responsebodies.Reference;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.workflow.domain.QTask;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.service.MongoSearchService;
import com.netgrif.application.engine.workflow.web.requestbodies.TaskSearchRequest;
import com.netgrif.application.engine.workflow.web.requestbodies.taskSearch.TaskSearchCaseRequest;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TaskSearchService
extends MongoSearchService<Task> {
    @Autowired
    private IPetriNetService petriNetService;

    public Predicate buildQuery(List<TaskSearchRequest> requests, LoggedUser user, Locale locale, Boolean isIntersection) {
        LoggedUser loggedOrImpersonated = user.getSelfOrImpersonated();
        List<Object> singleQueries = requests.stream().map(r -> this.buildSingleQuery((TaskSearchRequest)r, loggedOrImpersonated, locale)).collect(Collectors.toList());
        if (isIntersection.booleanValue() && !singleQueries.stream().allMatch(Objects::nonNull)) {
            return null;
        }
        if (!isIntersection.booleanValue() && (singleQueries = singleQueries.stream().filter(Objects::nonNull).collect(Collectors.toList())).size() == 0) {
            return null;
        }
        BooleanBuilder builder = this.constructPredicateTree(singleQueries, isIntersection != false ? BooleanBuilder::and : BooleanBuilder::or);
        BooleanBuilder constraints = new BooleanBuilder(this.buildRolesQueryConstraint(loggedOrImpersonated));
        constraints.or(this.buildUserRefQueryConstraint(loggedOrImpersonated));
        builder.and((Predicate)constraints);
        BooleanBuilder permissionConstraints = new BooleanBuilder(this.buildViewRoleQueryConstraint(loggedOrImpersonated));
        permissionConstraints.andNot(this.buildNegativeViewRoleQueryConstraint(loggedOrImpersonated));
        permissionConstraints.or(this.buildViewUserQueryConstraint(loggedOrImpersonated));
        permissionConstraints.andNot(this.buildNegativeViewUsersQueryConstraint(loggedOrImpersonated));
        builder.and((Predicate)permissionConstraints);
        return builder;
    }

    protected Predicate buildRolesQueryConstraint(LoggedUser user) {
        List<Predicate> roleConstraints = user.getProcessRoles().stream().map(this::roleQuery).collect(Collectors.toList());
        return this.constructPredicateTree(roleConstraints, BooleanBuilder::or);
    }

    protected Predicate buildUserRefQueryConstraint(LoggedUser user) {
        Predicate userRefConstraints = this.userRefQuery(user.getId());
        return this.constructPredicateTree(Collections.singletonList(userRefConstraints), BooleanBuilder::or);
    }

    protected Predicate buildViewRoleQueryConstraint(LoggedUser user) {
        List<Predicate> roleConstraints = user.getProcessRoles().stream().map(this::viewRoleQuery).collect(Collectors.toList());
        return this.constructPredicateTree(roleConstraints, BooleanBuilder::or);
    }

    public Predicate viewRoleQuery(String role) {
        return QTask.task.viewUserRefs.isEmpty().and((Predicate)QTask.task.viewRoles.isEmpty()).or((Predicate)QTask.task.viewRoles.contains((Object)role));
    }

    protected Predicate buildViewUserQueryConstraint(LoggedUser user) {
        Predicate userConstraints = this.viewUsersQuery(user.getId());
        return this.constructPredicateTree(Collections.singletonList(userConstraints), BooleanBuilder::or);
    }

    public Predicate viewUsersQuery(String userId) {
        return QTask.task.negativeViewRoles.isEmpty().and((Predicate)QTask.task.viewUserRefs.isEmpty()).and((Predicate)QTask.task.viewRoles.isEmpty()).or((Predicate)QTask.task.viewUsers.contains((Object)userId));
    }

    protected Predicate buildNegativeViewRoleQueryConstraint(LoggedUser user) {
        List<Predicate> roleConstraints = user.getProcessRoles().stream().map(this::negativeViewRoleQuery).collect(Collectors.toList());
        return this.constructPredicateTree(roleConstraints, BooleanBuilder::or);
    }

    public Predicate negativeViewRoleQuery(String role) {
        return QTask.task.negativeViewRoles.contains((Object)role);
    }

    protected Predicate buildNegativeViewUsersQueryConstraint(LoggedUser user) {
        Predicate userConstraints = this.negativeViewUsersQuery(user.getId());
        return this.constructPredicateTree(Collections.singletonList(userConstraints), BooleanBuilder::or);
    }

    public Predicate negativeViewUsersQuery(String userId) {
        return QTask.task.negativeViewUsers.contains((Object)userId);
    }

    private Predicate buildSingleQuery(TaskSearchRequest request, LoggedUser user, Locale locale) {
        BooleanBuilder builder = new BooleanBuilder();
        this.buildStringIdQuery(request, builder);
        this.buildRoleQuery(request, builder);
        this.buildCaseQuery(request, builder);
        this.buildTitleQuery(request, builder);
        this.buildUserQuery(request, builder);
        this.buildProcessQuery(request, builder);
        this.buildFullTextQuery(request, builder);
        this.buildTransitionQuery(request, builder);
        this.buildTagsQuery(request, builder);
        boolean resultAlwaysEmpty = this.buildGroupQuery(request, user, locale, builder);
        if (resultAlwaysEmpty) {
            return null;
        }
        return builder;
    }

    private void buildStringIdQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.stringId == null || request.stringId.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.stringId.stream().map(this::stringIdQuery).collect(Collectors.toList()), BooleanBuilder::or));
    }

    private void buildRoleQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.role == null || request.role.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.role.stream().map(this::roleQuery).collect(Collectors.toList()), BooleanBuilder::or));
    }

    public Predicate roleQuery(String role) {
        return QTask.task.roles.containsKey((Object)role);
    }

    public Predicate stringIdQuery(String id) {
        return QTask.task._id.eq(new ObjectId(id));
    }

    public Predicate userRefQuery(String userId) {
        return QTask.task.users.containsKey((Object)userId);
    }

    private void buildCaseQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.useCase == null || request.useCase.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.useCase.stream().map(this::caseRequestQuery).filter(Objects::nonNull).collect(Collectors.toList()), BooleanBuilder::or));
    }

    private Predicate caseRequestQuery(TaskSearchCaseRequest caseRequest) {
        if (caseRequest.id != null) {
            return this.caseIdQuery(caseRequest.id);
        }
        if (caseRequest.title != null) {
            return this.caseTitleQuery(caseRequest.title);
        }
        return null;
    }

    public Predicate caseIdQuery(String caseId) {
        return QTask.task.caseId.eq((Object)caseId);
    }

    public Predicate caseTitleQuery(String caseTitle) {
        return QTask.task.caseTitle.containsIgnoreCase(caseTitle);
    }

    private void buildTitleQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.title == null || request.title.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.title.stream().map(this::titleQuery).collect(Collectors.toList()), BooleanBuilder::or));
    }

    public Predicate titleQuery(String query) {
        return QTask.task.title.defaultValue.containsIgnoreCase(query);
    }

    private void buildUserQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.user == null || request.user.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.user.stream().map(this::userQuery).collect(Collectors.toList()), BooleanBuilder::or));
    }

    public Predicate userQuery(String userId) {
        return QTask.task.userId.eq((Object)userId);
    }

    private void buildProcessQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.process == null || request.process.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.process.stream().map(p -> this.processQuery(p.identifier)).collect(Collectors.toList()), BooleanBuilder::or));
    }

    public Predicate processQuery(String processId) {
        return QTask.task.processId.eq((Object)processId);
    }

    private void buildFullTextQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.fullText == null || request.fullText.isEmpty()) {
            return;
        }
        query.and(this.fullTextQuery(request.fullText));
    }

    public Predicate fullTextQuery(String searchedText) {
        BooleanBuilder builder = new BooleanBuilder();
        builder.or((Predicate)QTask.task.title.defaultValue.containsIgnoreCase(searchedText));
        builder.or((Predicate)QTask.task.caseTitle.containsIgnoreCase(searchedText));
        return builder;
    }

    private void buildTransitionQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.transitionId == null || request.transitionId.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.transitionId.stream().map(this::transitionQuery).collect(Collectors.toList()), BooleanBuilder::or));
    }

    public Predicate transitionQuery(String transitionId) {
        return QTask.task.transitionId.eq((Object)transitionId);
    }

    public boolean buildGroupQuery(TaskSearchRequest request, LoggedUser user, Locale locale, BooleanBuilder query) {
        if (request.group == null || request.group.isEmpty()) {
            return false;
        }
        PetriNetSearch processQuery = new PetriNetSearch();
        processQuery.setGroup(request.group);
        List groupProcesses = this.petriNetService.search(processQuery, user, (Pageable)new FullPageRequest(), locale).getContent();
        if (groupProcesses.size() == 0) {
            return true;
        }
        query.and((Predicate)this.constructPredicateTree(groupProcesses.stream().map(Reference::getStringId).map(arg_0 -> ((StringPath)QTask.task.processId).eq(arg_0)).collect(Collectors.toList()), BooleanBuilder::or));
        return false;
    }

    private void buildTagsQuery(TaskSearchRequest request, BooleanBuilder query) {
        if (request.tags == null || request.tags.isEmpty()) {
            return;
        }
        query.and((Predicate)this.constructPredicateTree(request.tags.entrySet().stream().map(entry -> this.tagQuery((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()), BooleanBuilder::and));
    }

    public Predicate tagQuery(String key, String value) {
        return ((StringPath)QTask.task.tags.get((Object)key)).eq((Object)value);
    }
}

