/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.google.common.collect.Ordering;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskMappingService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskService;
import com.netgrif.application.engine.history.domain.taskevents.AssignTaskEventLog;
import com.netgrif.application.engine.history.domain.taskevents.CancelTaskEventLog;
import com.netgrif.application.engine.history.domain.taskevents.DelegateTaskEventLog;
import com.netgrif.application.engine.history.domain.taskevents.FinishTaskEventLog;
import com.netgrif.application.engine.history.service.IHistoryService;
import com.netgrif.application.engine.petrinet.domain.DataFieldLogic;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.Place;
import com.netgrif.application.engine.petrinet.domain.Transaction;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.arcs.Arc;
import com.netgrif.application.engine.petrinet.domain.arcs.ArcOrderComparator;
import com.netgrif.application.engine.petrinet.domain.arcs.ResetArc;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.domain.throwable.TransitionNotExecutableException;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.rules.domain.facts.TransitionEventFact;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEngine;
import com.netgrif.application.engine.utils.DateUtils;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.validation.service.interfaces.IValidationService;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.TaskNotFoundException;
import com.netgrif.application.engine.workflow.domain.TaskPair;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.EventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.SetDataEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.taskoutcomes.AssignTaskEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.taskoutcomes.CancelTaskEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.taskoutcomes.DelegateTaskEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.taskoutcomes.FinishTaskEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.taskoutcomes.TaskEventOutcome;
import com.netgrif.application.engine.workflow.domain.repositories.TaskRepository;
import com.netgrif.application.engine.workflow.domain.triggers.TimeTrigger;
import com.netgrif.application.engine.workflow.domain.triggers.Trigger;
import com.netgrif.application.engine.workflow.service.TaskSearchService;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.IEventService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.netgrif.application.engine.workflow.web.requestbodies.TaskSearchRequest;
import com.netgrif.application.engine.workflow.web.responsebodies.TaskReference;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class TaskService
implements ITaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskService.class);
    @Autowired
    protected ApplicationEventPublisher publisher;
    @Autowired
    protected TaskRepository taskRepository;
    @Autowired
    protected IUserService userService;
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    protected TaskSearchService searchService;
    @Autowired
    @Qualifier(value="taskScheduler")
    protected TaskScheduler scheduler;
    @Autowired
    protected IWorkflowService workflowService;
    @Autowired
    protected IDataService dataService;
    @Autowired
    protected IProcessRoleService processRoleService;
    @Autowired
    protected IElasticTaskMappingService taskMappingService;
    @Autowired
    protected IEventService eventService;
    protected IElasticTaskService elasticTaskService;
    @Autowired
    protected IHistoryService historyService;
    @Autowired
    protected IValidationService validation;
    @Autowired
    private IRuleEngine ruleEngine;

    @Lazy
    @Autowired
    public void setElasticTaskService(IElasticTaskService elasticTaskService) {
        this.elasticTaskService = elasticTaskService;
    }

    @Override
    public List<AssignTaskEventOutcome> assignTasks(List<Task> tasks, IUser user) throws TransitionNotExecutableException {
        return this.assignTasks(tasks, user, new HashMap<String, String>());
    }

    @Override
    public List<AssignTaskEventOutcome> assignTasks(List<Task> tasks, IUser user, Map<String, String> params) throws TransitionNotExecutableException {
        ArrayList<AssignTaskEventOutcome> outcomes = new ArrayList<AssignTaskEventOutcome>();
        for (Task task : tasks) {
            outcomes.add(this.assignTask(task, user, params));
        }
        return outcomes;
    }

    @Override
    public AssignTaskEventOutcome assignTask(LoggedUser loggedUser, String taskId) throws TransitionNotExecutableException {
        return this.assignTask(loggedUser, taskId, new HashMap<String, String>());
    }

    @Override
    public AssignTaskEventOutcome assignTask(LoggedUser loggedUser, String taskId, Map<String, String> params) throws TransitionNotExecutableException {
        Optional taskOptional = this.taskRepository.findById(taskId);
        if (taskOptional.isEmpty()) {
            throw new TaskNotFoundException("Could not find task with id [" + taskId + "]");
        }
        IUser user = this.getUserFromLoggedUser(loggedUser);
        return this.assignTask((Task)taskOptional.get(), user, params);
    }

    @Override
    public AssignTaskEventOutcome assignTask(String taskId) throws TransitionNotExecutableException {
        return this.assignTask(taskId, new HashMap<String, String>());
    }

    @Override
    public AssignTaskEventOutcome assignTask(String taskId, Map<String, String> params) throws TransitionNotExecutableException {
        LoggedUser user = this.userService.getLoggedOrSystem().transformToLoggedUser();
        return this.assignTask(user, taskId, params);
    }

    @Override
    public AssignTaskEventOutcome assignTask(Task task, IUser user) throws TransitionNotExecutableException {
        return this.assignTask(task, user, new HashMap<String, String>());
    }

    @Override
    public AssignTaskEventOutcome assignTask(Task task, IUser user, Map<String, String> params) throws TransitionNotExecutableException {
        Case useCase = this.workflowService.findOne(task.getCaseId());
        Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
        ArrayList<EventOutcome> outcomes = new ArrayList<EventOutcome>(this.eventService.runActions(transition.getPreAssignActions(), useCase, task, transition, params));
        task = this.findOne(task.getStringId());
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.ASSIGN, EventPhase.PRE);
        useCase = this.assignTaskToUser(user, task, useCase.getStringId());
        this.historyService.save(new AssignTaskEventLog(task, useCase, EventPhase.PRE, user));
        outcomes.addAll(this.eventService.runActions(transition.getPostAssignActions(), useCase, task, transition, params));
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.ASSIGN, EventPhase.POST);
        this.historyService.save(new AssignTaskEventLog(task, useCase, EventPhase.POST, user));
        AssignTaskEventOutcome outcome = new AssignTaskEventOutcome(useCase, task, outcomes);
        this.addMessageToOutcome(transition, EventType.ASSIGN, outcome);
        log.info("[" + useCase.getStringId() + "]: Task [" + task.getTitle() + "] in case [" + useCase.getTitle() + "] assigned to [" + user.getSelfOrImpersonated().getEmail() + "]");
        return outcome;
    }

    protected Case assignTaskToUser(IUser user, Task task, String useCaseId) throws TransitionNotExecutableException {
        Case useCase = this.workflowService.findOne(useCaseId);
        useCase.getPetriNet().initializeArcs();
        Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
        log.info("[" + useCaseId + "]: Assigning task [" + task.getTitle() + "] to user [" + user.getSelfOrImpersonated().getEmail() + "]");
        this.startExecution(transition, useCase);
        task.setUserId(user.getSelfOrImpersonated().getStringId());
        task.setStartDate(LocalDateTime.now());
        task.setUser(user.getSelfOrImpersonated());
        useCase = this.workflowService.save(useCase);
        this.save(task);
        this.reloadTasks(useCase);
        useCase = this.workflowService.findOne(useCase.getStringId());
        return useCase;
    }

    @Override
    public List<FinishTaskEventOutcome> finishTasks(List<Task> tasks, IUser user) throws TransitionNotExecutableException {
        return this.finishTasks(tasks, user, new HashMap<String, String>());
    }

    @Override
    public List<FinishTaskEventOutcome> finishTasks(List<Task> tasks, IUser user, Map<String, String> params) throws TransitionNotExecutableException {
        ArrayList<FinishTaskEventOutcome> outcomes = new ArrayList<FinishTaskEventOutcome>();
        for (Task task : tasks) {
            outcomes.add(this.finishTask(task, user, params));
        }
        return outcomes;
    }

    @Override
    public FinishTaskEventOutcome finishTask(String taskId) throws IllegalArgumentException, TransitionNotExecutableException {
        return this.finishTask(taskId, new HashMap<String, String>());
    }

    @Override
    public FinishTaskEventOutcome finishTask(String taskId, Map<String, String> params) throws IllegalArgumentException, TransitionNotExecutableException {
        LoggedUser user = this.userService.getLoggedOrSystem().transformToLoggedUser();
        return this.finishTask(user, taskId, params);
    }

    @Override
    public FinishTaskEventOutcome finishTask(LoggedUser loggedUser, String taskId) throws IllegalArgumentException, TransitionNotExecutableException {
        return this.finishTask(loggedUser, taskId, new HashMap<String, String>());
    }

    @Override
    public FinishTaskEventOutcome finishTask(LoggedUser loggedUser, String taskId, Map<String, String> params) throws IllegalArgumentException, TransitionNotExecutableException {
        Optional taskOptional = this.taskRepository.findById(taskId);
        if (taskOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find task with id [" + taskId + "]");
        }
        Task task = (Task)taskOptional.get();
        IUser user = this.getUserFromLoggedUser(loggedUser);
        if (task.getUserId() == null) {
            throw new IllegalArgumentException("Task with id=" + taskId + " is not assigned to any user.");
        }
        if (!task.getUserId().equals(user.getSelfOrImpersonated().getStringId()) && !loggedUser.isAnonymous()) {
            throw new IllegalArgumentException("User that is not assigned tried to finish task");
        }
        return this.finishTask(task, user, params);
    }

    @Override
    public FinishTaskEventOutcome finishTask(Task task, IUser user) throws TransitionNotExecutableException {
        return this.finishTask(task, user, new HashMap<String, String>());
    }

    @Override
    public FinishTaskEventOutcome finishTask(Task task, IUser user, Map<String, String> params) throws TransitionNotExecutableException {
        Case useCase = this.workflowService.findOne(task.getCaseId());
        Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
        log.info("[" + useCase.getStringId() + "]: Finishing task [" + task.getTitle() + "] to user [" + user.getSelfOrImpersonated().getEmail() + "]");
        this.validateData(transition, useCase);
        ArrayList<EventOutcome> outcomes = new ArrayList<EventOutcome>(this.eventService.runActions(transition.getPreFinishActions(), useCase, task, transition, params));
        task = this.findOne(task.getStringId());
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.FINISH, EventPhase.PRE);
        this.finishExecution(transition, useCase.getStringId());
        task.setFinishDate(LocalDateTime.now());
        task.setFinishedBy(task.getUserId());
        task.setUserId(null);
        useCase = this.workflowService.findOne(useCase.getStringId());
        this.save(task);
        this.reloadTasks(useCase);
        useCase = this.workflowService.findOne(useCase.getStringId());
        this.historyService.save(new FinishTaskEventLog(task, useCase, EventPhase.PRE, user));
        outcomes.addAll(this.eventService.runActions(transition.getPostFinishActions(), useCase, task, transition, params));
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.FINISH, EventPhase.POST);
        FinishTaskEventOutcome outcome = new FinishTaskEventOutcome(useCase, task, outcomes);
        this.addMessageToOutcome(transition, EventType.FINISH, outcome);
        this.historyService.save(new FinishTaskEventLog(task, useCase, EventPhase.POST, user));
        log.info("[" + useCase.getStringId() + "]: Task [" + task.getTitle() + "] in case [" + useCase.getTitle() + "] assigned to [" + user.getSelfOrImpersonated().getEmail() + "] was finished");
        return outcome;
    }

    @Override
    public List<CancelTaskEventOutcome> cancelTasks(List<Task> tasks, IUser user) {
        return this.cancelTasks(tasks, user, new HashMap<String, String>());
    }

    @Override
    public List<CancelTaskEventOutcome> cancelTasks(List<Task> tasks, IUser user, Map<String, String> params) {
        ArrayList<CancelTaskEventOutcome> outcomes = new ArrayList<CancelTaskEventOutcome>();
        for (Task task : tasks) {
            outcomes.add(this.cancelTask(task, user, params));
        }
        return outcomes;
    }

    @Override
    public CancelTaskEventOutcome cancelTask(LoggedUser loggedUser, String taskId) {
        return this.cancelTask(loggedUser, taskId, new HashMap<String, String>());
    }

    @Override
    public CancelTaskEventOutcome cancelTask(LoggedUser loggedUser, String taskId, Map<String, String> params) {
        Optional taskOptional = this.taskRepository.findById(taskId);
        if (taskOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find task with id [" + taskId + "]");
        }
        IUser user = this.getUserFromLoggedUser(loggedUser);
        return this.cancelTask((Task)taskOptional.get(), user, params);
    }

    @Override
    public CancelTaskEventOutcome cancelTask(Task task, IUser user) {
        return this.cancelTask(task, user, new HashMap<String, String>());
    }

    @Override
    public CancelTaskEventOutcome cancelTask(Task task, IUser user, Map<String, String> params) {
        Case useCase = this.workflowService.findOne(task.getCaseId());
        Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
        log.info("[" + useCase.getStringId() + "]: Canceling task [" + task.getTitle() + "] to user [" + user.getSelfOrImpersonated().getEmail() + "]");
        ArrayList<EventOutcome> outcomes = new ArrayList<EventOutcome>(this.eventService.runActions(transition.getPreCancelActions(), useCase, task, transition, params));
        task = this.findOne(task.getStringId());
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.CANCEL, EventPhase.PRE);
        task = this.returnTokens(task, useCase.getStringId());
        useCase = this.workflowService.findOne(useCase.getStringId());
        this.reloadTasks(useCase);
        useCase = this.workflowService.findOne(useCase.getStringId());
        this.historyService.save(new CancelTaskEventLog(task, useCase, EventPhase.PRE, user));
        outcomes.addAll(this.eventService.runActions(transition.getPostCancelActions(), useCase, task, transition, params));
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.CANCEL, EventPhase.POST);
        CancelTaskEventOutcome outcome = new CancelTaskEventOutcome(useCase, task);
        outcome.setOutcomes(outcomes);
        this.addMessageToOutcome(transition, EventType.CANCEL, outcome);
        this.historyService.save(new CancelTaskEventLog(task, useCase, EventPhase.POST, user));
        log.info("[" + useCase.getStringId() + "]: Task [" + task.getTitle() + "] in case [" + useCase.getTitle() + "] assigned to [" + user.getSelfOrImpersonated().getEmail() + "] was cancelled");
        return outcome;
    }

    @Override
    public void cancelTasksWithoutReload(Set<String> transitions, String caseId) {
        this.cancelTasksWithoutReload(transitions, caseId, new HashMap<String, String>());
    }

    @Override
    public void cancelTasksWithoutReload(Set<String> transitions, String caseId, Map<String, String> params) {
        List<Task> tasks = this.taskRepository.findAllByTransitionIdInAndCaseId(transitions, caseId);
        Case useCase = null;
        for (Task task : tasks) {
            if (task.getUserId() == null) continue;
            if (useCase == null) {
                useCase = this.workflowService.findOne(task.getCaseId());
            }
            Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
            this.eventService.runActions(transition.getPreCancelActions(), useCase, task, transition, params);
            this.returnTokens(task, useCase.getStringId());
            this.eventService.runActions(transition.getPostCancelActions(), useCase, task, transition, params);
        }
    }

    private Task returnTokens(Task task, String useCaseId) {
        Case useCase = this.workflowService.findOne(useCaseId);
        PetriNet net = useCase.getPetriNet();
        net.getArcsOfTransition(task.getTransitionId()).stream().filter(arc -> arc.getSource() instanceof Place).forEach(arc -> {
            arc.rollbackExecution(useCase.getConsumedTokens().get(arc.getStringId()));
            useCase.getConsumedTokens().remove(arc.getStringId());
        });
        this.workflowService.updateMarking(useCase);
        task.setUserId(null);
        task.setStartDate(null);
        task = this.save(task);
        this.workflowService.save(useCase);
        return task;
    }

    @Override
    public DelegateTaskEventOutcome delegateTask(LoggedUser loggedUser, String delegatedId, String taskId) throws TransitionNotExecutableException {
        return this.delegateTask(loggedUser, delegatedId, taskId, new HashMap<String, String>());
    }

    @Override
    public DelegateTaskEventOutcome delegateTask(LoggedUser loggedUser, String delegatedId, String taskId, Map<String, String> params) throws TransitionNotExecutableException {
        IUser delegatedUser = this.userService.resolveById(delegatedId, true);
        IUser delegateUser = this.getUserFromLoggedUser(loggedUser);
        Optional taskOptional = this.taskRepository.findById(taskId);
        if (taskOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find task with id [" + taskId + "]");
        }
        Task task = (Task)taskOptional.get();
        Case useCase = this.workflowService.findOne(task.getCaseId());
        Transition transition = useCase.getPetriNet().getTransition(task.getTransitionId());
        log.info("[" + useCase.getStringId() + "]: Delegating task [" + task.getTitle() + "] to user [" + delegatedUser.getEmail() + "]");
        ArrayList<EventOutcome> outcomes = new ArrayList<EventOutcome>(this.eventService.runActions(transition.getPreDelegateActions(), useCase, task, transition, params));
        task = this.findOne(task.getStringId());
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.DELEGATE, EventPhase.PRE);
        this.delegate(delegatedUser, task, useCase);
        this.historyService.save(new DelegateTaskEventLog(task, useCase, EventPhase.PRE, delegateUser, delegatedUser.getStringId()));
        outcomes.addAll(this.eventService.runActions(transition.getPostDelegateActions(), useCase, task, transition, params));
        useCase = this.evaluateRules(useCase.getStringId(), task, EventType.DELEGATE, EventPhase.POST);
        useCase = this.workflowService.findOne(useCase.getStringId());
        this.reloadTasks(useCase);
        DelegateTaskEventOutcome outcome = new DelegateTaskEventOutcome(useCase, task, outcomes);
        this.addMessageToOutcome(transition, EventType.DELEGATE, outcome);
        this.historyService.save(new DelegateTaskEventLog(task, useCase, EventPhase.POST, delegateUser, delegatedUser.getStringId()));
        log.info("Task [" + task.getTitle() + "] in case [" + useCase.getTitle() + "] assigned to [" + delegateUser.getSelfOrImpersonated().getEmail() + "] was delegated to [" + delegatedUser.getEmail() + "]");
        return outcome;
    }

    protected void delegate(IUser delegated, Task task, Case useCase) throws TransitionNotExecutableException {
        if (task.getUserId() != null) {
            task.setUserId(delegated.getStringId());
            task.setUser(delegated);
            this.save(task);
        } else {
            this.assignTaskToUser(delegated, task, useCase.getStringId());
        }
    }

    protected Case evaluateRules(String caseId, Task task, EventType eventType, EventPhase eventPhase) {
        Case useCase = this.workflowService.findOne(caseId);
        log.info("[" + useCase.getStringId() + "]: Task [" + task.getTitle() + "] in case [" + useCase.getTitle() + "] evaluating rules of event " + eventType.name() + " of phase " + eventPhase.name());
        int rulesExecuted = this.ruleEngine.evaluateRules(useCase, task, TransitionEventFact.of(task, eventType, eventPhase));
        if (rulesExecuted == 0) {
            return useCase;
        }
        return this.workflowService.save(useCase);
    }

    @Override
    public void reloadTasks(Case useCase) {
        log.info("[" + useCase.getStringId() + "]: Reloading tasks in [" + useCase.getTitle() + "]");
        PetriNet net = useCase.getPetriNet();
        ArrayList<Task> newTasks = new ArrayList<Task>();
        ArrayList<Task> disabledTasks = new ArrayList<Task>();
        Map<String, String> tasks = useCase.getTasks().stream().collect(Collectors.toMap(TaskPair::getTransition, TaskPair::getTask));
        for (Transition transition : net.getTransitions().values()) {
            Task task;
            Optional optionalTask;
            String taskId = tasks.get(transition.getImportId());
            if (this.isExecutable(transition, net)) {
                if (taskId != null) continue;
                newTasks.add(this.createFromTransition(transition, useCase));
                continue;
            }
            if (taskId == null || (optionalTask = this.taskRepository.findById(taskId)).isEmpty() || (task = (Task)optionalTask.get()).getUserId() != null && !task.getUserId().isBlank()) continue;
            disabledTasks.add(task);
        }
        this.save(newTasks);
        this.delete(disabledTasks, useCase);
        useCase = this.workflowService.resolveUserRef(useCase);
        for (Task task : newTasks) {
            this.executeIfAutoTrigger(useCase, net, task);
        }
    }

    private void executeIfAutoTrigger(Case useCase, PetriNet net, Task task) {
        try {
            Transition transition = net.getTransition(task.getTransitionId());
            if (transition.hasAutoTrigger()) {
                this.executeTransition(task, useCase);
            }
        }
        catch (TaskNotFoundException e) {
            log.info("Could not execute auto trigger on task [" + task.getStringId() + "],[" + task.getTransitionId() + "], reason: " + e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    boolean isExecutable(Transition transition, PetriNet net) {
        List<Arc> arcsOfTransition = net.getArcsOfTransition(transition);
        if (arcsOfTransition == null) {
            return true;
        }
        return arcsOfTransition.stream().filter(arc -> arc.getDestination().equals(transition)).allMatch(Arc::isExecutable);
    }

    void finishExecution(Transition transition, String useCaseId) throws TransitionNotExecutableException {
        Case useCase = this.workflowService.findOne(useCaseId);
        log.info("[" + useCaseId + "]: Finish execution of task [" + transition.getTitle() + "] in case [" + useCase.getTitle() + "]");
        this.execute(transition, useCase, arc -> arc.getSource().equals(transition));
        Supplier<Stream> arcStreamSupplier = () -> useCase.getPetriNet().getArcsOfTransition(transition.getStringId()).stream();
        arcStreamSupplier.get().filter(arc -> useCase.getConsumedTokens().containsKey(arc.getStringId())).forEach(arc -> useCase.getConsumedTokens().remove(arc.getStringId()));
        this.workflowService.save(useCase);
    }

    public void startExecution(Transition transition, Case useCase) throws TransitionNotExecutableException {
        log.info("[" + useCase.getStringId() + "]: Start execution of " + transition.getTitle() + " in case " + useCase.getTitle());
        this.execute(transition, useCase, arc -> arc.getDestination().equals(transition));
    }

    protected void execute(Transition transition, Case useCase, Predicate<Arc> predicate) throws TransitionNotExecutableException {
        Supplier<Stream> filteredSupplier = () -> useCase.getPetriNet().getArcsOfTransition(transition.getStringId()).stream().filter(predicate);
        if (!filteredSupplier.get().allMatch(Arc::isExecutable)) {
            throw new TransitionNotExecutableException("Not all arcs can be executed task [" + transition.getStringId() + "] in case [" + useCase.getTitle() + "]");
        }
        filteredSupplier.get().sorted((o1, o2) -> ArcOrderComparator.getInstance().compare((Arc)o1, (Arc)o2)).forEach(arc -> {
            if (arc instanceof ResetArc) {
                useCase.getConsumedTokens().put(arc.getStringId(), ((Place)arc.getSource()).getTokens());
            }
            if (arc.getReference() != null && arc.getSource() instanceof Place) {
                useCase.getConsumedTokens().put(arc.getStringId(), arc.getReference().getMultiplicity());
            }
            arc.execute();
        });
        this.workflowService.updateMarking(useCase);
    }

    protected List<EventOutcome> executeTransition(Task task, Case useCase) {
        log.info("[" + useCase.getStringId() + "]: executeTransition [" + task.getTransitionId() + "] in case [" + useCase.getTitle() + "]");
        ArrayList<EventOutcome> outcomes = new ArrayList<EventOutcome>();
        try {
            log.info("assignTask [" + task.getTitle() + "] in case [" + useCase.getTitle() + "]");
            outcomes.add(this.assignTask(task.getStringId()));
            log.info("getData [" + task.getTitle() + "] in case [" + useCase.getTitle() + "]");
            outcomes.add(this.dataService.getData(task.getStringId()));
            log.info("finishTask [" + task.getTitle() + "] in case [" + useCase.getTitle() + "]");
            outcomes.add(this.finishTask(task.getStringId()));
        }
        catch (TransitionNotExecutableException e) {
            log.error("execution of task [" + task.getTitle() + "] in case [" + useCase.getTitle() + "] failed: ", (Throwable)e);
        }
        return outcomes;
    }

    void validateData(Transition transition, Case useCase) {
        for (Map.Entry<String, DataFieldLogic> entry : transition.getDataSet().entrySet()) {
            if (useCase.getPetriNet().getDataSet().get(entry.getKey()) != null && useCase.getPetriNet().getDataSet().get(entry.getKey()).getValidations() != null) {
                this.validation.valid(useCase.getPetriNet().getDataSet().get(entry.getKey()), useCase.getDataField(entry.getKey()));
            }
            if (!useCase.getDataField(entry.getKey()).isRequired(transition.getImportId()) || useCase.getDataField(entry.getKey()).isUndefined(transition.getImportId()) && !entry.getValue().isRequired()) continue;
            Object value = useCase.getDataSet().get(entry.getKey()).getValue();
            if (value == null) {
                Field field = useCase.getField(entry.getKey());
                throw new IllegalArgumentException("Field \"" + field.getName() + "\" has null value");
            }
            if (!(value instanceof String) || !((String)value).isEmpty()) continue;
            Field field = useCase.getField(entry.getKey());
            throw new IllegalArgumentException("Field \"" + field.getName() + "\" has empty value");
        }
    }

    protected void scheduleTaskExecution(Task task, LocalDateTime time, Case useCase) {
        log.info("[" + useCase.getStringId() + "]: Task " + task.getTitle() + " scheduled to run at " + time.toString());
        this.scheduler.schedule(() -> {
            try {
                this.executeTransition(task, useCase);
            }
            catch (Exception e) {
                log.info("[" + useCase.getStringId() + "]: Scheduled task [" + task.getTitle() + "] of case [" + useCase.getTitle() + "] could not be executed: " + e);
            }
        }, DateUtils.localDateTimeToDate(time));
    }

    @Override
    public Task findOne(String taskId) {
        Optional optionalTask = this.taskRepository.findById(taskId);
        if (optionalTask.isEmpty()) {
            throw new IllegalArgumentException("Could not find task with id [" + taskId + "]");
        }
        return (Task)optionalTask.get();
    }

    @Override
    public Page<Task> getAll(LoggedUser loggedUser, Pageable pageable, Locale locale) {
        LoggedUser loggedOrImpersonated = loggedUser.getSelfOrImpersonated();
        if (loggedOrImpersonated.getProcessRoles().isEmpty()) {
            ArrayList tasks = new ArrayList();
            return new PageImpl(tasks, pageable, 0L);
        }
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("{$or:[");
        loggedOrImpersonated.getProcessRoles().forEach(role -> {
            queryBuilder.append("{\"roles.");
            queryBuilder.append((String)role);
            queryBuilder.append("\":{$exists:true}},");
        });
        if (!loggedOrImpersonated.getProcessRoles().isEmpty()) {
            queryBuilder.deleteCharAt(queryBuilder.length() - 1);
        } else {
            queryBuilder.append("{}");
        }
        queryBuilder.append("]}");
        BasicQuery query = new BasicQuery(queryBuilder.toString());
        query = (BasicQuery)query.with(pageable);
        List tasks = this.mongoTemplate.find((Query)query, Task.class);
        return this.loadUsers((Page<Task>)new PageImpl(tasks, pageable, this.mongoTemplate.count((Query)new BasicQuery(queryBuilder.toString(), "{_id:1}"), Task.class)));
    }

    @Override
    public Page<Task> search(List<TaskSearchRequest> requests, Pageable pageable, LoggedUser user, Locale locale, Boolean isIntersection) {
        com.querydsl.core.types.Predicate searchPredicate = this.searchService.buildQuery(requests, user, locale, isIntersection);
        if (searchPredicate != null) {
            Page<Task> page = this.taskRepository.findAll(searchPredicate, pageable);
            page = this.loadUsers(page);
            page = this.dataService.setImmediateFields(page);
            return page;
        }
        return Page.empty();
    }

    @Override
    public long count(List<TaskSearchRequest> requests, LoggedUser user, Locale locale, Boolean isIntersection) {
        com.querydsl.core.types.Predicate searchPredicate = this.searchService.buildQuery(requests, user, locale, isIntersection);
        if (searchPredicate != null) {
            return this.taskRepository.count(searchPredicate);
        }
        return 0L;
    }

    @Override
    public Page<Task> findByCases(Pageable pageable, List<String> cases) {
        return this.loadUsers(this.taskRepository.findByCaseIdIn(pageable, cases));
    }

    @Override
    public Task findById(String id) {
        Optional taskOptional = this.taskRepository.findById(id);
        if (taskOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find task with id [" + id + "]");
        }
        Task task = (Task)taskOptional.get();
        this.setUser(task);
        return task;
    }

    @Override
    public List<Task> findAllById(List<String> ids) {
        return this.taskRepository.findAllBy_idIn(ids).stream().filter(Objects::nonNull).sorted((Comparator<Task>)Ordering.explicit(ids).onResultOf(Task::getStringId)).peek(this::setUser).collect(Collectors.toList());
    }

    @Override
    public Page<Task> findByUser(Pageable pageable, IUser user) {
        return this.loadUsers(this.taskRepository.findByUserId(pageable, user.getSelfOrImpersonated().getStringId()));
    }

    @Override
    public Page<Task> findByTransitions(Pageable pageable, List<String> transitions) {
        return this.loadUsers(this.taskRepository.findByTransitionIdIn(pageable, transitions));
    }

    @Override
    public Page<Task> searchAll(com.querydsl.core.types.Predicate predicate) {
        Page tasks = this.taskRepository.findAll(predicate, (Pageable)new FullPageRequest());
        return this.loadUsers((Page<Task>)tasks);
    }

    @Override
    public Page<Task> search(com.querydsl.core.types.Predicate predicate, Pageable pageable) {
        Page tasks = this.taskRepository.findAll(predicate, pageable);
        return this.loadUsers((Page<Task>)tasks);
    }

    @Override
    public Task searchOne(com.querydsl.core.types.Predicate predicate) {
        Page tasks = this.taskRepository.findAll(predicate, (Pageable)PageRequest.of((int)0, (int)1));
        if (tasks.getTotalElements() > 0L) {
            return (Task)tasks.getContent().get(0);
        }
        return null;
    }

    @Override
    public List<TaskReference> findAllByCase(String caseId, Locale locale) {
        return this.taskRepository.findAllByCaseId(caseId).stream().map(task -> new TaskReference(task.getStringId(), task.getTitle().getTranslation(locale), task.getTransitionId())).collect(Collectors.toList());
    }

    @Override
    public List<Task> findAllByCase(String caseId) {
        return this.taskRepository.findAllByCaseId(caseId);
    }

    @Override
    public Task save(Task task) {
        task = (Task)this.taskRepository.save(task);
        this.elasticTaskService.index(this.taskMappingService.transform(task));
        return task;
    }

    @Override
    public List<Task> save(List<Task> tasks) {
        tasks = this.taskRepository.saveAll(tasks);
        tasks.forEach(task -> this.elasticTaskService.index(this.taskMappingService.transform((Task)task)));
        return tasks;
    }

    @Override
    public void resolveUserRef(Case useCase) {
        useCase.getTasks().forEach(taskPair -> {
            Optional taskOptional = this.taskRepository.findById(taskPair.getTask());
            taskOptional.ifPresent(task -> this.resolveUserRef((Task)task, useCase));
        });
    }

    @Override
    public Task resolveUserRef(Task task, Case useCase) {
        task.getUsers().clear();
        task.getNegativeViewUsers().clear();
        task.getUserRefs().forEach((id, permission) -> {
            List<String> userIds = this.getExistingUsers((UserListFieldValue)useCase.getDataSet().get(id).getValue());
            if (userIds != null && userIds.size() != 0 && permission.containsKey("view") && !((Boolean)permission.get("view")).booleanValue()) {
                task.getNegativeViewUsers().addAll(userIds);
            } else if (userIds != null && userIds.size() != 0) {
                task.addUsers((Set<String>)new HashSet<String>(userIds), (Map<String, Boolean>)permission);
            }
        });
        task.resolveViewUsers();
        return (Task)this.taskRepository.save(task);
    }

    private List<String> getExistingUsers(UserListFieldValue userListValue) {
        if (userListValue == null) {
            return null;
        }
        return userListValue.getUserValues().stream().map(UserFieldValue::getId).filter(id -> this.userService.resolveById((String)id, false) != null).collect(Collectors.toList());
    }

    private Task createFromTransition(Transition transition, Case useCase) {
        Task task = Task.with().title(transition.getTitle()).processId(useCase.getPetriNetId()).caseId(useCase.get_id().toString()).transitionId(transition.getImportId()).layout(transition.getLayout()).tags(transition.getTags()).caseColor(useCase.getColor()).caseTitle(useCase.getTitle()).priority(transition.getPriority()).icon(transition.getIcon() == null ? useCase.getIcon() : transition.getIcon()).immediateDataFields(new LinkedHashSet<String>(transition.getImmediateData())).assignPolicy(transition.getAssignPolicy()).dataFocusPolicy(transition.getDataFocusPolicy()).finishPolicy(transition.getFinishPolicy()).build();
        transition.getEvents().forEach((type, event) -> task.addEventTitle((EventType)((Object)type), event.getTitle()));
        task.addAssignedUserPolicy(transition.getAssignedUserPolicy());
        for (Trigger trigger : transition.getTriggers()) {
            Iterator<Map.Entry<String, Map<String, Boolean>>> taskTrigger = trigger.clone();
            task.addTrigger((Trigger)((Object)taskTrigger));
            if (!(taskTrigger instanceof TimeTrigger)) continue;
            TimeTrigger timeTrigger = (TimeTrigger)((Object)taskTrigger);
            this.scheduleTaskExecution(task, timeTrigger.getStartDate(), useCase);
        }
        ProcessRole defaultRole = this.processRoleService.defaultRole();
        ProcessRole anonymousRole = this.processRoleService.anonymousRole();
        for (Map.Entry<String, Map<String, Boolean>> entry : transition.getRoles().entrySet()) {
            if (!useCase.getEnabledRoles().contains(entry.getKey()) && !defaultRole.getStringId().equals(entry.getKey()) && !anonymousRole.getStringId().equals(entry.getKey())) continue;
            task.addRole((String)entry.getKey(), (Map)entry.getValue());
        }
        transition.getNegativeViewRoles().forEach(task::addNegativeViewRole);
        for (Map.Entry<String, Map<String, Boolean>> entry : transition.getUserRefs().entrySet()) {
            task.addUserRef(entry.getKey(), entry.getValue());
        }
        task.resolveViewRoles();
        task.resolveViewUserRefs();
        Transaction transaction = useCase.getPetriNet().getTransactionByTransition(transition);
        if (transaction != null) {
            task.setTransactionId(transaction.getStringId());
        }
        useCase.addTask(task);
        return task;
    }

    private Page<Task> loadUsers(Page<Task> tasks) {
        HashMap users = new HashMap();
        tasks.forEach(task -> {
            if (task.getUserId() != null) {
                if (users.containsKey(task.getUserId())) {
                    task.setUser((IUser)users.get(task.getUserId()));
                } else {
                    task.setUser(this.userService.resolveById(task.getUserId(), true));
                    users.put(task.getUserId(), task.getUser());
                }
            }
        });
        return tasks;
    }

    @Override
    public void delete(List<Task> tasks, Case useCase) {
        this.workflowService.removeTasksFromCase(tasks, useCase);
        log.info("[" + useCase.getStringId() + "]: Tasks of case " + useCase.getTitle() + " are being deleted");
        this.taskRepository.deleteAll(tasks);
        tasks.forEach(t -> this.elasticTaskService.remove(t.getStringId()));
    }

    @Override
    public void delete(List<Task> tasks, String caseId) {
        this.workflowService.removeTasksFromCase(tasks, caseId);
        log.info("[" + caseId + "]: Tasks of case are being deleted");
        this.taskRepository.deleteAll(tasks);
        tasks.forEach(t -> this.elasticTaskService.remove(t.getStringId()));
    }

    @Override
    public void deleteTasksByCase(String caseId) {
        this.delete(this.taskRepository.findAllByCaseId(caseId), caseId);
    }

    @Override
    public void deleteTasksByPetriNetId(String petriNetId) {
        this.taskRepository.deleteAllByProcessId(petriNetId);
    }

    private void setUser(Task task) {
        if (task.getUserId() != null) {
            task.setUser(this.userService.resolveById(task.getUserId(), true));
        }
    }

    private EventOutcome addMessageToOutcome(Transition transition, EventType type, TaskEventOutcome outcome) {
        if (transition.getEvents().containsKey((Object)type)) {
            outcome.setMessage(transition.getEvents().get((Object)type).getMessage());
        }
        return outcome;
    }

    @Override
    public SetDataEventOutcome getMainOutcome(Map<String, SetDataEventOutcome> outcomes, String taskId) {
        Optional optional;
        String key = taskId;
        if (!outcomes.containsKey(taskId) && (optional = outcomes.keySet().stream().findFirst()).isPresent()) {
            key = (String)optional.get();
        }
        SetDataEventOutcome mainOutcome = outcomes.remove(key);
        mainOutcome.addOutcomes(new ArrayList<EventOutcome>(outcomes.values()));
        return mainOutcome;
    }

    protected IUser getUserFromLoggedUser(LoggedUser loggedUser) {
        IUser user = this.userService.resolveById(loggedUser.getId(), true);
        IUser fromLogged = loggedUser.transformToUser();
        user.setImpersonated(fromLogged.getImpersonated());
        return user;
    }
}

