/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRolePermission;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.service.AbstractAuthorizationService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowAuthorizationService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowAuthorizationService
extends AbstractAuthorizationService
implements IWorkflowAuthorizationService {
    @Autowired
    private IWorkflowService workflowService;
    @Autowired
    private IPetriNetService petriNetService;

    @Override
    public boolean canCallDelete(LoggedUser user, String caseId) {
        Case requestedCase = this.workflowService.findOne(caseId);
        Boolean rolePerm = this.userHasAtLeastOneRolePermission(user.getSelfOrImpersonated().transformToUser(), requestedCase.getPetriNet(), ProcessRolePermission.DELETE);
        Boolean userPerm = this.userHasUserListPermission(user.transformToUser(), requestedCase, ProcessRolePermission.DELETE);
        return user.getSelfOrImpersonated().isAdmin() || (userPerm == null ? rolePerm != null && rolePerm != false : userPerm != false);
    }

    @Override
    public boolean canCallCreate(LoggedUser user, String netId) {
        PetriNet net = this.petriNetService.getPetriNet(netId);
        return user.getSelfOrImpersonated().isAdmin() || this.userHasAtLeastOneRolePermission(user.transformToUser(), net, ProcessRolePermission.CREATE) != false;
    }

    @Override
    public Boolean userHasAtLeastOneRolePermission(IUser user, PetriNet net, ProcessRolePermission ... permissions) {
        Map<String, Boolean> aggregatePermissions = this.getAggregatePermissions(user, net.getPermissions());
        for (ProcessRolePermission permission2 : permissions) {
            if (!this.hasRestrictedPermission(aggregatePermissions.get(permission2.toString()))) continue;
            return false;
        }
        return Arrays.stream(permissions).anyMatch(permission -> this.hasPermission((Boolean)aggregatePermissions.get(permission.toString())));
    }

    @Override
    public Boolean userHasUserListPermission(IUser user, Case useCase, ProcessRolePermission ... permissions) {
        if (useCase.getUserRefs() == null || useCase.getUserRefs().isEmpty()) {
            return null;
        }
        if (!useCase.getUsers().containsKey(user.getSelfOrImpersonated().getStringId())) {
            return null;
        }
        Map<String, Boolean> userPermissions = useCase.getUsers().get(user.getSelfOrImpersonated().getStringId());
        for (ProcessRolePermission permission2 : permissions) {
            Boolean perm = userPermissions.get(permission2.toString());
            if (!this.hasRestrictedPermission(perm)) continue;
            return false;
        }
        return Arrays.stream(permissions).anyMatch(permission -> this.hasPermission((Boolean)userPermissions.get(permission.toString())));
    }
}

