/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.service;

import com.google.common.collect.Ordering;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseMappingService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.history.domain.caseevents.CreateCaseEventLog;
import com.netgrif.application.engine.history.domain.caseevents.DeleteCaseEventLog;
import com.netgrif.application.engine.history.service.IHistoryService;
import com.netgrif.application.engine.importer.service.FieldFactory;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.TaskField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.FieldActionsRunner;
import com.netgrif.application.engine.petrinet.domain.events.CaseEventType;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.rules.domain.facts.CaseCreatedFact;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEngine;
import com.netgrif.application.engine.security.service.EncryptionService;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.DataField;
import com.netgrif.application.engine.workflow.domain.QCase;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.TaskPair;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.EventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.caseoutcomes.CreateCaseEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.caseoutcomes.DeleteCaseEventOutcome;
import com.netgrif.application.engine.workflow.domain.repositories.CaseRepository;
import com.netgrif.application.engine.workflow.service.CaseSearchService;
import com.netgrif.application.engine.workflow.service.interfaces.IEventService;
import com.netgrif.application.engine.workflow.service.interfaces.IInitValueExpressionEvaluator;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.querydsl.core.types.Predicate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class WorkflowService
implements IWorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowService.class);
    @Autowired
    protected CaseRepository repository;
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    protected IPetriNetService petriNetService;
    @Autowired
    protected IProcessRoleService processRoleService;
    @Autowired
    protected ITaskService taskService;
    @Autowired
    protected CaseSearchService searchService;
    @Autowired
    protected ApplicationEventPublisher publisher;
    @Autowired
    protected EncryptionService encryptionService;
    @Autowired
    protected FieldFactory fieldFactory;
    @Autowired
    protected IRuleEngine ruleEngine;
    @Autowired
    protected FieldActionsRunner actionsRunner;
    @Autowired
    protected IUserService userService;
    @Autowired
    protected IInitValueExpressionEvaluator initValueExpressionEvaluator;
    @Autowired
    protected IElasticCaseMappingService caseMappingService;
    @Lazy
    @Autowired
    private IEventService eventService;
    @Autowired
    private IHistoryService historyService;
    protected IElasticCaseService elasticCaseService;

    @Autowired
    public void setElasticCaseService(IElasticCaseService elasticCaseService) {
        this.elasticCaseService = elasticCaseService;
    }

    @Override
    public Case save(Case useCase) {
        if (useCase.getPetriNet() == null) {
            this.setPetriNet(useCase);
        }
        this.encryptDataSet(useCase);
        useCase = (Case)this.repository.save(useCase);
        try {
            this.setImmediateDataFields(useCase);
            this.elasticCaseService.indexNow(this.caseMappingService.transform(useCase));
        }
        catch (Exception e) {
            log.error("Indexing failed [" + useCase.getStringId() + "]", (Throwable)e);
        }
        return useCase;
    }

    @Override
    public Case findOne(String caseId) {
        Case useCase = this.findOneNoNet(caseId);
        this.setPetriNet(useCase);
        this.decryptDataSet(useCase);
        this.setImmediateDataFieldsReadOnly(useCase);
        return useCase;
    }

    @Override
    public Case findOneNoNet(String caseId) {
        Optional caseOptional = this.repository.findById(caseId);
        if (caseOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find Case with id [" + caseId + "]");
        }
        Case useCase = (Case)caseOptional.get();
        return useCase;
    }

    @Override
    public List<Case> findAllById(List<String> ids) {
        return this.repository.findAllBy_idIn(ids).stream().filter(Objects::nonNull).sorted((Comparator<Case>)Ordering.explicit(ids).onResultOf(Case::getStringId)).map(caze -> {
            caze.setPetriNet(this.petriNetService.get(caze.getPetriNetObjectId()));
            this.decryptDataSet((Case)caze);
            this.setImmediateDataFieldsReadOnly((Case)caze);
            return caze;
        }).collect(Collectors.toList());
    }

    @Override
    public Page<Case> getAll(Pageable pageable) {
        Page page = this.repository.findAll(pageable);
        page.getContent().forEach(this::setPetriNet);
        this.decryptDataSets(page.getContent());
        return this.setImmediateDataFields((Page<Case>)page);
    }

    @Override
    public Page<Case> findAllByUri(String uri, Pageable pageable) {
        Page<Case> page = this.repository.findAllByUriNodeId(uri, pageable);
        page.getContent().forEach(this::setPetriNet);
        this.decryptDataSets(page.getContent());
        return this.setImmediateDataFields(page);
    }

    @Override
    public Page<Case> search(Predicate predicate, Pageable pageable) {
        Page page = this.repository.findAll(predicate, pageable);
        page.getContent().forEach(this::setPetriNet);
        return this.setImmediateDataFields((Page<Case>)page);
    }

    @Override
    public Page<Case> search(Map<String, Object> request, Pageable pageable, LoggedUser user, Locale locale) {
        Predicate searchPredicate = this.searchService.buildQuery(request, user, locale);
        Page page = searchPredicate != null ? this.repository.findAll(searchPredicate, pageable) : Page.empty();
        page.getContent().forEach(this::setPetriNet);
        this.decryptDataSets(page.getContent());
        return this.setImmediateDataFields((Page<Case>)page);
    }

    @Override
    public long count(Map<String, Object> request, LoggedUser user, Locale locale) {
        Predicate searchPredicate = this.searchService.buildQuery(request, user, locale);
        if (searchPredicate != null) {
            return this.repository.count(searchPredicate);
        }
        return 0L;
    }

    @Override
    public Case resolveUserRef(Case useCase) {
        useCase.getUsers().clear();
        useCase.getNegativeViewUsers().clear();
        useCase.getUserRefs().forEach((id, permission) -> this.resolveUserRefPermissions(useCase, (String)id, (Map<String, Boolean>)permission));
        useCase.resolveViewUsers();
        this.taskService.resolveUserRef(useCase);
        return this.save(useCase);
    }

    private void resolveUserRefPermissions(Case useCase, String userListId, Map<String, Boolean> permission) {
        List<String> userIds = this.getExistingUsers((UserListFieldValue)useCase.getDataSet().get(userListId).getValue());
        if (userIds != null && userIds.size() != 0) {
            if (permission.containsKey("view") && !permission.get("view").booleanValue()) {
                useCase.getNegativeViewUsers().addAll(userIds);
            } else {
                useCase.addUsers(new HashSet<String>(userIds), permission);
            }
        }
    }

    private List<String> getExistingUsers(UserListFieldValue userListValue) {
        if (userListValue == null) {
            return null;
        }
        return userListValue.getUserValues().stream().map(UserFieldValue::getId).filter(id -> this.userService.resolveById((String)id, false) != null).collect(Collectors.toList());
    }

    @Override
    public CreateCaseEventOutcome createCase(String netId, String title, String color, LoggedUser user, Locale locale, Map<String, String> params) {
        if (locale == null) {
            locale = LocaleContextHolder.getLocale();
        }
        if (title == null) {
            return this.createCase(netId, this.resolveDefaultCaseTitle(netId, locale, params), color, user, params);
        }
        return this.createCase(netId, title, color, user, params);
    }

    @Override
    public CreateCaseEventOutcome createCase(String netId, String title, String color, LoggedUser user, Locale locale) {
        return this.createCase(netId, title, color, user, locale, new HashMap<String, String>());
    }

    @Override
    public CreateCaseEventOutcome createCase(String netId, String title, String color, LoggedUser user, Map<String, String> params) {
        return this.createCase(netId, (Case u) -> title, color, user, params);
    }

    @Override
    public CreateCaseEventOutcome createCase(String netId, String title, String color, LoggedUser user) {
        return this.createCase(netId, (Case u) -> title, color, user);
    }

    @Override
    public CreateCaseEventOutcome createCaseByIdentifier(String identifier, String title, String color, LoggedUser user, Locale locale, Map<String, String> params) {
        PetriNet net = this.petriNetService.getNewestVersionByIdentifier(identifier);
        if (net == null) {
            throw new IllegalArgumentException("Petri net with identifier [" + identifier + "] does not exist.");
        }
        return this.createCase(net.getStringId(), title != null && !title.equals("") ? title : net.getDefaultCaseName().getTranslation(locale), color, user, params);
    }

    @Override
    public CreateCaseEventOutcome createCaseByIdentifier(String identifier, String title, String color, LoggedUser user, Locale locale) {
        return this.createCaseByIdentifier(identifier, title, color, user, locale, new HashMap<String, String>());
    }

    @Override
    public CreateCaseEventOutcome createCaseByIdentifier(String identifier, String title, String color, LoggedUser user, Map<String, String> params) {
        PetriNet net = this.petriNetService.getNewestVersionByIdentifier(identifier);
        if (net == null) {
            throw new IllegalArgumentException("Petri net with identifier [" + identifier + "] does not exist.");
        }
        return this.createCase(net.getStringId(), title, color, user, params);
    }

    @Override
    public CreateCaseEventOutcome createCaseByIdentifier(String identifier, String title, String color, LoggedUser user) {
        PetriNet net = this.petriNetService.getNewestVersionByIdentifier(identifier);
        if (net == null) {
            throw new IllegalArgumentException("Petri net with identifier [" + identifier + "] does not exist.");
        }
        return this.createCase(net.getStringId(), title, color, user);
    }

    public CreateCaseEventOutcome createCase(String netId, Function<Case, String> makeTitle, String color, LoggedUser user) {
        return this.createCase(netId, makeTitle, color, user, new HashMap<String, String>());
    }

    public CreateCaseEventOutcome createCase(String netId, Function<Case, String> makeTitle, String color, LoggedUser user, Map<String, String> params) {
        LoggedUser loggedOrImpersonated = user.getSelfOrImpersonated();
        PetriNet petriNet = this.petriNetService.clone(new ObjectId(netId));
        Case useCase = new Case(petriNet);
        useCase.populateDataSet(this.initValueExpressionEvaluator, params);
        useCase.setColor(color);
        useCase.setAuthor(loggedOrImpersonated.transformToAuthor());
        useCase.setCreationDate(LocalDateTime.now());
        useCase.setTitle(makeTitle.apply(useCase));
        useCase.setUriNodeId(petriNet.getUriNodeId());
        CreateCaseEventOutcome outcome = new CreateCaseEventOutcome();
        outcome.addOutcomes(this.eventService.runActions(petriNet.getPreCreateActions(), null, Optional.empty(), params));
        int rulesExecuted = this.ruleEngine.evaluateRules(useCase, new CaseCreatedFact(useCase.getStringId(), EventPhase.PRE));
        if (rulesExecuted > 0) {
            useCase = this.save(useCase);
        }
        this.historyService.save(new CreateCaseEventLog(useCase, EventPhase.PRE));
        log.info("[" + useCase.getStringId() + "]: Case " + useCase.getTitle() + " created");
        useCase.getPetriNet().initializeArcs(useCase.getDataSet());
        this.taskService.reloadTasks(useCase);
        useCase = this.findOne(useCase.getStringId());
        this.resolveTaskRefs(useCase);
        useCase = this.findOne(useCase.getStringId());
        outcome.addOutcomes(this.eventService.runActions(petriNet.getPostCreateActions(), useCase, Optional.empty(), params));
        useCase = this.findOne(useCase.getStringId());
        rulesExecuted = this.ruleEngine.evaluateRules(useCase, new CaseCreatedFact(useCase.getStringId(), EventPhase.POST));
        if (rulesExecuted > 0) {
            useCase = this.save(useCase);
        }
        this.historyService.save(new CreateCaseEventLog(useCase, EventPhase.POST));
        outcome.setCase(this.setImmediateDataFields(useCase));
        this.addMessageToOutcome(petriNet, CaseEventType.CREATE, outcome);
        return outcome;
    }

    protected Function<Case, String> resolveDefaultCaseTitle(String netId, Locale locale, Map<String, String> params) {
        PetriNet petriNet = this.petriNetService.clone(new ObjectId(netId));
        Function<Case, String> makeTitle = petriNet.hasDynamicCaseName() ? u -> this.initValueExpressionEvaluator.evaluateCaseName((Case)u, petriNet.getDefaultCaseNameExpression(), params).getTranslation(locale) : u -> petriNet.getDefaultCaseName().getTranslation(locale);
        return makeTitle;
    }

    @Override
    public Page<Case> findAllByAuthor(String authorId, String petriNet, Pageable pageable) {
        String queryString = "{author.id:" + authorId + ", petriNet:{$ref:\"petriNet\",$id:{$oid:\"" + petriNet + "\"}}}";
        BasicQuery query = new BasicQuery(queryString);
        query = (BasicQuery)query.with(pageable);
        List cases = this.mongoTemplate.find((Query)query, Case.class);
        this.decryptDataSets(cases);
        return this.setImmediateDataFields((Page<Case>)new PageImpl(cases, pageable, this.mongoTemplate.count((Query)new BasicQuery(queryString, "{_id:1}"), Case.class)));
    }

    @Override
    public DeleteCaseEventOutcome deleteCase(String caseId, Map<String, String> params) {
        Case useCase = this.findOne(caseId);
        return this.deleteCase(useCase, params);
    }

    @Override
    public DeleteCaseEventOutcome deleteCase(String caseId) {
        return this.deleteCase(caseId, new HashMap<String, String>());
    }

    @Override
    public DeleteCaseEventOutcome deleteCase(Case useCase, Map<String, String> params) {
        DeleteCaseEventOutcome outcome = new DeleteCaseEventOutcome(useCase, this.eventService.runActions(useCase.getPetriNet().getPreDeleteActions(), useCase, Optional.empty(), params));
        this.historyService.save(new DeleteCaseEventLog(useCase, EventPhase.PRE));
        log.info("[" + useCase.getStringId() + "]: User [" + this.userService.getLoggedOrSystem().getStringId() + "] is deleting case " + useCase.getTitle());
        this.taskService.deleteTasksByCase(useCase.getStringId());
        this.repository.delete(useCase);
        outcome.addOutcomes(this.eventService.runActions(useCase.getPetriNet().getPostDeleteActions(), null, Optional.empty(), params));
        this.addMessageToOutcome(useCase.getPetriNet(), CaseEventType.DELETE, outcome);
        this.historyService.save(new DeleteCaseEventLog(useCase, EventPhase.POST));
        return outcome;
    }

    @Override
    public DeleteCaseEventOutcome deleteCase(Case useCase) {
        return this.deleteCase(useCase, new HashMap<String, String>());
    }

    @Override
    public void deleteInstancesOfPetriNet(PetriNet net) {
        log.info("[" + net.getStringId() + "]: User " + this.userService.getLoggedOrSystem().getStringId() + " is deleting all cases and tasks of Petri net " + net.getIdentifier() + " version " + net.getVersion().toString());
        List cases = this.searchAll((Predicate)QCase.case$.petriNetObjectId.eq(net.getObjectId())).getContent();
        if (!cases.isEmpty()) {
            cases.forEach(this::deleteCase);
        }
    }

    @Override
    public DeleteCaseEventOutcome deleteSubtreeRootedAt(String subtreeRootCaseId) {
        Case subtreeRoot = this.findOne(subtreeRootCaseId);
        if (subtreeRoot.getImmediateDataFields().contains("treeChildCases")) {
            ((List)subtreeRoot.getDataSet().get("treeChildCases").getValue()).forEach(this::deleteSubtreeRootedAt);
        }
        return this.deleteCase(subtreeRootCaseId);
    }

    @Override
    public void updateMarking(Case useCase) {
        PetriNet net = useCase.getPetriNet();
        useCase.setActivePlaces(net.getActivePlaces());
    }

    @Override
    public boolean removeTasksFromCase(List<Task> tasks, String caseId) {
        if (tasks.isEmpty()) {
            return true;
        }
        Optional caseOptional = this.repository.findById(caseId);
        if (caseOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find case with id [" + caseId + "]");
        }
        Case useCase = (Case)caseOptional.get();
        return this.removeTasksFromCase(tasks, useCase);
    }

    @Override
    public boolean removeTasksFromCase(List<Task> tasks, Case useCase) {
        if (tasks.isEmpty()) {
            return true;
        }
        return useCase.removeTasks(tasks);
    }

    @Override
    public Case decrypt(Case useCase) {
        this.decryptDataSet(useCase);
        return useCase;
    }

    @Override
    public Page<Case> searchAll(Predicate predicate) {
        return this.search(predicate, (Pageable)new FullPageRequest());
    }

    @Override
    public Case searchOne(Predicate predicate) {
        Page<Case> page = this.search(predicate, (Pageable)PageRequest.of((int)0, (int)1));
        if (page.getContent().isEmpty()) {
            return null;
        }
        return (Case)page.getContent().get(0);
    }

    @Override
    public Map<String, I18nString> listToMap(List<Case> cases) {
        HashMap<String, I18nString> options = new HashMap<String, I18nString>();
        cases.forEach(aCase -> options.put(aCase.getStringId(), new I18nString(aCase.getTitle())));
        return options;
    }

    private void resolveTaskRefs(Case useCase) {
        useCase.getPetriNet().getDataSet().values().stream().filter(f -> f instanceof TaskField).map(TaskField.class::cast).forEach(field -> {
            if (field.getDefaultValue() != null && !((List)field.getDefaultValue()).isEmpty() && useCase.getDataField(field.getStringId()).getValue() != null && useCase.getDataField(field.getStringId()).getValue().equals(field.getDefaultValue())) {
                useCase.getDataField(field.getStringId()).setValue(new ArrayList());
                List<TaskPair> taskPairList = useCase.getTasks().stream().filter(t -> ((List)field.getDefaultValue()).contains(t.getTransition())).collect(Collectors.toList());
                if (!taskPairList.isEmpty()) {
                    taskPairList.forEach(pair -> ((List)useCase.getDataField(field.getStringId()).getValue()).add(pair.getTask()));
                }
            }
        });
        this.save(useCase);
    }

    @Override
    @Deprecated
    public List<Field> getData(String caseId) {
        Optional optionalUseCase = this.repository.findById(caseId);
        if (!optionalUseCase.isPresent()) {
            throw new IllegalArgumentException("Could not find case with id [" + caseId + "]");
        }
        Case useCase = (Case)optionalUseCase.get();
        ArrayList<Field> fields = new ArrayList<Field>();
        useCase.getDataSet().forEach((id, dataField) -> {
            if (dataField.isDisplayable() || useCase.getPetriNet().isDisplayableInAnyTransition((String)id)) {
                Field field = this.fieldFactory.buildFieldWithoutValidation(useCase, (String)id, null);
                field.setBehavior(dataField.applyOnlyVisibleBehavior());
                fields.add(field);
            }
        });
        LongStream.range(0L, fields.size()).forEach(l -> ((Field)fields.get((int)l)).setOrder(l));
        return fields;
    }

    private void setImmediateDataFieldsReadOnly(Case useCase) {
        ArrayList<Field> immediateData = new ArrayList<Field>();
        useCase.getImmediateDataFields().forEach(fieldId -> {
            try {
                Field clone = this.fieldFactory.buildImmediateField(useCase, (String)fieldId);
                immediateData.add(clone);
            }
            catch (Exception e) {
                log.error("Could not built immediate field [" + fieldId + "]");
            }
        });
        LongStream.range(0L, immediateData.size()).forEach(index -> ((Field)immediateData.get((int)index)).setOrder(index));
        useCase.setImmediateData(immediateData);
    }

    protected Page<Case> setImmediateDataFields(Page<Case> cases) {
        cases.getContent().forEach(this::setImmediateDataFields);
        return cases;
    }

    protected Case setImmediateDataFields(Case useCase) {
        ArrayList<Field> immediateData = new ArrayList<Field>();
        useCase.getImmediateDataFields().forEach(fieldId -> immediateData.add(this.fieldFactory.buildImmediateField(useCase, (String)fieldId)));
        LongStream.range(0L, immediateData.size()).forEach(index -> ((Field)immediateData.get((int)index)).setOrder(index));
        useCase.setImmediateData(immediateData);
        return useCase;
    }

    private void encryptDataSet(Case useCase) {
        this.applyCryptoMethodOnDataSet(useCase, entry -> this.encryptionService.encrypt((String)entry.getFirst(), (String)entry.getSecond()));
    }

    private void decryptDataSet(Case useCase) {
        this.applyCryptoMethodOnDataSet(useCase, entry -> this.encryptionService.decrypt((String)entry.getFirst(), (String)entry.getSecond()));
    }

    private void decryptDataSets(Collection<Case> cases) {
        for (Case aCase : cases) {
            this.decryptDataSet(aCase);
        }
    }

    private void applyCryptoMethodOnDataSet(Case useCase, Function<Pair<String, String>, String> method) {
        Map<DataField, String> dataFields = this.getEncryptedDataSet(useCase);
        for (Map.Entry<DataField, String> entry : dataFields.entrySet()) {
            DataField dataField = entry.getKey();
            String value = (String)dataField.getValue();
            String encryption = entry.getValue();
            if (value == null) continue;
            dataField.setValue(method.apply((Pair<String, String>)Pair.of((Object)value, (Object)encryption)));
        }
    }

    private Map<DataField, String> getEncryptedDataSet(Case useCase) {
        PetriNet net = useCase.getPetriNet();
        HashMap<DataField, String> encryptedDataSet = new HashMap<DataField, String>();
        for (Map.Entry<String, Field> entry : net.getDataSet().entrySet()) {
            String encryption = entry.getValue().getEncryption();
            if (encryption == null) continue;
            encryptedDataSet.put(useCase.getDataSet().get(entry.getKey()), encryption);
        }
        return encryptedDataSet;
    }

    private void setPetriNet(Case useCase) {
        PetriNet model = useCase.getPetriNet();
        if (model == null) {
            model = this.petriNetService.clone(useCase.getPetriNetObjectId());
            useCase.setPetriNet(model);
        }
        model.initializeTokens(useCase.getActivePlaces());
        model.initializeArcs(useCase.getDataSet());
    }

    private EventOutcome addMessageToOutcome(PetriNet net, CaseEventType type, EventOutcome outcome) {
        if (net.getCaseEvents().containsKey((Object)type)) {
            outcome.setMessage(net.getCaseEvents().get((Object)type).getMessage());
        }
        return outcome;
    }
}

