/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskService;
import com.netgrif.application.engine.elastic.web.requestbodies.singleaslist.SingleElasticTaskSearchRequestAsList;
import com.netgrif.application.engine.eventoutcomes.LocalisedEventOutcomeFactory;
import com.netgrif.application.engine.petrinet.domain.throwable.TransitionNotExecutableException;
import com.netgrif.application.engine.workflow.domain.IllegalArgumentWithChangedFieldsException;
import com.netgrif.application.engine.workflow.domain.MergeFilterOperation;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.GetDataGroupsEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.dataoutcomes.SetDataEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessage;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessageResource;
import com.netgrif.application.engine.workflow.service.FileFieldInputStream;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.web.PublicTaskController;
import com.netgrif.application.engine.workflow.web.TaskController;
import com.netgrif.application.engine.workflow.web.requestbodies.file.FileFieldRequest;
import com.netgrif.application.engine.workflow.web.requestbodies.singleaslist.SingleTaskSearchRequestAsList;
import com.netgrif.application.engine.workflow.web.responsebodies.CountResponse;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedTaskResource;
import com.netgrif.application.engine.workflow.web.responsebodies.ResourceLinkAssembler;
import com.netgrif.application.engine.workflow.web.responsebodies.Task;
import com.netgrif.application.engine.workflow.web.responsebodies.TaskReference;
import com.netgrif.application.engine.workflow.web.responsebodies.TaskResourceAssembler;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractTaskController {
    public static final Logger log = LoggerFactory.getLogger(TaskController.class);
    private final ITaskService taskService;
    private final IDataService dataService;
    private final IElasticTaskService searchService;

    public AbstractTaskController(ITaskService taskService, IDataService dataService, IElasticTaskService searchService) {
        this.taskService = taskService;
        this.dataService = dataService;
        this.searchService = searchService;
    }

    public PagedModel<LocalisedTaskResource> getAll(Authentication auth, Pageable pageable, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        LoggedUser loggedUser = (LoggedUser)((Object)auth.getPrincipal());
        Page<com.netgrif.application.engine.workflow.domain.Task> page = this.taskService.getAll(loggedUser, pageable, locale);
        Link selfLink = WebMvcLinkBuilder.linkTo(((TaskController)WebMvcLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).getAll(auth, pageable, assembler, locale)).withRel("all");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public PagedModel<LocalisedTaskResource> getAllByCases(List<String> cases, Pageable pageable, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        Page<com.netgrif.application.engine.workflow.domain.Task> page = this.taskService.findByCases(pageable, cases);
        Link selfLink = WebMvcLinkBuilder.linkTo(((TaskController)WebMvcLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).getAllByCases(cases, pageable, assembler, locale)).withRel("case");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public List<TaskReference> getTasksOfCase(String caseId, Locale locale) {
        return this.taskService.findAllByCase(caseId, locale);
    }

    public LocalisedTaskResource getOne(String taskId, Locale locale) {
        com.netgrif.application.engine.workflow.domain.Task task = this.taskService.findById(taskId);
        if (task == null) {
            return null;
        }
        return new LocalisedTaskResource(new Task(task, locale));
    }

    public EntityModel<EventOutcomeWithMessage> assign(LoggedUser loggedUser, String taskId, Locale locale) {
        try {
            return EventOutcomeWithMessageResource.successMessage("LocalisedTask " + taskId + " assigned to " + loggedUser.getFullName(), LocalisedEventOutcomeFactory.from(this.taskService.assignTask(loggedUser, taskId), locale));
        }
        catch (TransitionNotExecutableException e) {
            log.error("Assigning task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage("LocalisedTask " + taskId + " cannot be assigned");
        }
    }

    public EntityModel<EventOutcomeWithMessage> delegate(LoggedUser loggedUser, String taskId, String delegatedId, Locale locale) {
        try {
            return EventOutcomeWithMessageResource.successMessage("LocalisedTask " + taskId + " assigned to [" + delegatedId + "]", LocalisedEventOutcomeFactory.from(this.taskService.delegateTask(loggedUser, delegatedId, taskId), locale));
        }
        catch (Exception e) {
            log.error("Delegating task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage("LocalisedTask " + taskId + " cannot be assigned");
        }
    }

    public EntityModel<EventOutcomeWithMessage> finish(LoggedUser loggedUser, String taskId, Locale locale) {
        try {
            return EventOutcomeWithMessageResource.successMessage("LocalisedTask " + taskId + " finished", LocalisedEventOutcomeFactory.from(this.taskService.finishTask(loggedUser, taskId), locale));
        }
        catch (Exception e) {
            log.error("Finishing task [" + taskId + "] failed: ", (Throwable)e);
            if (e instanceof IllegalArgumentWithChangedFieldsException) {
                return EventOutcomeWithMessageResource.errorMessage(e.getMessage(), LocalisedEventOutcomeFactory.from(((IllegalArgumentWithChangedFieldsException)e).getOutcome(), locale));
            }
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage());
        }
    }

    public EntityModel<EventOutcomeWithMessage> cancel(LoggedUser loggedUser, String taskId, Locale locale) {
        try {
            return EventOutcomeWithMessageResource.successMessage("LocalisedTask " + taskId + " canceled", LocalisedEventOutcomeFactory.from(this.taskService.cancelTask(loggedUser, taskId), locale));
        }
        catch (Exception e) {
            log.error("Canceling task [" + taskId + "] failed: ", (Throwable)e);
            if (e instanceof IllegalArgumentWithChangedFieldsException) {
                return EventOutcomeWithMessageResource.errorMessage(e.getMessage(), LocalisedEventOutcomeFactory.from(((IllegalArgumentWithChangedFieldsException)e).getOutcome(), locale));
            }
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage());
        }
    }

    public PagedModel<LocalisedTaskResource> getMy(Authentication auth, Pageable pageable, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        Page<com.netgrif.application.engine.workflow.domain.Task> page = this.taskService.findByUser(pageable, ((LoggedUser)((Object)auth.getPrincipal())).transformToUser());
        Link selfLink = WebMvcLinkBuilder.linkTo(((TaskController)WebMvcLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).getMy(auth, pageable, assembler, locale)).withRel("my");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public PagedModel<LocalisedTaskResource> getMyFinished(Pageable pageable, Authentication auth, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        Page<com.netgrif.application.engine.workflow.domain.Task> page = this.taskService.findByUser(pageable, ((LoggedUser)((Object)auth.getPrincipal())).transformToUser());
        Link selfLink = WebMvcLinkBuilder.linkTo(((TaskController)WebMvcLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).getMyFinished(pageable, auth, assembler, locale)).withRel("finished");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public PagedModel<LocalisedTaskResource> search(Authentication auth, Pageable pageable, SingleTaskSearchRequestAsList searchBody, MergeFilterOperation operation, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        Page<com.netgrif.application.engine.workflow.domain.Task> tasks = this.taskService.search(searchBody.getList(), pageable, (LoggedUser)((Object)auth.getPrincipal()), locale, operation == MergeFilterOperation.AND);
        Link selfLink = WebMvcLinkBuilder.linkTo(((TaskController)WebMvcLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).search(auth, pageable, searchBody, operation, assembler, locale)).withRel("search");
        PagedModel resources = assembler.toModel(tasks, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public PagedModel<LocalisedTaskResource> searchPublic(LoggedUser loggedUser, Pageable pageable, SingleTaskSearchRequestAsList searchBody, MergeFilterOperation operation, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        Page<com.netgrif.application.engine.workflow.domain.Task> tasks = this.taskService.search(searchBody.getList(), pageable, loggedUser, locale, operation == MergeFilterOperation.AND);
        Link selfLink = WebMvcLinkBuilder.linkTo(((PublicTaskController)WebMvcLinkBuilder.methodOn(PublicTaskController.class, (Object[])new Object[0])).searchPublic(loggedUser, pageable, searchBody, operation, assembler, locale)).withRel("search");
        PagedModel resources = assembler.toModel(tasks, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public PagedModel<LocalisedTaskResource> searchElastic(Authentication auth, Pageable pageable, SingleElasticTaskSearchRequestAsList searchBody, MergeFilterOperation operation, PagedResourcesAssembler<com.netgrif.application.engine.workflow.domain.Task> assembler, Locale locale) {
        Page<com.netgrif.application.engine.workflow.domain.Task> tasks = this.searchService.search(searchBody.getList(), (LoggedUser)((Object)auth.getPrincipal()), pageable, locale, operation == MergeFilterOperation.AND);
        Link selfLink = WebMvcLinkBuilder.linkTo(((TaskController)WebMvcLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).searchElastic(auth, pageable, searchBody, operation, assembler, locale)).withRel("search_es");
        PagedModel resources = assembler.toModel(tasks, (RepresentationModelAssembler)new TaskResourceAssembler(locale), selfLink);
        ResourceLinkAssembler.addLinks(resources, com.netgrif.application.engine.workflow.domain.Task.class, selfLink.getRel().toString());
        return resources;
    }

    public CountResponse count(SingleElasticTaskSearchRequestAsList query, MergeFilterOperation operation, Authentication auth, Locale locale) {
        long count = this.searchService.count(query.getList(), (LoggedUser)((Object)auth.getPrincipal()), locale, operation == MergeFilterOperation.AND);
        return CountResponse.taskCount(count);
    }

    public EntityModel<EventOutcomeWithMessage> getData(String taskId, Locale locale) {
        try {
            GetDataGroupsEventOutcome outcome = this.dataService.getDataGroups(taskId, locale);
            return EventOutcomeWithMessageResource.successMessage("Get data groups successful", LocalisedEventOutcomeFactory.from(outcome, locale));
        }
        catch (IllegalArgumentWithChangedFieldsException e) {
            log.error("Get data on task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage(), LocalisedEventOutcomeFactory.from(e.getOutcome(), locale));
        }
        catch (Exception e) {
            log.error("Get data on task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage());
        }
    }

    public EntityModel<EventOutcomeWithMessage> setData(String taskId, ObjectNode dataBody, Locale locale) {
        try {
            HashMap<String, SetDataEventOutcome> outcomes = new HashMap<String, SetDataEventOutcome>();
            dataBody.fields().forEachRemaining(it -> outcomes.put((String)it.getKey(), this.dataService.setData((String)it.getKey(), (ObjectNode)((JsonNode)it.getValue()).deepCopy())));
            SetDataEventOutcome mainOutcome = this.taskService.getMainOutcome(outcomes, taskId);
            return EventOutcomeWithMessageResource.successMessage("Data field values have been successfully set", LocalisedEventOutcomeFactory.from(mainOutcome, LocaleContextHolder.getLocale()));
        }
        catch (IllegalArgumentWithChangedFieldsException e) {
            log.error("Set data on task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage(), LocalisedEventOutcomeFactory.from(e.getOutcome(), locale));
        }
        catch (Exception e) {
            log.error("Set data on task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage());
        }
    }

    public EntityModel<EventOutcomeWithMessage> saveFile(String taskId, MultipartFile multipartFile, FileFieldRequest dataBody, Locale locale) {
        try {
            HashMap<String, SetDataEventOutcome> outcomes = new HashMap<String, SetDataEventOutcome>();
            outcomes.put(dataBody.getParentTaskId(), this.dataService.saveFile(dataBody.getParentTaskId(), dataBody.getFieldId(), multipartFile));
            SetDataEventOutcome mainOutcome = this.taskService.getMainOutcome(outcomes, taskId);
            return EventOutcomeWithMessageResource.successMessage("Data field values have been successfully set", LocalisedEventOutcomeFactory.from(mainOutcome, LocaleContextHolder.getLocale()));
        }
        catch (IllegalArgumentWithChangedFieldsException e) {
            log.error("Set data on task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage(), LocalisedEventOutcomeFactory.from(e.getOutcome(), locale));
        }
        catch (Exception e) {
            log.error("Set data on task [" + taskId + "] failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage(e.getMessage());
        }
    }

    public ResponseEntity<Resource> getFile(String taskId, String fieldId) throws FileNotFoundException {
        FileFieldInputStream fileFieldInputStream = this.dataService.getFileByTask(taskId, fieldId, false);
        if (fileFieldInputStream == null || fileFieldInputStream.getInputStream() == null) {
            throw new FileNotFoundException("File in field " + fieldId + " within task " + taskId + " was not found!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        headers.add("Content-Disposition", "attachment; filename=\"" + fileFieldInputStream.getFileName() + "\"");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(fileFieldInputStream.getInputStream()));
    }

    public EntityModel<EventOutcomeWithMessage> deleteFile(String taskId, String fieldId) {
        HashMap<String, SetDataEventOutcome> outcomes = new HashMap<String, SetDataEventOutcome>();
        outcomes.put(taskId, this.dataService.deleteFile(taskId, fieldId));
        SetDataEventOutcome mainOutcome = this.taskService.getMainOutcome(outcomes, taskId);
        return EventOutcomeWithMessageResource.successMessage("Data field values have been sucessfully set", LocalisedEventOutcomeFactory.from(mainOutcome, LocaleContextHolder.getLocale()));
    }

    public EntityModel<EventOutcomeWithMessage> saveFiles(String taskId, MultipartFile[] multipartFiles, FileFieldRequest requestBody) {
        HashMap<String, SetDataEventOutcome> outcomes = new HashMap<String, SetDataEventOutcome>();
        outcomes.put(requestBody.getParentTaskId(), this.dataService.saveFiles(requestBody.getParentTaskId(), requestBody.getFieldId(), multipartFiles));
        SetDataEventOutcome mainOutcome = this.taskService.getMainOutcome(outcomes, taskId);
        return EventOutcomeWithMessageResource.successMessage("Data field values have been sucessfully set", LocalisedEventOutcomeFactory.from(mainOutcome, LocaleContextHolder.getLocale()));
    }

    public ResponseEntity<Resource> getNamedFile(String taskId, String fieldId, String name) throws FileNotFoundException {
        FileFieldInputStream fileFieldInputStream = this.dataService.getFileByTaskAndName(taskId, fieldId, name);
        if (fileFieldInputStream == null || fileFieldInputStream.getInputStream() == null) {
            throw new FileNotFoundException("File with name " + name + " in field " + fieldId + " within task " + taskId + " was not found!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        headers.add("Content-Disposition", "attachment; filename=\"" + fileFieldInputStream.getFileName() + "\"");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(fileFieldInputStream.getInputStream()));
    }

    public EntityModel<EventOutcomeWithMessage> deleteNamedFile(String taskId, String fieldId, String name) {
        HashMap<String, SetDataEventOutcome> outcomes = new HashMap<String, SetDataEventOutcome>();
        outcomes.put(taskId, this.dataService.deleteFileByName(taskId, fieldId, name));
        SetDataEventOutcome mainOutcome = this.taskService.getMainOutcome(outcomes, taskId);
        return EventOutcomeWithMessageResource.successMessage("Data field values have been sucessfully set", LocalisedEventOutcomeFactory.from(mainOutcome, LocaleContextHolder.getLocale()));
    }

    public ResponseEntity<Resource> getFilePreview(String taskId, String fieldId) throws FileNotFoundException {
        FileFieldInputStream fileFieldInputStream = this.dataService.getFileByTask(taskId, fieldId, true);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        headers.add("Content-Disposition", "attachment; filename=" + (String)(fileFieldInputStream != null ? "\"" + fileFieldInputStream.getFileName() + "\"" : "null"));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)(fileFieldInputStream != null ? new InputStreamResource(fileFieldInputStream.getInputStream()) : null));
    }
}

