/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.web;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.workflow.domain.MergeFilterOperation;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessage;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.web.AbstractTaskController;
import com.netgrif.application.engine.workflow.web.requestbodies.file.FileFieldRequest;
import com.netgrif.application.engine.workflow.web.requestbodies.singleaslist.SingleTaskSearchRequestAsList;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedTaskResource;
import com.netgrif.application.engine.workflow.web.responsebodies.TaskReference;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="Public Task Controller")
@ConditionalOnProperty(value={"nae.public.task.web.enabled"}, havingValue="true", matchIfMissing=true)
@RequestMapping(value={"/api/public/task"})
public class PublicTaskController
extends AbstractTaskController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicTaskController.class);
    final IUserService userService;
    private final ITaskService taskService;
    private final IDataService dataService;

    public PublicTaskController(ITaskService taskService, IDataService dataService, IUserService userService) {
        super(taskService, dataService, null);
        this.taskService = taskService;
        this.dataService = dataService;
        this.userService = userService;
    }

    @Override
    @GetMapping(value={"/case/{id}"}, produces={"application/json;charset=UTF-8"})
    @Operation(summary="Get tasks of the case")
    public List<TaskReference> getTasksOfCase(@PathVariable(value="id") String caseId, Locale locale) {
        return this.taskService.findAllByCase(caseId, locale);
    }

    @PreAuthorize(value="@taskAuthorizationService.canCallAssign(@userService.getAnonymousLogged(), #taskId)")
    @GetMapping(value={"/assign/{id}"}, produces={"application/hal+json"})
    @Operation(summary="Assign task", description="Caller must be able to perform the task, or must be an ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> assign(@PathVariable(value="id") String taskId, Locale locale) {
        LoggedUser loggedUser = this.userService.getAnonymousLogged();
        return super.assign(loggedUser, taskId, locale);
    }

    @PreAuthorize(value="@taskAuthorizationService.canCallFinish(@userService.getAnonymousLogged(), #taskId)")
    @GetMapping(value={"/finish/{id}"}, produces={"application/hal+json"})
    @Operation(summary="Finish task", description="Caller must be assigned to the task, or must be an ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> finish(@PathVariable(value="id") String taskId, Locale locale) {
        LoggedUser loggedUser = this.userService.getAnonymousLogged();
        return super.finish(loggedUser, taskId, locale);
    }

    @PreAuthorize(value="@taskAuthorizationService.canCallCancel(@userService.getAnonymousLogged(), #taskId)")
    @GetMapping(value={"/cancel/{id}"}, produces={"application/hal+json"})
    @Operation(summary="Cancel task", description="Caller must be assigned to the task, or must be an ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> cancel(@PathVariable(value="id") String taskId, Locale locale) {
        LoggedUser loggedUser = this.userService.getAnonymousLogged();
        return super.cancel(loggedUser, taskId, locale);
    }

    @Override
    @GetMapping(value={"/{id}/data"}, produces={"application/hal+json"})
    @Operation(summary="Get all task data")
    public EntityModel<EventOutcomeWithMessage> getData(@PathVariable(value="id") String taskId, Locale locale) {
        return super.getData(taskId, locale);
    }

    @Override
    @PreAuthorize(value="@taskAuthorizationService.canCallSaveData(@userService.getAnonymousLogged(), #taskId)")
    @PostMapping(value={"/{id}/data"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    @Operation(summary="Set task data", description="Caller must be assigned to the task, or must be an ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> setData(@PathVariable(value="id") String taskId, @RequestBody ObjectNode dataBody, Locale locale) {
        return super.setData(taskId, dataBody, locale);
    }

    @PreAuthorize(value="@taskAuthorizationService.canCallSaveFile(@userService.getAnonymousLogged(), #taskId)")
    @Operation(summary="Upload file into the task", description="Caller must be assigned to the task, or must be an ADMIN")
    @PostMapping(value={"/{id}/file"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> saveFile(Authentication auth, @PathVariable(value="id") String taskId, @RequestPart(value="data") FileFieldRequest dataBody, @RequestPart(value="file") MultipartFile multipartFile, Locale locale) {
        return super.saveFile(taskId, multipartFile, dataBody, locale);
    }

    @Override
    @Operation(summary="Download task file field value")
    @GetMapping(value={"/{id}/file"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getFile(@PathVariable(value="id") String taskId, @RequestParam(value="fieldId") String fieldId) throws FileNotFoundException {
        return super.getFile(taskId, fieldId);
    }

    @PreAuthorize(value="@taskAuthorizationService.canCallSaveFile(@userService.getAnonymousLogged(), #taskId)")
    @Operation(summary="Remove file from the task", description="Caller must be assigned to the task, or must be an ADMIN")
    @DeleteMapping(value={"/{id}/file"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> deleteFile(@PathVariable(value="id") String taskId, @RequestBody FileFieldRequest requestBody) {
        return super.deleteFile(requestBody.getParentTaskId(), requestBody.getFieldId());
    }

    @Override
    @Operation(summary="Download preview for file field value")
    @GetMapping(value={"/{id}/file_preview"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getFilePreview(@PathVariable(value="id") String taskId, @RequestParam(value="fieldId") String fieldId) throws FileNotFoundException {
        return super.getFilePreview(taskId, fieldId);
    }

    @Override
    @PreAuthorize(value="@taskAuthorizationService.canCallSaveFile(@userService.getAnonymousLogged(), #taskId)")
    @Operation(summary="Upload multiple files into the task", description="Caller must be assigned to the task, or must be an ADMIN")
    @PostMapping(value={"/{id}/files"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> saveFiles(@PathVariable(value="id") String taskId, @RequestPart(value="files") MultipartFile[] multipartFiles, @RequestPart(value="data") FileFieldRequest requestBody) {
        return super.saveFiles(taskId, multipartFiles, requestBody);
    }

    @Override
    @Operation(summary="Download one file from tasks file list field value")
    @GetMapping(value={"/{id}/file/named"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getNamedFile(@PathVariable(value="id") String taskId, @RequestParam(value="fieldId") String fieldId, @RequestParam(value="fileName") String fileName) throws FileNotFoundException {
        return super.getNamedFile(taskId, fieldId, fileName);
    }

    @PreAuthorize(value="@taskAuthorizationService.canCallSaveFile(@userService.getAnonymousLogged(), #taskId)")
    @Operation(summary="Remove file from tasks file list field value", description="Caller must be assigned to the task, or must be an ADMIN")
    @DeleteMapping(value={"/{id}/file/named"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public EntityModel<EventOutcomeWithMessage> deleteNamedFile(@PathVariable(value="id") String taskId, @RequestBody FileFieldRequest requestBody) {
        return super.deleteNamedFile(requestBody.getParentTaskId(), requestBody.getFieldId(), requestBody.getFileName());
    }

    @Operation(summary="Generic task search on Mongo database")
    @PostMapping(value={"/search"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<LocalisedTaskResource> search(Pageable pageable, @RequestBody SingleTaskSearchRequestAsList searchBody, @RequestParam(defaultValue="OR") MergeFilterOperation operation, PagedResourcesAssembler<Task> assembler, Locale locale) {
        return super.searchPublic(this.userService.getAnonymousLogged(), pageable, searchBody, operation, assembler, locale);
    }
}

