/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.web;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.elastic.domain.ElasticCase;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.elastic.web.requestbodies.singleaslist.SingleCaseSearchRequestAsList;
import com.netgrif.application.engine.eventoutcomes.LocalisedEventOutcomeFactory;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.MergeFilterOperation;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.caseoutcomes.CreateCaseEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.caseoutcomes.DeleteCaseEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessage;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessageResource;
import com.netgrif.application.engine.workflow.service.FileFieldInputStream;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.netgrif.application.engine.workflow.web.requestbodies.CreateCaseBody;
import com.netgrif.application.engine.workflow.web.responsebodies.CaseResource;
import com.netgrif.application.engine.workflow.web.responsebodies.CaseResourceAssembler;
import com.netgrif.application.engine.workflow.web.responsebodies.CountResponse;
import com.netgrif.application.engine.workflow.web.responsebodies.DataFieldsResource;
import com.netgrif.application.engine.workflow.web.responsebodies.MessageResource;
import com.netgrif.application.engine.workflow.web.responsebodies.ResourceLinkAssembler;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/workflow"})
@ConditionalOnProperty(value={"nae.case.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="Workflow")
public class WorkflowController {
    private static final Logger log = LoggerFactory.getLogger((String)WorkflowController.class.getName());
    @Autowired
    private IWorkflowService workflowService;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private IElasticCaseService elasticCaseService;
    @Autowired
    private IDataService dataService;

    @PreAuthorize(value="@workflowAuthorizationService.canCallCreate(#auth.getPrincipal(), #body.netId)")
    @Operation(summary="Create new case", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/case"}, consumes={"application/json"}, produces={"application/hal+json"})
    public EntityModel<EventOutcomeWithMessage> createCase(@RequestBody CreateCaseBody body, Authentication auth, Locale locale) {
        LoggedUser loggedUser = (LoggedUser)((Object)auth.getPrincipal());
        try {
            CreateCaseEventOutcome outcome = this.workflowService.createCase(body.netId, body.title, body.color, loggedUser, locale);
            return EventOutcomeWithMessageResource.successMessage("Case with id " + outcome.getCase().getStringId() + " was created succesfully", LocalisedEventOutcomeFactory.from(outcome, locale));
        }
        catch (Exception e) {
            log.error("Creating case failed:", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage("Creating case failed" + e.getMessage());
        }
    }

    @Operation(summary="Get all cases of the system", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/all"}, produces={"application/hal+json"})
    public PagedModel<CaseResource> getAll(Pageable pageable, PagedResourcesAssembler<Case> assembler) {
        Page<Case> cases = this.workflowService.getAll(pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((WorkflowController)WebMvcLinkBuilder.methodOn(WorkflowController.class, (Object[])new Object[0])).getAll(pageable, assembler)).withRel("all");
        PagedModel resources = assembler.toModel(cases, (RepresentationModelAssembler)new CaseResourceAssembler(), selfLink);
        ResourceLinkAssembler.addLinks(resources, Case.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Generic case search with QueryDSL predicate", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/case/search2"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<CaseResource> search2(@QuerydslPredicate(root=Case.class) Predicate predicate, Pageable pageable, PagedResourcesAssembler<Case> assembler) {
        Page<Case> cases = this.workflowService.search(predicate, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((WorkflowController)WebMvcLinkBuilder.methodOn(WorkflowController.class, (Object[])new Object[0])).search2(predicate, pageable, assembler)).withRel("search2");
        PagedModel resources = assembler.toModel(cases, (RepresentationModelAssembler)new CaseResourceAssembler(), selfLink);
        ResourceLinkAssembler.addLinks(resources, Case.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Generic case search on Elasticsearch database", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/case/search"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<CaseResource> search(@RequestBody SingleCaseSearchRequestAsList searchBody, @RequestParam(defaultValue="OR") MergeFilterOperation operation, Pageable pageable, PagedResourcesAssembler<Case> assembler, Authentication auth, Locale locale) {
        LoggedUser user = (LoggedUser)((Object)auth.getPrincipal());
        Page<Case> cases = this.elasticCaseService.search(searchBody.getList(), user, pageable, locale, operation == MergeFilterOperation.AND);
        Link selfLink = WebMvcLinkBuilder.linkTo(((WorkflowController)WebMvcLinkBuilder.methodOn(WorkflowController.class, (Object[])new Object[0])).search(searchBody, operation, pageable, assembler, auth, locale)).withRel("search");
        PagedModel resources = assembler.toModel(cases, (RepresentationModelAssembler)new CaseResourceAssembler(), selfLink);
        ResourceLinkAssembler.addLinks(resources, ElasticCase.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Generic case search on Mongo database", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/case/search_mongo"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<CaseResource> searchMongo(@RequestBody Map<String, Object> searchBody, Pageable pageable, PagedResourcesAssembler<Case> assembler, Authentication auth, Locale locale) {
        Page<Case> cases = this.workflowService.search(searchBody, pageable, (LoggedUser)((Object)auth.getPrincipal()), locale);
        Link selfLink = WebMvcLinkBuilder.linkTo(((WorkflowController)WebMvcLinkBuilder.methodOn(WorkflowController.class, (Object[])new Object[0])).searchMongo(searchBody, pageable, assembler, auth, locale)).withRel("search");
        PagedModel resources = assembler.toModel(cases, (RepresentationModelAssembler)new CaseResourceAssembler(), selfLink);
        ResourceLinkAssembler.addLinks(resources, Case.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Get count of the cases", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/case/count"}, consumes={"application/json"}, produces={"application/json"})
    public CountResponse count(@RequestBody SingleCaseSearchRequestAsList searchBody, @RequestParam(defaultValue="OR") MergeFilterOperation operation, Authentication auth, Locale locale) {
        long count = this.elasticCaseService.count(searchBody.getList(), (LoggedUser)((Object)auth.getPrincipal()), locale, operation == MergeFilterOperation.AND);
        return CountResponse.caseCount(count);
    }

    @Operation(summary="Get case by id", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/case/{id}"}, produces={"application/hal+json"})
    public CaseResource getOne(@PathVariable(value="id") String caseId) {
        Case aCase = this.workflowService.findOne(caseId);
        if (aCase == null) {
            return null;
        }
        return new CaseResource(aCase);
    }

    @Operation(summary="Get all cases by user that created them", security={@SecurityRequirement(name="BasicAuth")})
    @RequestMapping(value={"/case/author/{id}"}, method={RequestMethod.POST}, consumes={"text/plain"}, produces={"application/hal+json"})
    public PagedModel<CaseResource> findAllByAuthor(@PathVariable(value="id") String authorId, @RequestBody String petriNet, Pageable pageable, PagedResourcesAssembler<Case> assembler) {
        Page<Case> cases = this.workflowService.findAllByAuthor(authorId, petriNet, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((WorkflowController)WebMvcLinkBuilder.methodOn(WorkflowController.class, (Object[])new Object[0])).findAllByAuthor(authorId, petriNet, pageable, assembler)).withRel("author");
        PagedModel resources = assembler.toModel(cases, (RepresentationModelAssembler)new CaseResourceAssembler(), selfLink);
        ResourceLinkAssembler.addLinks(resources, Case.class, selfLink.getRel().toString());
        return resources;
    }

    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Reload tasks of case", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/case/reload/{id}"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public MessageResource reloadTasks(@PathVariable(value="id") String caseId) {
        try {
            caseId = URLDecoder.decode(caseId, StandardCharsets.UTF_8.name());
            Case aCase = this.workflowService.findOne(caseId);
            this.taskService.reloadTasks(aCase);
            return MessageResource.successMessage("Task reloaded in case [" + caseId + "]");
        }
        catch (Exception e) {
            log.error("Reloading tasks of case [" + caseId + "] failed:", (Throwable)e);
            return MessageResource.errorMessage("Reloading tasks in case " + caseId + " has failed!");
        }
    }

    @Deprecated
    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Get all case data", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/case/{id}/data"}, produces={"application/hal+json"})
    public DataFieldsResource getAllCaseData(@PathVariable(value="id") String caseId, Locale locale) {
        try {
            caseId = URLDecoder.decode(caseId, StandardCharsets.UTF_8.name());
            return new DataFieldsResource(this.workflowService.getData(caseId), locale);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Getting all case data of [" + caseId + "] failed:", (Throwable)e);
            return new DataFieldsResource(new ArrayList<Field>(), locale);
        }
    }

    @PreAuthorize(value="@workflowAuthorizationService.canCallDelete(#auth.getPrincipal(), #caseId)")
    @Operation(summary="Delete case", security={@SecurityRequirement(name="BasicAuth")})
    @DeleteMapping(value={"/case/{id}"}, produces={"application/hal+json"})
    public EntityModel<EventOutcomeWithMessage> deleteCase(Authentication auth, @PathVariable(value="id") String caseId, @RequestParam(defaultValue="false") boolean deleteSubtree) {
        try {
            caseId = URLDecoder.decode(caseId, StandardCharsets.UTF_8.name());
            DeleteCaseEventOutcome outcome = deleteSubtree ? this.workflowService.deleteSubtreeRootedAt(caseId) : this.workflowService.deleteCase(caseId);
            return EventOutcomeWithMessageResource.successMessage("Case " + caseId + " was deleted", LocalisedEventOutcomeFactory.from(outcome, LocaleContextHolder.getLocale()));
        }
        catch (UnsupportedEncodingException e) {
            log.error("Deleting case [" + caseId + "] failed:", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage("Deleting case " + caseId + " has failed!");
        }
    }

    @Operation(summary="Download case file field value", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/case/{id}/file"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getFile(@PathVariable(value="id") String caseId, @RequestParam(value="fieldId") String fieldId) throws FileNotFoundException {
        FileFieldInputStream fileFieldInputStream = this.dataService.getFileByCase(caseId, null, fieldId, false);
        if (fileFieldInputStream.getInputStream() == null) {
            throw new FileNotFoundException("File in field " + fieldId + " within case " + caseId + " was not found!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        headers.add("Content-Disposition", "attachment; filename=\"" + fileFieldInputStream.getFileName() + "\"");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(fileFieldInputStream.getInputStream()));
    }

    @Operation(summary="Download one file from cases file list field value", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/case/{id}/file/named"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getFileByName(@PathVariable(value="id") String caseId, @RequestParam(value="fieldId") String fieldId, @RequestParam(value="fileName") String name) throws FileNotFoundException {
        FileFieldInputStream fileFieldInputStream = this.dataService.getFileByCaseAndName(caseId, fieldId, name);
        if (fileFieldInputStream.getInputStream() == null) {
            throw new FileNotFoundException("File with name " + name + " in field " + fieldId + " within case " + caseId + " was not found!");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        headers.add("Content-Disposition", "attachment; filename=\"" + fileFieldInputStream.getFileName() + "\"");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(fileFieldInputStream.getInputStream()));
    }
}

