/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.web.responsebodies;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netgrif.application.engine.auth.web.responsebodies.User;
import com.netgrif.application.engine.elastic.domain.ElasticTask;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.petrinet.domain.layout.TaskLayout;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bson.types.ObjectId;

public class Task {
    @JsonIgnore
    private ObjectId _id;
    private String caseId;
    private String transitionId;
    private TaskLayout layout;
    private String title;
    private String caseColor;
    private String caseTitle;
    private Integer priority;
    private User user;
    private Map<String, Map<String, Boolean>> roles;
    private Map<String, Map<String, Boolean>> users;
    private LocalDateTime startDate;
    private LocalDateTime finishDate;
    private String finishedBy;
    private String transactionId;
    private Boolean requiredFilled;
    private List<Field> immediateData;
    private String icon;
    private String assignPolicy;
    private String dataFocusPolicy;
    private String finishPolicy;
    private String finishTitle;
    private String cancelTitle;
    private String delegateTitle;
    private String assignTitle;
    private Map<String, Boolean> assignedUserPolicy;
    private Map<String, String> tags;

    public Task(com.netgrif.application.engine.workflow.domain.Task task, Locale locale) {
        this._id = task.getObjectId();
        this.caseId = task.getCaseId();
        this.transitionId = task.getTransitionId();
        this.layout = task.getLayout();
        this.title = task.getTitle().getTranslation(locale);
        this.caseColor = task.getCaseColor();
        this.caseTitle = task.getCaseTitle();
        this.priority = task.getPriority();
        this.user = task.getUser() != null ? User.createSmallUser(task.getUser()) : null;
        this.roles = task.getRoles();
        this.users = task.getUsers();
        this.startDate = task.getStartDate();
        this.finishDate = task.getFinishDate();
        this.finishedBy = task.getFinishedBy();
        this.transactionId = task.getTransactionId();
        this.requiredFilled = task.getRequiredFilled();
        this.immediateData = task.getImmediateData();
        this.icon = task.getIcon();
        this.assignPolicy = task.getAssignPolicy().toString();
        this.dataFocusPolicy = task.getDataFocusPolicy().toString();
        this.finishPolicy = task.getFinishPolicy().toString();
        this.finishTitle = task.getTranslatedEventTitle(EventType.FINISH, locale);
        this.assignTitle = task.getTranslatedEventTitle(EventType.ASSIGN, locale);
        this.cancelTitle = task.getTranslatedEventTitle(EventType.CANCEL, locale);
        this.delegateTitle = task.getTranslatedEventTitle(EventType.DELEGATE, locale);
        this.assignedUserPolicy = task.getAssignedUserPolicy();
        this.tags = task.getTags();
    }

    public Task(ElasticTask entity) {
        this._id = new ObjectId(entity.getStringId());
        this.caseId = entity.getCaseId();
        this.transitionId = entity.getTransitionId();
        this.title = entity.getTitle();
        this.caseTitle = entity.getCaseTitle();
        this.priority = entity.getPriority();
    }

    public String getStringId() {
        return this._id.toString();
    }

    @Generated
    public ObjectId get_id() {
        return this._id;
    }

    @Generated
    public String getCaseId() {
        return this.caseId;
    }

    @Generated
    public String getTransitionId() {
        return this.transitionId;
    }

    @Generated
    public TaskLayout getLayout() {
        return this.layout;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getCaseColor() {
        return this.caseColor;
    }

    @Generated
    public String getCaseTitle() {
        return this.caseTitle;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getRoles() {
        return this.roles;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUsers() {
        return this.users;
    }

    @Generated
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalDateTime getFinishDate() {
        return this.finishDate;
    }

    @Generated
    public String getFinishedBy() {
        return this.finishedBy;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public Boolean getRequiredFilled() {
        return this.requiredFilled;
    }

    @Generated
    public List<Field> getImmediateData() {
        return this.immediateData;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getAssignPolicy() {
        return this.assignPolicy;
    }

    @Generated
    public String getDataFocusPolicy() {
        return this.dataFocusPolicy;
    }

    @Generated
    public String getFinishPolicy() {
        return this.finishPolicy;
    }

    @Generated
    public String getFinishTitle() {
        return this.finishTitle;
    }

    @Generated
    public String getCancelTitle() {
        return this.cancelTitle;
    }

    @Generated
    public String getDelegateTitle() {
        return this.delegateTitle;
    }

    @Generated
    public String getAssignTitle() {
        return this.assignTitle;
    }

    @Generated
    public Map<String, Boolean> getAssignedUserPolicy() {
        return this.assignedUserPolicy;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonIgnore
    @Generated
    public void set_id(ObjectId _id) {
        this._id = _id;
    }

    @Generated
    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    @Generated
    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    @Generated
    public void setLayout(TaskLayout layout) {
        this.layout = layout;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setCaseColor(String caseColor) {
        this.caseColor = caseColor;
    }

    @Generated
    public void setCaseTitle(String caseTitle) {
        this.caseTitle = caseTitle;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setRoles(Map<String, Map<String, Boolean>> roles) {
        this.roles = roles;
    }

    @Generated
    public void setUsers(Map<String, Map<String, Boolean>> users) {
        this.users = users;
    }

    @Generated
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setFinishDate(LocalDateTime finishDate) {
        this.finishDate = finishDate;
    }

    @Generated
    public void setFinishedBy(String finishedBy) {
        this.finishedBy = finishedBy;
    }

    @Generated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public void setRequiredFilled(Boolean requiredFilled) {
        this.requiredFilled = requiredFilled;
    }

    @Generated
    public void setImmediateData(List<Field> immediateData) {
        this.immediateData = immediateData;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setAssignPolicy(String assignPolicy) {
        this.assignPolicy = assignPolicy;
    }

    @Generated
    public void setDataFocusPolicy(String dataFocusPolicy) {
        this.dataFocusPolicy = dataFocusPolicy;
    }

    @Generated
    public void setFinishPolicy(String finishPolicy) {
        this.finishPolicy = finishPolicy;
    }

    @Generated
    public void setFinishTitle(String finishTitle) {
        this.finishTitle = finishTitle;
    }

    @Generated
    public void setCancelTitle(String cancelTitle) {
        this.cancelTitle = cancelTitle;
    }

    @Generated
    public void setDelegateTitle(String delegateTitle) {
        this.delegateTitle = delegateTitle;
    }

    @Generated
    public void setAssignTitle(String assignTitle) {
        this.assignTitle = assignTitle;
    }

    @Generated
    public void setAssignedUserPolicy(Map<String, Boolean> assignedUserPolicy) {
        this.assignedUserPolicy = assignedUserPolicy;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Boolean this$requiredFilled = this.getRequiredFilled();
        Boolean other$requiredFilled = other.getRequiredFilled();
        if (this$requiredFilled == null ? other$requiredFilled != null : !((Object)this$requiredFilled).equals(other$requiredFilled)) {
            return false;
        }
        ObjectId this$_id = this.get_id();
        ObjectId other$_id = other.get_id();
        if (this$_id == null ? other$_id != null : !this$_id.equals(other$_id)) {
            return false;
        }
        String this$caseId = this.getCaseId();
        String other$caseId = other.getCaseId();
        if (this$caseId == null ? other$caseId != null : !this$caseId.equals(other$caseId)) {
            return false;
        }
        String this$transitionId = this.getTransitionId();
        String other$transitionId = other.getTransitionId();
        if (this$transitionId == null ? other$transitionId != null : !this$transitionId.equals(other$transitionId)) {
            return false;
        }
        TaskLayout this$layout = this.getLayout();
        TaskLayout other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$caseColor = this.getCaseColor();
        String other$caseColor = other.getCaseColor();
        if (this$caseColor == null ? other$caseColor != null : !this$caseColor.equals(other$caseColor)) {
            return false;
        }
        String this$caseTitle = this.getCaseTitle();
        String other$caseTitle = other.getCaseTitle();
        if (this$caseTitle == null ? other$caseTitle != null : !this$caseTitle.equals(other$caseTitle)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Map<String, Map<String, Boolean>> this$roles = this.getRoles();
        Map<String, Map<String, Boolean>> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Map<String, Map<String, Boolean>> this$users = this.getUsers();
        Map<String, Map<String, Boolean>> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        LocalDateTime this$startDate = this.getStartDate();
        LocalDateTime other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalDateTime this$finishDate = this.getFinishDate();
        LocalDateTime other$finishDate = other.getFinishDate();
        if (this$finishDate == null ? other$finishDate != null : !((Object)this$finishDate).equals(other$finishDate)) {
            return false;
        }
        String this$finishedBy = this.getFinishedBy();
        String other$finishedBy = other.getFinishedBy();
        if (this$finishedBy == null ? other$finishedBy != null : !this$finishedBy.equals(other$finishedBy)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        List<Field> this$immediateData = this.getImmediateData();
        List<Field> other$immediateData = other.getImmediateData();
        if (this$immediateData == null ? other$immediateData != null : !((Object)this$immediateData).equals(other$immediateData)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$assignPolicy = this.getAssignPolicy();
        String other$assignPolicy = other.getAssignPolicy();
        if (this$assignPolicy == null ? other$assignPolicy != null : !this$assignPolicy.equals(other$assignPolicy)) {
            return false;
        }
        String this$dataFocusPolicy = this.getDataFocusPolicy();
        String other$dataFocusPolicy = other.getDataFocusPolicy();
        if (this$dataFocusPolicy == null ? other$dataFocusPolicy != null : !this$dataFocusPolicy.equals(other$dataFocusPolicy)) {
            return false;
        }
        String this$finishPolicy = this.getFinishPolicy();
        String other$finishPolicy = other.getFinishPolicy();
        if (this$finishPolicy == null ? other$finishPolicy != null : !this$finishPolicy.equals(other$finishPolicy)) {
            return false;
        }
        String this$finishTitle = this.getFinishTitle();
        String other$finishTitle = other.getFinishTitle();
        if (this$finishTitle == null ? other$finishTitle != null : !this$finishTitle.equals(other$finishTitle)) {
            return false;
        }
        String this$cancelTitle = this.getCancelTitle();
        String other$cancelTitle = other.getCancelTitle();
        if (this$cancelTitle == null ? other$cancelTitle != null : !this$cancelTitle.equals(other$cancelTitle)) {
            return false;
        }
        String this$delegateTitle = this.getDelegateTitle();
        String other$delegateTitle = other.getDelegateTitle();
        if (this$delegateTitle == null ? other$delegateTitle != null : !this$delegateTitle.equals(other$delegateTitle)) {
            return false;
        }
        String this$assignTitle = this.getAssignTitle();
        String other$assignTitle = other.getAssignTitle();
        if (this$assignTitle == null ? other$assignTitle != null : !this$assignTitle.equals(other$assignTitle)) {
            return false;
        }
        Map<String, Boolean> this$assignedUserPolicy = this.getAssignedUserPolicy();
        Map<String, Boolean> other$assignedUserPolicy = other.getAssignedUserPolicy();
        if (this$assignedUserPolicy == null ? other$assignedUserPolicy != null : !((Object)this$assignedUserPolicy).equals(other$assignedUserPolicy)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Boolean $requiredFilled = this.getRequiredFilled();
        result = result * 59 + ($requiredFilled == null ? 43 : ((Object)$requiredFilled).hashCode());
        ObjectId $_id = this.get_id();
        result = result * 59 + ($_id == null ? 43 : $_id.hashCode());
        String $caseId = this.getCaseId();
        result = result * 59 + ($caseId == null ? 43 : $caseId.hashCode());
        String $transitionId = this.getTransitionId();
        result = result * 59 + ($transitionId == null ? 43 : $transitionId.hashCode());
        TaskLayout $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $caseColor = this.getCaseColor();
        result = result * 59 + ($caseColor == null ? 43 : $caseColor.hashCode());
        String $caseTitle = this.getCaseTitle();
        result = result * 59 + ($caseTitle == null ? 43 : $caseTitle.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Map<String, Map<String, Boolean>> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Map<String, Map<String, Boolean>> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        LocalDateTime $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalDateTime $finishDate = this.getFinishDate();
        result = result * 59 + ($finishDate == null ? 43 : ((Object)$finishDate).hashCode());
        String $finishedBy = this.getFinishedBy();
        result = result * 59 + ($finishedBy == null ? 43 : $finishedBy.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        List<Field> $immediateData = this.getImmediateData();
        result = result * 59 + ($immediateData == null ? 43 : ((Object)$immediateData).hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $assignPolicy = this.getAssignPolicy();
        result = result * 59 + ($assignPolicy == null ? 43 : $assignPolicy.hashCode());
        String $dataFocusPolicy = this.getDataFocusPolicy();
        result = result * 59 + ($dataFocusPolicy == null ? 43 : $dataFocusPolicy.hashCode());
        String $finishPolicy = this.getFinishPolicy();
        result = result * 59 + ($finishPolicy == null ? 43 : $finishPolicy.hashCode());
        String $finishTitle = this.getFinishTitle();
        result = result * 59 + ($finishTitle == null ? 43 : $finishTitle.hashCode());
        String $cancelTitle = this.getCancelTitle();
        result = result * 59 + ($cancelTitle == null ? 43 : $cancelTitle.hashCode());
        String $delegateTitle = this.getDelegateTitle();
        result = result * 59 + ($delegateTitle == null ? 43 : $delegateTitle.hashCode());
        String $assignTitle = this.getAssignTitle();
        result = result * 59 + ($assignTitle == null ? 43 : $assignTitle.hashCode());
        Map<String, Boolean> $assignedUserPolicy = this.getAssignedUserPolicy();
        result = result * 59 + ($assignedUserPolicy == null ? 43 : ((Object)$assignedUserPolicy).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Task(_id=" + this.get_id() + ", caseId=" + this.getCaseId() + ", transitionId=" + this.getTransitionId() + ", layout=" + this.getLayout() + ", title=" + this.getTitle() + ", caseColor=" + this.getCaseColor() + ", caseTitle=" + this.getCaseTitle() + ", priority=" + this.getPriority() + ", user=" + this.getUser() + ", roles=" + this.getRoles() + ", users=" + this.getUsers() + ", startDate=" + this.getStartDate() + ", finishDate=" + this.getFinishDate() + ", finishedBy=" + this.getFinishedBy() + ", transactionId=" + this.getTransactionId() + ", requiredFilled=" + this.getRequiredFilled() + ", immediateData=" + this.getImmediateData() + ", icon=" + this.getIcon() + ", assignPolicy=" + this.getAssignPolicy() + ", dataFocusPolicy=" + this.getDataFocusPolicy() + ", finishPolicy=" + this.getFinishPolicy() + ", finishTitle=" + this.getFinishTitle() + ", cancelTitle=" + this.getCancelTitle() + ", delegateTitle=" + this.getDelegateTitle() + ", assignTitle=" + this.getAssignTitle() + ", assignedUserPolicy=" + this.getAssignedUserPolicy() + ", tags=" + this.getTags() + ")";
    }
}

