/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.workflow.web.responsebodies.eventoutcomes.base;

import com.netgrif.application.engine.eventoutcomes.LocalisedEventOutcomeFactory;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FrontAction;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.EventOutcome;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class LocalisedEventOutcome {
    private String message;
    private List<LocalisedEventOutcome> outcomes;
    private List<FrontAction> frontActions;

    protected LocalisedEventOutcome() {
    }

    protected LocalisedEventOutcome(EventOutcome outcome, Locale locale) {
        this.message = outcome.getMessage() == null ? null : outcome.getMessage().getTranslation(locale);
        this.frontActions = outcome.getFrontActions();
        this.outcomes = outcome.getOutcomes() == null ? null : outcome.getOutcomes().stream().map(eventOutcome -> LocalisedEventOutcomeFactory.from(eventOutcome, locale)).collect(Collectors.toList());
    }

    protected LocalisedEventOutcome(String message, List<LocalisedEventOutcome> outcomes) {
        this.message = message;
        this.outcomes = outcomes;
    }

    public void addOutcome(LocalisedEventOutcome outcome) {
        this.outcomes.add(outcome);
    }

    public void addOutcomes(List<LocalisedEventOutcome> outcomes) {
        this.outcomes.addAll(outcomes);
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<LocalisedEventOutcome> getOutcomes() {
        return this.outcomes;
    }

    @Generated
    public List<FrontAction> getFrontActions() {
        return this.frontActions;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setOutcomes(List<LocalisedEventOutcome> outcomes) {
        this.outcomes = outcomes;
    }

    @Generated
    public void setFrontActions(List<FrontAction> frontActions) {
        this.frontActions = frontActions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalisedEventOutcome)) {
            return false;
        }
        LocalisedEventOutcome other = (LocalisedEventOutcome)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<LocalisedEventOutcome> this$outcomes = this.getOutcomes();
        List<LocalisedEventOutcome> other$outcomes = other.getOutcomes();
        if (this$outcomes == null ? other$outcomes != null : !((Object)this$outcomes).equals(other$outcomes)) {
            return false;
        }
        List<FrontAction> this$frontActions = this.getFrontActions();
        List<FrontAction> other$frontActions = other.getFrontActions();
        return !(this$frontActions == null ? other$frontActions != null : !((Object)this$frontActions).equals(other$frontActions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalisedEventOutcome;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<LocalisedEventOutcome> $outcomes = this.getOutcomes();
        result = result * 59 + ($outcomes == null ? 43 : ((Object)$outcomes).hashCode());
        List<FrontAction> $frontActions = this.getFrontActions();
        result = result * 59 + ($frontActions == null ? 43 : ((Object)$frontActions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalisedEventOutcome(message=" + this.getMessage() + ", outcomes=" + this.getOutcomes() + ", frontActions=" + this.getFrontActions() + ")";
    }
}

