/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb;

import com.netgrif.quartz.mongodb.util.SerialUtils;
import java.io.IOException;
import java.util.Map;
import org.bson.Document;
import org.quartz.JobDataMap;
import org.quartz.JobPersistenceException;

public class JobDataConverter {
    private final boolean base64Preferred;

    public JobDataConverter(boolean base64Preferred) {
        this.base64Preferred = base64Preferred;
    }

    public void toDocument(JobDataMap from, Document to) throws JobPersistenceException {
        if (from.isEmpty()) {
            return;
        }
        if (this.base64Preferred) {
            String jobDataString;
            try {
                jobDataString = SerialUtils.serialize(from);
            }
            catch (IOException e) {
                throw new JobPersistenceException("Could not serialise job data.", (Throwable)e);
            }
            to.put("jobData", (Object)jobDataString);
        } else {
            to.put("jobDataPlain", (Object)from.getWrappedMap());
        }
    }

    public boolean toJobData(Document from, JobDataMap to) throws JobPersistenceException {
        if (this.base64Preferred) {
            return this.toJobDataFromBase64(from, to);
        }
        if (this.toJobDataFromField(from, to)) {
            return true;
        }
        return this.toJobDataFromBase64(from, to);
    }

    private boolean toJobDataFromBase64(Document from, JobDataMap to) throws JobPersistenceException {
        Map<String, ?> jobDataMap;
        String jobDataBase64String = from.getString((Object)"jobData");
        if (jobDataBase64String == null) {
            return false;
        }
        try {
            jobDataMap = SerialUtils.deserialize(null, jobDataBase64String);
        }
        catch (IOException e) {
            throw new JobPersistenceException("Could not deserialize job data.", (Throwable)e);
        }
        to.putAll(jobDataMap);
        return true;
    }

    private boolean toJobDataFromField(Document from, JobDataMap to) {
        Map jobDataMap = (Map)from.get((Object)"jobDataPlain", Map.class);
        if (jobDataMap == null) {
            return false;
        }
        to.putAll(jobDataMap);
        return true;
    }
}

