/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb;

import com.mongodb.client.MongoCollection;
import com.netgrif.quartz.mongodb.JobCompleteHandler;
import com.netgrif.quartz.mongodb.JobConverter;
import com.netgrif.quartz.mongodb.JobDataConverter;
import com.netgrif.quartz.mongodb.LockManager;
import com.netgrif.quartz.mongodb.MongoDBJobStore;
import com.netgrif.quartz.mongodb.TriggerAndJobPersister;
import com.netgrif.quartz.mongodb.TriggerRunner;
import com.netgrif.quartz.mongodb.TriggerStateManager;
import com.netgrif.quartz.mongodb.cluster.CheckinExecutor;
import com.netgrif.quartz.mongodb.cluster.CheckinTask;
import com.netgrif.quartz.mongodb.cluster.KamikazeErrorHandler;
import com.netgrif.quartz.mongodb.cluster.RecoveryTriggerFactory;
import com.netgrif.quartz.mongodb.cluster.TriggerRecoverer;
import com.netgrif.quartz.mongodb.dao.CalendarDao;
import com.netgrif.quartz.mongodb.dao.JobDao;
import com.netgrif.quartz.mongodb.dao.LocksDao;
import com.netgrif.quartz.mongodb.dao.PausedJobGroupsDao;
import com.netgrif.quartz.mongodb.dao.PausedTriggerGroupsDao;
import com.netgrif.quartz.mongodb.dao.SchedulerDao;
import com.netgrif.quartz.mongodb.dao.TriggerDao;
import com.netgrif.quartz.mongodb.db.MongoConnector;
import com.netgrif.quartz.mongodb.db.MongoConnectorBuilder;
import com.netgrif.quartz.mongodb.trigger.MisfireHandler;
import com.netgrif.quartz.mongodb.trigger.TriggerConverter;
import com.netgrif.quartz.mongodb.util.Clock;
import com.netgrif.quartz.mongodb.util.ExpiryCalculator;
import com.netgrif.quartz.mongodb.util.QueryHelper;
import java.util.Properties;
import org.bson.Document;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;

public class MongoStoreAssembler {
    public MongoConnector mongoConnector;
    public JobCompleteHandler jobCompleteHandler;
    public LockManager lockManager;
    public TriggerStateManager triggerStateManager;
    public TriggerRunner triggerRunner;
    public TriggerAndJobPersister persister;
    public CalendarDao calendarDao;
    public JobDao jobDao;
    public LocksDao locksDao;
    public SchedulerDao schedulerDao;
    public PausedJobGroupsDao pausedJobGroupsDao;
    public PausedTriggerGroupsDao pausedTriggerGroupsDao;
    public TriggerDao triggerDao;
    public TriggerRecoverer triggerRecoverer;
    public CheckinExecutor checkinExecutor;
    private QueryHelper queryHelper = new QueryHelper();
    private TriggerConverter triggerConverter;

    public void build(MongoDBJobStore jobStore, ClassLoadHelper loadHelper, SchedulerSignaler signaler, Properties quartzProps) throws SchedulerConfigException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.mongoConnector = this.createMongoConnector(jobStore);
        JobDataConverter jobDataConverter = new JobDataConverter(jobStore.isJobDataAsBase64());
        this.jobDao = this.createJobDao(jobStore, loadHelper, jobDataConverter);
        this.triggerConverter = new TriggerConverter(this.jobDao, jobDataConverter);
        this.triggerDao = this.createTriggerDao(jobStore);
        this.calendarDao = this.createCalendarDao(jobStore);
        this.locksDao = this.createLocksDao(jobStore);
        this.pausedJobGroupsDao = this.createPausedJobGroupsDao(jobStore);
        this.pausedTriggerGroupsDao = this.createPausedTriggerGroupsDao(jobStore);
        this.schedulerDao = this.createSchedulerDao(jobStore);
        this.persister = this.createTriggerAndJobPersister();
        this.jobCompleteHandler = this.createJobCompleteHandler(signaler);
        this.lockManager = this.createLockManager(jobStore);
        this.triggerStateManager = this.createTriggerStateManager();
        MisfireHandler misfireHandler = this.createMisfireHandler(jobStore, signaler);
        RecoveryTriggerFactory recoveryTriggerFactory = new RecoveryTriggerFactory(jobStore.instanceId);
        this.triggerRecoverer = new TriggerRecoverer(this.locksDao, this.persister, this.lockManager, this.triggerDao, this.jobDao, recoveryTriggerFactory, misfireHandler);
        this.triggerRunner = this.createTriggerRunner(misfireHandler);
        this.checkinExecutor = this.createCheckinExecutor(jobStore, loadHelper, quartzProps);
    }

    private CheckinExecutor createCheckinExecutor(MongoDBJobStore jobStore, ClassLoadHelper loadHelper, Properties quartzProps) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new CheckinExecutor(this.createCheckinTask(jobStore, loadHelper), jobStore.clusterCheckinIntervalMillis, jobStore.instanceId);
    }

    private Runnable createCheckinTask(MongoDBJobStore jobStore, ClassLoadHelper loadHelper) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class aClass = jobStore.getCheckInErrorHandler() == null ? KamikazeErrorHandler.class : loadHelper.loadClass(jobStore.getCheckInErrorHandler());
        Runnable errorHandler = (Runnable)aClass.newInstance();
        return new CheckinTask(this.schedulerDao, errorHandler);
    }

    private CalendarDao createCalendarDao(MongoDBJobStore jobStore) {
        return new CalendarDao(this.getCollection(jobStore, "calendars"));
    }

    private JobDao createJobDao(MongoDBJobStore jobStore, ClassLoadHelper loadHelper, JobDataConverter jobDataConverter) {
        JobConverter jobConverter = new JobConverter(jobStore.getClassLoaderHelper(loadHelper), jobDataConverter);
        return new JobDao(this.getCollection(jobStore, "jobs"), this.queryHelper, jobConverter);
    }

    private JobCompleteHandler createJobCompleteHandler(SchedulerSignaler signaler) {
        return new JobCompleteHandler(this.persister, signaler, this.jobDao, this.locksDao, this.triggerDao);
    }

    private LocksDao createLocksDao(MongoDBJobStore jobStore) {
        return new LocksDao(this.getCollection(jobStore, "locks"), Clock.SYSTEM_CLOCK, jobStore.instanceId);
    }

    private LockManager createLockManager(MongoDBJobStore jobStore) {
        ExpiryCalculator expiryCalculator = new ExpiryCalculator(this.schedulerDao, Clock.SYSTEM_CLOCK, jobStore.jobTimeoutMillis, jobStore.triggerTimeoutMillis, jobStore.isClustered());
        return new LockManager(this.locksDao, expiryCalculator);
    }

    private MisfireHandler createMisfireHandler(MongoDBJobStore jobStore, SchedulerSignaler signaler) {
        return new MisfireHandler(this.calendarDao, signaler, jobStore.misfireThreshold);
    }

    private MongoConnector createMongoConnector(MongoDBJobStore jobStore) throws SchedulerConfigException {
        return MongoConnectorBuilder.builder().withConnector(jobStore.mongoConnector).withDatabase(jobStore.mongoDatabase).withClient(jobStore.mongo).withUri(jobStore.mongoUri).withCredentials(jobStore.username, jobStore.password).withAddresses(jobStore.addresses).withDatabaseName(jobStore.dbName).withAuthDatabaseName(jobStore.authDbName).withMaxConnections(jobStore.mongoOptionMaxConnections).withConnectTimeoutMillis(jobStore.mongoOptionConnectTimeoutMillis).withReadTimeoutMillis(jobStore.mongoOptionReadTimeoutMillis).withSocketKeepAlive(jobStore.mongoOptionSocketKeepAlive).withSSL(jobStore.mongoOptionEnableSSL, jobStore.mongoOptionSslInvalidHostNameAllowed).withTrustStore(jobStore.mongoOptionTrustStorePath, jobStore.mongoOptionTrustStorePassword, jobStore.mongoOptionTrustStoreType).withKeyStore(jobStore.mongoOptionKeyStorePath, jobStore.mongoOptionKeyStorePassword, jobStore.mongoOptionKeyStoreType).withWriteConcernWriteTimeout(jobStore.mongoOptionWriteConcernTimeoutMillis).withWriteConcernW(jobStore.mongoOptionWriteConcernW).build();
    }

    private PausedJobGroupsDao createPausedJobGroupsDao(MongoDBJobStore jobStore) {
        return new PausedJobGroupsDao(this.getCollection(jobStore, "paused_job_groups"));
    }

    private PausedTriggerGroupsDao createPausedTriggerGroupsDao(MongoDBJobStore jobStore) {
        return new PausedTriggerGroupsDao(this.getCollection(jobStore, "paused_trigger_groups"));
    }

    private SchedulerDao createSchedulerDao(MongoDBJobStore jobStore) {
        return new SchedulerDao(this.getCollection(jobStore, "schedulers"), jobStore.schedulerName, jobStore.instanceId, jobStore.clusterCheckinIntervalMillis, Clock.SYSTEM_CLOCK);
    }

    private TriggerAndJobPersister createTriggerAndJobPersister() {
        return new TriggerAndJobPersister(this.triggerDao, this.jobDao, this.triggerConverter);
    }

    private TriggerDao createTriggerDao(MongoDBJobStore jobStore) {
        return new TriggerDao(this.getCollection(jobStore, "triggers"), this.queryHelper, this.triggerConverter);
    }

    private TriggerRunner createTriggerRunner(MisfireHandler misfireHandler) {
        return new TriggerRunner(this.persister, this.triggerDao, this.jobDao, this.locksDao, this.calendarDao, misfireHandler, this.triggerConverter, this.lockManager, this.triggerRecoverer);
    }

    private TriggerStateManager createTriggerStateManager() {
        return new TriggerStateManager(this.triggerDao, this.jobDao, this.pausedJobGroupsDao, this.pausedTriggerGroupsDao, this.queryHelper);
    }

    private MongoCollection<Document> getCollection(MongoDBJobStore jobStore, String name) {
        return this.mongoConnector.getCollection(jobStore.collectionPrefix + name);
    }
}

