/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb;

import com.netgrif.quartz.mongodb.dao.JobDao;
import com.netgrif.quartz.mongodb.dao.PausedJobGroupsDao;
import com.netgrif.quartz.mongodb.dao.PausedTriggerGroupsDao;
import com.netgrif.quartz.mongodb.dao.TriggerDao;
import com.netgrif.quartz.mongodb.util.GroupHelper;
import com.netgrif.quartz.mongodb.util.QueryHelper;
import com.netgrif.quartz.mongodb.util.TriggerGroupHelper;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class TriggerStateManager {
    private final TriggerDao triggerDao;
    private final JobDao jobDao;
    private PausedJobGroupsDao pausedJobGroupsDao;
    private final PausedTriggerGroupsDao pausedTriggerGroupsDao;
    private final QueryHelper queryHelper;

    public TriggerStateManager(TriggerDao triggerDao, JobDao jobDao, PausedJobGroupsDao pausedJobGroupsDao, PausedTriggerGroupsDao pausedTriggerGroupsDao, QueryHelper queryHelper) {
        this.triggerDao = triggerDao;
        this.jobDao = jobDao;
        this.pausedJobGroupsDao = pausedJobGroupsDao;
        this.pausedTriggerGroupsDao = pausedTriggerGroupsDao;
        this.queryHelper = queryHelper;
    }

    public Set<String> getPausedTriggerGroups() {
        return this.pausedTriggerGroupsDao.getPausedGroups();
    }

    public Trigger.TriggerState getState(TriggerKey triggerKey) {
        return this.getTriggerState(this.triggerDao.getState(triggerKey));
    }

    public void pause(TriggerKey triggerKey) {
        this.triggerDao.setState(triggerKey, "paused");
    }

    public Collection<String> pause(GroupMatcher<TriggerKey> matcher) {
        this.triggerDao.setStateInMatching(matcher, "paused");
        GroupHelper groupHelper = new GroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        Set<String> set = groupHelper.groupsThatMatch(matcher);
        this.pausedTriggerGroupsDao.pauseGroups(set);
        return set;
    }

    public void pauseAll() {
        GroupHelper groupHelper = new GroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        this.triggerDao.setStateInAll("paused");
        this.pausedTriggerGroupsDao.pauseGroups(groupHelper.allGroups());
    }

    public void pauseJob(JobKey jobKey) {
        ObjectId jobId = this.jobDao.getJob(jobKey).getObjectId((Object)"_id");
        TriggerGroupHelper groupHelper = new TriggerGroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        List<String> groups = groupHelper.groupsForJobId(jobId);
        this.triggerDao.setStateByJobId(jobId, "paused");
        this.pausedTriggerGroupsDao.pauseGroups(groups);
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        TriggerGroupHelper groupHelper = new TriggerGroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        List<String> groups = groupHelper.groupsForJobIds(this.jobDao.idsOfMatching(groupMatcher));
        this.triggerDao.setStateInGroups(groups, "paused");
        this.pausedJobGroupsDao.pauseGroups(groups);
        return groups;
    }

    public void resume(TriggerKey triggerKey) {
        this.triggerDao.setState(triggerKey, "waiting");
    }

    public Collection<String> resume(GroupMatcher<TriggerKey> matcher) {
        this.triggerDao.setStateInMatching(matcher, "waiting");
        GroupHelper groupHelper = new GroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        Set<String> set = groupHelper.groupsThatMatch(matcher);
        this.pausedTriggerGroupsDao.unpauseGroups(set);
        return set;
    }

    public void resume(JobKey jobKey) {
        ObjectId jobId = this.jobDao.getJob(jobKey).getObjectId((Object)"_id");
        this.triggerDao.setStateByJobId(jobId, "waiting");
    }

    public void resumeAll() {
        GroupHelper groupHelper = new GroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        this.triggerDao.setStateInAll("waiting");
        this.pausedTriggerGroupsDao.unpauseGroups(groupHelper.allGroups());
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        TriggerGroupHelper groupHelper = new TriggerGroupHelper(this.triggerDao.getCollection(), this.queryHelper);
        List<String> groups = groupHelper.groupsForJobIds(this.jobDao.idsOfMatching(groupMatcher));
        this.triggerDao.setStateInGroups(groups, "waiting");
        this.pausedJobGroupsDao.unpauseGroups(groups);
        return groups;
    }

    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        String currentState = this.triggerDao.getState(triggerKey);
        if (!"error".equals(currentState)) {
            return;
        }
        String newState = "waiting";
        if (this.pausedTriggerGroupsDao.getPausedGroups().contains(triggerKey.getGroup())) {
            newState = "paused";
        }
        this.triggerDao.transferState(triggerKey, "error", newState);
    }

    private Trigger.TriggerState getTriggerState(String value) {
        if (value == null) {
            return Trigger.TriggerState.NONE;
        }
        if (value.equals("deleted")) {
            return Trigger.TriggerState.NONE;
        }
        if (value.equals("complete")) {
            return Trigger.TriggerState.COMPLETE;
        }
        if (value.equals("paused")) {
            return Trigger.TriggerState.PAUSED;
        }
        if (value.equals("pausedBlocked")) {
            return Trigger.TriggerState.PAUSED;
        }
        if (value.equals("error")) {
            return Trigger.TriggerState.ERROR;
        }
        if (value.equals("blocked")) {
            return Trigger.TriggerState.BLOCKED;
        }
        return Trigger.TriggerState.NORMAL;
    }
}

