/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.dao;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.result.UpdateResult;
import com.netgrif.quartz.mongodb.util.Clock;
import com.netgrif.quartz.mongodb.util.Keys;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocksDao {
    private static final Logger log = LoggerFactory.getLogger(LocksDao.class);
    private final MongoCollection<Document> locksCollection;
    private Clock clock;
    public final String instanceId;

    public LocksDao(MongoCollection<Document> locksCollection, Clock clock, String instanceId) {
        this.locksCollection = locksCollection;
        this.clock = clock;
        this.instanceId = instanceId;
    }

    public MongoCollection<Document> getCollection() {
        return this.locksCollection;
    }

    public void createIndex(boolean clustered) {
        this.locksCollection.createIndex(Projections.include((String[])new String[]{"keyGroup", "keyName", "type"}), new IndexOptions().unique(true));
        if (!clustered) {
            this.locksCollection.createIndex(Projections.include((String[])new String[]{"instanceId"}));
            this.locksCollection.deleteMany(Filters.eq((String)"instanceId", (Object)this.instanceId));
        }
    }

    public void dropIndex() {
        this.locksCollection.dropIndex("keyName_1_keyGroup_1");
        this.locksCollection.dropIndex(Keys.KEY_AND_GROUP_FIELDS);
    }

    public Document findJobLock(JobKey job) {
        Bson filter = Keys.createJobLockFilter(job);
        return (Document)this.locksCollection.find(filter).first();
    }

    public Document findTriggerLock(TriggerKey trigger) {
        Bson filter = Keys.createTriggerLockFilter(trigger);
        return (Document)this.locksCollection.find(filter).first();
    }

    public List<TriggerKey> findOwnTriggersLocks() {
        LinkedList<TriggerKey> keys = new LinkedList<TriggerKey>();
        Bson filter = Keys.createTriggersLocksFilter(this.instanceId);
        for (Document doc : this.locksCollection.find(filter)) {
            keys.add(Keys.toTriggerKey(doc));
        }
        return keys;
    }

    public void lockJob(JobDetail job) {
        log.debug("Inserting lock for job {}", (Object)job.getKey());
        Document lock = Keys.createJobLock(job.getKey(), this.instanceId, this.clock.now());
        this.insertLock(lock);
    }

    public void lockTrigger(TriggerKey key) {
        log.info("Inserting lock for trigger {}", (Object)key);
        Document lock = Keys.createTriggerLock(key, this.instanceId, this.clock.now());
        this.insertLock(lock);
    }

    public boolean relock(TriggerKey key, Date lockTime) {
        UpdateResult updateResult;
        try {
            updateResult = this.locksCollection.updateOne(Keys.createRelockFilter(key, lockTime), (Bson)Keys.createLockUpdateDocument(this.instanceId, this.clock.now()));
        }
        catch (MongoException e) {
            log.error("Relock failed because: " + e.getMessage(), (Throwable)e);
            return false;
        }
        if (updateResult.getModifiedCount() == 1L) {
            log.info("Scheduler {} relocked the trigger: {}", (Object)this.instanceId, (Object)key);
            return true;
        }
        log.info("Scheduler {} couldn't relock the trigger {} with lock time: {}", new Object[]{this.instanceId, key, lockTime.getTime()});
        return false;
    }

    public boolean updateOwnLock(TriggerKey key) throws JobPersistenceException {
        UpdateResult updateResult;
        try {
            updateResult = this.locksCollection.updateMany(Keys.toFilter(key, this.instanceId), (Bson)Keys.createLockUpdateDocument(this.instanceId, this.clock.now()));
        }
        catch (MongoException e) {
            log.error("Lock refresh failed because: " + e.getMessage(), (Throwable)e);
            throw new JobPersistenceException("Lock refresh for scheduler: " + this.instanceId, (Throwable)e);
        }
        if (updateResult.getModifiedCount() == 1L) {
            log.info("Scheduler {} refreshed locking time.", (Object)this.instanceId);
            return true;
        }
        log.info("Scheduler {} couldn't refresh locking time", (Object)this.instanceId);
        return false;
    }

    public void remove(Document lock) {
        this.locksCollection.deleteMany((Bson)lock);
    }

    public void unlockTrigger(OperableTrigger trigger) {
        log.info("Removing trigger lock {}.{}", (Object)trigger.getKey(), (Object)this.instanceId);
        this.remove(Keys.toFilter(trigger.getKey(), this.instanceId));
        log.info("Trigger lock {}.{} removed.", (Object)trigger.getKey(), (Object)this.instanceId);
    }

    public void unlockJob(JobDetail job) {
        log.debug("Removing lock for job {}", (Object)job.getKey());
        this.remove(Keys.createJobLockFilter(job.getKey()));
    }

    private void insertLock(Document lock) {
        this.locksCollection.insertOne((Object)lock);
    }

    private void remove(Bson filter) {
        this.locksCollection.deleteMany(filter);
    }
}

