/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.dao;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PausedTriggerGroupsDao {
    private final MongoCollection<Document> triggerGroupsCollection;

    public PausedTriggerGroupsDao(MongoCollection<Document> triggerGroupsCollection) {
        this.triggerGroupsCollection = triggerGroupsCollection;
    }

    public HashSet<String> getPausedGroups() {
        return (HashSet)this.triggerGroupsCollection.distinct("keyGroup", String.class).into(new HashSet());
    }

    public void pauseGroups(Collection<String> groups) {
        ArrayList<Document> list = new ArrayList<Document>();
        for (String s : groups) {
            list.add(new Document("keyGroup", (Object)s));
        }
        this.triggerGroupsCollection.insertMany(list);
    }

    public void remove() {
        this.triggerGroupsCollection.deleteMany((Bson)new Document());
    }

    public void unpauseGroups(Collection<String> groups) {
        this.triggerGroupsCollection.deleteMany(Filters.in((String)"keyGroup", groups));
    }
}

