/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.dao;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.netgrif.quartz.mongodb.cluster.Scheduler;
import com.netgrif.quartz.mongodb.util.Clock;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerDao {
    private static final Logger log = LoggerFactory.getLogger(SchedulerDao.class);
    public static final String SCHEDULER_NAME_FIELD = "schedulerName";
    public static final String INSTANCE_ID_FIELD = "instanceId";
    public static final String LAST_CHECKIN_TIME_FIELD = "lastCheckinTime";
    public static final String CHECKIN_INTERVAL_FIELD = "checkinInterval";
    public final MongoCollection<Document> schedulerCollection;
    public final String schedulerName;
    public final String instanceId;
    public final long clusterCheckinIntervalMillis;
    public final Clock clock;
    private final Bson schedulerFilter;

    public SchedulerDao(MongoCollection<Document> schedulerCollection, String schedulerName, String instanceId, long clusterCheckinIntervalMillis, Clock clock) {
        this.schedulerCollection = schedulerCollection;
        this.schedulerName = schedulerName;
        this.instanceId = instanceId;
        this.schedulerFilter = this.createSchedulerFilter(schedulerName, instanceId);
        this.clusterCheckinIntervalMillis = clusterCheckinIntervalMillis;
        this.clock = clock;
    }

    public MongoCollection<Document> getCollection() {
        return this.schedulerCollection;
    }

    public void createIndex() {
        this.schedulerCollection.createIndex(Projections.include((String[])new String[]{SCHEDULER_NAME_FIELD, INSTANCE_ID_FIELD}), new IndexOptions().unique(true));
    }

    public void checkIn() {
        long lastCheckinTime = this.clock.millis();
        log.debug("Saving node data: name='{}', id='{}', checkin time={}, interval={}", new Object[]{this.schedulerName, this.instanceId, lastCheckinTime, this.clusterCheckinIntervalMillis});
        Document update = this.createUpdateClause(lastCheckinTime);
        UpdateResult result = this.schedulerCollection.updateOne(this.schedulerFilter, (Bson)update, new UpdateOptions().upsert(true));
        log.debug("Node {}:{} check-in result: {}", new Object[]{this.schedulerName, this.instanceId, result});
    }

    public Scheduler findInstance(String instanceId) {
        log.debug("Finding scheduler instance: {}", (Object)instanceId);
        Document doc = (Document)this.schedulerCollection.find(this.createSchedulerFilter(this.schedulerName, instanceId)).first();
        Scheduler scheduler = null;
        if (doc != null) {
            scheduler = this.toScheduler(doc);
            log.debug("Returning scheduler instance '{}' with last checkin time: {}", (Object)scheduler.getInstanceId(), (Object)scheduler.getLastCheckinTime());
        } else {
            log.info("Scheduler instance '{}' not found.");
        }
        return scheduler;
    }

    public boolean isNotSelf(Scheduler scheduler) {
        return !this.instanceId.equals(scheduler.getInstanceId());
    }

    public List<Scheduler> getAllByCheckinTime() {
        LinkedList<Scheduler> schedulers = new LinkedList<Scheduler>();
        this.schedulerCollection.find().sort(Sorts.ascending((String[])new String[]{LAST_CHECKIN_TIME_FIELD})).forEach(this.createResultConverter(schedulers));
        return schedulers;
    }

    public boolean remove(String instanceId, long lastCheckinTime) {
        log.info("Removing scheduler: {},{},{}", new Object[]{this.schedulerName, instanceId, lastCheckinTime});
        DeleteResult result = this.schedulerCollection.deleteOne(this.createSchedulerFilter(this.schedulerName, instanceId, lastCheckinTime));
        log.info("Result of removing scheduler ({},{},{}): {}", new Object[]{this.schedulerName, instanceId, lastCheckinTime, result});
        return result.getDeletedCount() == 1L;
    }

    private Bson createSchedulerFilter(String schedulerName, String instanceId, long lastCheckinTime) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)SCHEDULER_NAME_FIELD, (Object)schedulerName), Filters.eq((String)INSTANCE_ID_FIELD, (Object)instanceId), Filters.eq((String)LAST_CHECKIN_TIME_FIELD, (Object)lastCheckinTime)});
    }

    private Bson createSchedulerFilter(String schedulerName, String instanceId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)SCHEDULER_NAME_FIELD, (Object)schedulerName), Filters.eq((String)INSTANCE_ID_FIELD, (Object)instanceId)});
    }

    private Document createUpdateClause(long lastCheckinTime) {
        return new Document("$set", (Object)new Document().append(LAST_CHECKIN_TIME_FIELD, (Object)lastCheckinTime).append(CHECKIN_INTERVAL_FIELD, (Object)this.clusterCheckinIntervalMillis));
    }

    private Consumer<Document> createResultConverter(List<Scheduler> schedulers) {
        return document -> schedulers.add(this.toScheduler((Document)document));
    }

    private Scheduler toScheduler(Document document) {
        return new Scheduler(document.getString((Object)SCHEDULER_NAME_FIELD), document.getString((Object)INSTANCE_ID_FIELD), document.getLong((Object)LAST_CHECKIN_TIME_FIELD), document.getLong((Object)CHECKIN_INTERVAL_FIELD));
    }
}

