/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.db;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.netgrif.quartz.mongodb.db.MongoConnector;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalMongoConnector
implements MongoConnector {
    private static final Logger log = LoggerFactory.getLogger(ExternalMongoConnector.class);
    private final WriteConcern writeConcern;
    private final MongoDatabase database;

    public ExternalMongoConnector(WriteConcern writeConcern, MongoDatabase database) {
        this.database = database;
        this.writeConcern = writeConcern;
    }

    public ExternalMongoConnector(MongoClient mongoClient, String dbName) {
        this(WriteConcern.W1, mongoClient.getDatabase(dbName));
    }

    public ExternalMongoConnector(WriteConcern writeConcern, MongoClient mongoClient, String dbName) {
        this(writeConcern, mongoClient.getDatabase(dbName));
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.database.getCollection(collectionName).withWriteConcern(this.writeConcern);
    }

    @Override
    public void close() {
    }
}

