/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.db;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

public class SSLContextFactory {
    public SSLContext getSSLContext(String trustStorePath, String trustStorePassword, String trustStoreType, String keyStorePath, String keyStorePassword, String keyStoreType) throws SSLException {
        try {
            KeyStore trustStore = this.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
            KeyStore keyStore = this.loadKeyStore(keyStorePath, keyStorePassword, keyStoreType);
            if (trustStore == null && keyStore == null) {
                return null;
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (trustStore != null) {
                sslContextBuilder.loadTrustMaterial(trustStore, null);
            }
            if (keyStore != null) {
                sslContextBuilder.loadKeyMaterial(keyStore, StringUtils.isBlank((CharSequence)keyStorePassword) ? null : keyStorePassword.toCharArray());
            }
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SSLException("Cannot setup SSL context", e);
        }
    }

    private KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance((String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType()));
        char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
        try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwordChars);
        }
        return keyStore;
    }
}

