/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.trigger;

import com.netgrif.quartz.mongodb.trigger.properties.CalendarIntervalTriggerPropertiesConverter;
import com.netgrif.quartz.mongodb.trigger.properties.CronTriggerPropertiesConverter;
import com.netgrif.quartz.mongodb.trigger.properties.DailyTimeIntervalTriggerPropertiesConverter;
import com.netgrif.quartz.mongodb.trigger.properties.SimpleTriggerPropertiesConverter;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.quartz.spi.OperableTrigger;

public abstract class TriggerPropertiesConverter {
    private static final List<TriggerPropertiesConverter> propertiesConverters = Arrays.asList(new SimpleTriggerPropertiesConverter(), new CalendarIntervalTriggerPropertiesConverter(), new CronTriggerPropertiesConverter(), new DailyTimeIntervalTriggerPropertiesConverter());

    public static TriggerPropertiesConverter getConverterFor(OperableTrigger trigger) {
        for (TriggerPropertiesConverter converter : propertiesConverters) {
            if (!converter.canHandle(trigger)) continue;
            return converter;
        }
        return null;
    }

    protected abstract boolean canHandle(OperableTrigger var1);

    public abstract Document injectExtraPropertiesForInsert(OperableTrigger var1, Document var2);

    public abstract void setExtraPropertiesAfterInstantiation(OperableTrigger var1, Document var2);
}

