/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.trigger.properties;

import com.netgrif.quartz.mongodb.trigger.TriggerPropertiesConverter;
import java.util.Map;
import org.bson.Document;
import org.quartz.DateBuilder;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CalendarIntervalTriggerPropertiesConverter
extends TriggerPropertiesConverter {
    private static final String TRIGGER_REPEAT_INTERVAL_UNIT = "repeatIntervalUnit";
    private static final String TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String TRIGGER_TIMES_TRIGGERED = "timesTriggered";

    @Override
    protected boolean canHandle(OperableTrigger trigger) {
        return trigger instanceof CalendarIntervalTriggerImpl && !((CalendarIntervalTriggerImpl)trigger).hasAdditionalProperties();
    }

    @Override
    public Document injectExtraPropertiesForInsert(OperableTrigger trigger, Document original) {
        CalendarIntervalTriggerImpl t = (CalendarIntervalTriggerImpl)trigger;
        return new Document((Map)original).append(TRIGGER_REPEAT_INTERVAL_UNIT, (Object)t.getRepeatIntervalUnit().name()).append(TRIGGER_REPEAT_INTERVAL, (Object)t.getRepeatInterval()).append(TRIGGER_TIMES_TRIGGERED, (Object)t.getTimesTriggered());
    }

    @Override
    public void setExtraPropertiesAfterInstantiation(OperableTrigger trigger, Document stored) {
        Integer timesTriggered;
        Integer repeatInterval;
        CalendarIntervalTriggerImpl t = (CalendarIntervalTriggerImpl)trigger;
        String repeatIntervalUnit = stored.getString((Object)TRIGGER_REPEAT_INTERVAL_UNIT);
        if (repeatIntervalUnit != null) {
            t.setRepeatIntervalUnit(DateBuilder.IntervalUnit.valueOf((String)repeatIntervalUnit));
        }
        if ((repeatInterval = stored.getInteger((Object)TRIGGER_REPEAT_INTERVAL)) != null) {
            t.setRepeatInterval(repeatInterval.intValue());
        }
        if ((timesTriggered = stored.getInteger((Object)TRIGGER_TIMES_TRIGGERED)) != null) {
            t.setTimesTriggered(timesTriggered.intValue());
        }
    }
}

