/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.trigger.properties;

import com.netgrif.quartz.mongodb.trigger.TriggerPropertiesConverter;
import java.util.Map;
import org.bson.Document;
import org.quartz.SimpleTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class SimpleTriggerPropertiesConverter
extends TriggerPropertiesConverter {
    private static final String TRIGGER_REPEAT_COUNT = "repeatCount";
    private static final String TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String TRIGGER_TIMES_TRIGGERED = "timesTriggered";

    @Override
    protected boolean canHandle(OperableTrigger trigger) {
        return trigger instanceof SimpleTriggerImpl && !((SimpleTriggerImpl)trigger).hasAdditionalProperties();
    }

    @Override
    public Document injectExtraPropertiesForInsert(OperableTrigger trigger, Document original) {
        SimpleTrigger t = (SimpleTrigger)trigger;
        return new Document((Map)original).append(TRIGGER_REPEAT_COUNT, (Object)t.getRepeatCount()).append(TRIGGER_REPEAT_INTERVAL, (Object)t.getRepeatInterval()).append(TRIGGER_TIMES_TRIGGERED, (Object)t.getTimesTriggered());
    }

    @Override
    public void setExtraPropertiesAfterInstantiation(OperableTrigger trigger, Document stored) {
        Integer timesTriggered;
        Long repeatInterval;
        SimpleTriggerImpl t = (SimpleTriggerImpl)trigger;
        Integer repeatCount = stored.getInteger((Object)TRIGGER_REPEAT_COUNT);
        if (repeatCount != null) {
            t.setRepeatCount(repeatCount.intValue());
        }
        if ((repeatInterval = stored.getLong((Object)TRIGGER_REPEAT_INTERVAL)) != null) {
            t.setRepeatInterval(repeatInterval.longValue());
        }
        if ((timesTriggered = stored.getInteger((Object)TRIGGER_TIMES_TRIGGERED)) != null) {
            t.setTimesTriggered(timesTriggered.intValue());
        }
    }
}

