/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.util;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.quartz.utils.Key;

public class Keys {
    public static final String LOCK_TYPE = "type";
    public static final String KEY_NAME = "keyName";
    public static final String KEY_GROUP = "keyGroup";
    public static final Bson KEY_AND_GROUP_FIELDS = Projections.include((String[])new String[]{"keyGroup", "keyName"});

    public static Bson createJobLockFilter(JobKey key) {
        return Keys.createLockFilter(LockType.j, key);
    }

    public static Bson createTriggerLockFilter(TriggerKey triggerKey) {
        return Keys.createLockFilter(LockType.t, triggerKey);
    }

    public static Bson createTriggersLocksFilter(String instanceId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"instanceId", (Object)instanceId), Filters.eq((String)LOCK_TYPE, (Object)LockType.t.name())});
    }

    public static Bson createLockRefreshFilter(String instanceId) {
        return Filters.eq((String)"instanceId", (Object)instanceId);
    }

    public static Bson createRelockFilter(TriggerKey key, Date lockTime) {
        return Filters.and((Bson[])new Bson[]{Keys.createTriggerLockFilter(key), Keys.createLockTimeFilter(lockTime)});
    }

    public static Document createJobLock(JobKey jobKey, String instanceId, Date lockTime) {
        return Keys.createLock(LockType.j, instanceId, jobKey, lockTime);
    }

    public static Document createTriggerLock(TriggerKey triggerKey, String instanceId, Date lockTime) {
        return Keys.createLock(LockType.t, instanceId, triggerKey, lockTime);
    }

    public static Bson toFilter(Key<?> key) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_GROUP, (Object)key.getGroup()), Filters.eq((String)KEY_NAME, (Object)key.getName())});
    }

    public static Bson toFilter(Key<?> key, String instanceId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_GROUP, (Object)key.getGroup()), Filters.eq((String)KEY_NAME, (Object)key.getName()), Filters.eq((String)"instanceId", (Object)instanceId)});
    }

    public static JobKey toJobKey(Document dbo) {
        return new JobKey(dbo.getString((Object)KEY_NAME), dbo.getString((Object)KEY_GROUP));
    }

    public static TriggerKey toTriggerKey(Document dbo) {
        return new TriggerKey(dbo.getString((Object)KEY_NAME), dbo.getString((Object)KEY_GROUP));
    }

    private static Document createLock(LockType type, String instanceId, Key<?> key, Date lockTime) {
        Document lock = new Document();
        lock.put(LOCK_TYPE, (Object)type.name());
        lock.put(KEY_GROUP, (Object)key.getGroup());
        lock.put(KEY_NAME, (Object)key.getName());
        lock.put("instanceId", (Object)instanceId);
        lock.put("time", (Object)lockTime);
        return lock;
    }

    public static Document createLockUpdateDocument(String instanceId, Date newLockTime) {
        return new Document("$set", (Object)new Document().append("instanceId", (Object)instanceId).append("time", (Object)newLockTime));
    }

    private static <T> Bson createLockFilter(LockType type, Key<T> key) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)LOCK_TYPE, (Object)type.name()), Filters.eq((String)KEY_GROUP, (Object)key.getGroup()), Filters.eq((String)KEY_NAME, (Object)key.getName())});
    }

    private static Bson createLockTimeFilter(Date lockTime) {
        return Filters.eq((String)"time", (Object)lockTime);
    }

    public static enum LockType {
        t,
        j;

    }
}

