/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.util;

import com.mongodb.client.model.Filters;
import java.util.Collection;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.quartz.impl.matchers.GroupMatcher;

public class QueryHelper {
    public Bson matchingKeysConditionFor(GroupMatcher<?> matcher) {
        String compareToValue = matcher.getCompareToValue();
        switch (matcher.getCompareWithOperator()) {
            case EQUALS: {
                return Filters.eq((String)"keyGroup", (Object)compareToValue);
            }
            case STARTS_WITH: {
                return Filters.regex((String)"keyGroup", (String)("^" + compareToValue + ".*"));
            }
            case ENDS_WITH: {
                return Filters.regex((String)"keyGroup", (String)(".*" + compareToValue + "$"));
            }
            case CONTAINS: {
                return Filters.regex((String)"keyGroup", (String)compareToValue);
            }
        }
        return new BsonDocument();
    }

    public Bson inGroups(Collection<String> groups) {
        return Filters.in((String)"keyGroup", groups);
    }
}

