/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.quartz.mongodb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.bson.types.Binary;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobPersistenceException;

public class SerialUtils {
    private static final String SERIALIZE_MESSAGE_FORMAT = "Unable to serialize JobDataMap for insertion into database because the value of property '%s' is not serializable: %s";

    public static Object serialize(Calendar calendar) throws JobPersistenceException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(calendar);
            objectStream.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new JobPersistenceException("Could not serialize Calendar.", (Throwable)e);
        }
    }

    public static <T> T deserialize(Binary serialized, Class<T> clazz) throws JobPersistenceException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serialized.getData());
        try {
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            Object deserialized = objectStream.readObject();
            objectStream.close();
            if (clazz.isInstance(deserialized)) {
                Object obj = deserialized;
                return (T)obj;
            }
            throw new JobPersistenceException("Deserialized object is not of the desired type");
        }
        catch (IOException | ClassNotFoundException e) {
            throw new JobPersistenceException("Could not deserialize.", (Throwable)e);
        }
    }

    public static String serialize(JobDataMap jobDataMap) throws IOException {
        try {
            byte[] bytes = SerialUtils.stringMapToBytes(jobDataMap.getWrappedMap());
            return Base64.encodeBase64String((byte[])bytes);
        }
        catch (NotSerializableException e) {
            return SerialUtils.rethrowEnhanced(jobDataMap, e);
        }
    }

    public static Map<String, ?> deserialize(JobDataMap jobDataMap, String clob) throws IOException {
        try {
            byte[] bytes = Base64.decodeBase64((String)clob);
            return SerialUtils.stringMapFromBytes(bytes);
        }
        catch (NotSerializableException e) {
            SerialUtils.rethrowEnhanced(jobDataMap, e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return Collections.emptyMap();
    }

    private static byte[] stringMapToBytes(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(object);
        out.flush();
        return baos.toByteArray();
    }

    private static Map<String, ?> stringMapFromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Map map = (Map)ois.readObject();
        ois.close();
        return map;
    }

    private static String rethrowEnhanced(JobDataMap jobDataMap, NotSerializableException e) throws NotSerializableException {
        String key = SerialUtils.getKeyOfNonSerializableStringMapEntry(jobDataMap.getWrappedMap());
        throw new NotSerializableException(String.format(SERIALIZE_MESSAGE_FORMAT, key, e.getMessage()));
    }

    private static String getKeyOfNonSerializableStringMapEntry(Map<String, ?> data) {
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(baos);
                out.writeObject(entry.getValue());
                out.flush();
            }
            catch (IOException e) {
                return entry.getKey();
            }
        }
        return null;
    }
}

